/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine.multi;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import galaxyspace.GalaxySpace;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.register.GSItems;
import galaxyspace.core.tile.machine.multi.GT_MetaTileEntity_EnhancedMultiBlockBase_EM;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDysonSwarm
extends GT_MetaTileEntity_EnhancedMultiBlockBase_EM {
    private static Consumer<TileEntityDysonSwarm> moduleDestroyer;
    private static IIconContainer OVERLAY_FRONT_GLOW;
    private static IIconContainer OVERLAY_FRONT_ACTIVE_GLOW;
    private static ITexture OVERLAY_FRONT;
    private static ITexture OVERLAY_FRONT_ACTIVE;
    private static Map<String, Double> powerFactors;
    private static final Map<Locale, DecimalFormat> DECIMAL_FORMATTERS;
    private static final String LORE_TOOLTIP;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final int CASING_INDEX_RECEIVER = 150;
    private static final int CASING_INDEX_COMMAND = 151;
    private static final int CASING_INDEX_LAUNCH = 152;
    private static final int CASING_INDEX_FLOOR = 153;
    private static final IStructureDefinition<TileEntityDysonSwarm> STRUCTURE_DEFINITION;
    private long euPerTick = 0L;
    private double powerFactor = 0.0;
    private int moduleCount = 0;

    protected TileEntityDysonSwarm(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected TileEntityDysonSwarm(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TileEntityDysonSwarm(this.mName);
    }

    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        this.powerFactor = this.getPowerFactor();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 10, 18, 3, stackSize, hintsOnly);
    }

    @Override
    public IStructureDefinition<? extends GT_MetaTileEntity_MultiblockBase_EM> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 10, 18, 3) && this.mMaintenanceHatches.size() == 1 && this.mInputBusses.size() > 0 && this.mInputHatches.size() > 0 && this.eInputData.size() > 0 && (this.mDynamoHatches.size() > 0 || this.eDynamoMulti.size() > 0);
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
            if (!TileEntityDysonSwarm.isValidMetaTileEntity((MetaTileEntity)bus)) continue;
            for (int i = 0; i < bus.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                ItemStack stack = bus.getBaseMetaTileEntity().func_70301_a(i);
                if (stack == null || stack.func_77973_b() != GSItems.DysonSwarmItems || stack.func_77960_j() != 0 || this.moduleCount >= GSConfigCore.maxModules + 1) continue;
                int usedStackSize = Math.min(stack.field_77994_a, GSConfigCore.maxModules - this.moduleCount);
                this.moduleCount += usedStackSize;
                stack.field_77994_a -= usedStackSize;
            }
        }
        this.euPerTick = (long)((double)((long)this.moduleCount * (long)GSConfigCore.euPerModule) * this.powerFactor);
        if (this.moduleCount > 0 && this.depleteInput(GSConfigCore.coolantFluid)) {
            moduleDestroyer.accept(this);
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = 72000;
            return true;
        }
        this.mEfficiency = 0;
        return false;
    }

    public boolean energyFlowOnRunningTick(ItemStack aStack, boolean allowProduction) {
        if (allowProduction && this.euPerTick > 0L) {
            this.addEnergyOutput_EM(this.euPerTick, 1L);
        }
        return true;
    }

    public boolean addEnergyOutput_EM(long EU, long Amperes) {
        return this.addEnergyOutput_EM(EU, Amperes, true);
    }

    public boolean addEnergyOutput_EM(long EU, long Amperes, boolean allowMixedVoltages) {
        long diff;
        if (EU < 0L) {
            EU = -EU;
        }
        if (Amperes < 0L) {
            Amperes = -Amperes;
        }
        long euVar = EU * Amperes;
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : this.mDynamoHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            if (tHatch.maxEUOutput() < euVar && !allowMixedVoltages) {
                this.explodeMultiblock();
            }
            if ((diff = tHatch.maxEUStore() - tHatch.getBaseMetaTileEntity().getStoredEU()) <= 0L) continue;
            if (euVar > diff) {
                tHatch.setEUVar(tHatch.maxEUStore());
                euVar -= diff;
                continue;
            }
            if (euVar > diff) continue;
            tHatch.setEUVar(tHatch.getBaseMetaTileEntity().getStoredEU() + euVar);
            return true;
        }
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : this.eDynamoMulti) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            if (tHatch.maxEUOutput() < euVar && !allowMixedVoltages) {
                this.explodeMultiblock();
            }
            if ((diff = tHatch.maxEUStore() - tHatch.getBaseMetaTileEntity().getStoredEU()) <= 0L) continue;
            if (euVar > diff) {
                tHatch.setEUVar(tHatch.maxEUStore());
                euVar -= diff;
                continue;
            }
            if (euVar > diff) continue;
            tHatch.setEUVar(tHatch.getBaseMetaTileEntity().getStoredEU() + euVar);
            return true;
        }
        this.explodeMultiblock();
        return false;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        ItemStack heldItem = aPlayer.func_70694_bm();
        if (heldItem == null || heldItem.func_77973_b() != GT_MetaGenerated_Tool_01.INSTANCE || heldItem.func_77960_j() != 44) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer);
        }
        int prevCount = this.moduleCount;
        int maxReduction = (int)Math.min((long)this.moduleCount, GT_MetaGenerated_Tool_01.getToolMaxDamage((ItemStack)heldItem) - GT_MetaGenerated_Tool_01.getToolDamage((ItemStack)heldItem));
        ItemStack modules = new ItemStack(GSItems.DysonSwarmItems, maxReduction);
        aPlayer.field_71071_by.func_70441_a(modules);
        if (modules.field_77994_a > 0 && aPlayer.func_70093_af()) {
            aPlayer.field_70170_p.func_72838_d((Entity)new EntityItem(aPlayer.field_70170_p, aPlayer.field_70165_t, aPlayer.field_70163_u + 0.5, aPlayer.field_70161_v, modules));
            this.moduleCount = 0;
            GT_MetaGenerated_Tool_01.INSTANCE.doDamage(heldItem, (long)maxReduction);
        } else {
            this.moduleCount = prevCount - maxReduction + modules.field_77994_a;
            GT_MetaGenerated_Tool_01.INSTANCE.doDamage(heldItem, (long)(maxReduction - modules.field_77994_a));
        }
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)150), TextureFactory.of((ITexture[])new ITexture[]{OVERLAY_FRONT_ACTIVE}), TextureFactory.builder().addIcon(new IIconContainer[]{OVERLAY_FRONT_ACTIVE_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)150), TextureFactory.of((ITexture[])new ITexture[]{OVERLAY_FRONT}), TextureFactory.builder().addIcon(new IIconContainer[]{OVERLAY_FRONT_GLOW}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)150)};
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        String eu_module = TileEntityDysonSwarm.getDecimalFormat().format(GSConfigCore.euPerModule);
        String a = TileEntityDysonSwarm.getDecimalFormat().format(GSConfigCore.destroyModule_a);
        String fluid_amount = TileEntityDysonSwarm.getDecimalFormat().format(GSConfigCore.coolantConsumption);
        String fluid_name = GSConfigCore.coolantFluid.getLocalizedName();
        String base_chance = TileEntityDysonSwarm.getDecimalFormat().format(GSConfigCore.destroyModuleBase_chance);
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Dyson Swarm").addInfo(EnumChatFormatting.ITALIC + LORE_TOOLTIP).addInfo("Controller Block for the Dyson Swarm Command Center").addInfo("Put Dyson Swarm Modules in the Input Bus(ses) to send them to the next star.").addInfo("Outputs " + eu_module + "*f EU/t, where f is a dimension-dependent factor.").addInfo("Each second, n of m Dyson Swarm Modules are destroyed according to this formula:").addInfo(" Each hour, n of m modules are destroyed according to this formula: n = m * (2 * " + base_chance + ") / (exp(-" + a + "* (m - 1))+exp(" + GSConfigCore.destroyModuleBase_chance + " * cps)), where cps is computation per second.").addInfo("Requires " + fluid_amount + "L/h of " + fluid_name + ".").addInfo("R-Click with a Plunger to extract as many Modules to your inventory as possible.").addInfo("Sneaking will dump the rest on the ground.").addSeparator().beginStructureBlock(16, 20, 16, false).addStructureInfo(EnumChatFormatting.ITALIC + "This structure is too complex to describe, use the Multiblock Structure Hologram Projector!").addDynamoHatch("Can use Single- and/or Multi-Amp Dynamo Hatches and/or Laser Source Hatches (1 - 12)", new int[]{1}).addMaintenanceHatch("1", new int[]{3}).addInputBus("1 - 11", new int[]{2}).addInputHatch("1 - 11", new int[]{2}).addOtherStructurePart("Optical Slave Connector", "1 - 24", new int[]{4}).addStructureInfo("").addStructureInfo(EnumChatFormatting.ITALIC + "Additionally needed:").addStructureInfo("Energy Receiver Base Casing: 53 - 64 (depending on the amount of Dynamo Hatches)").addStructureInfo("Energy Receiver Dish Block: 81").addStructureInfo("Module Deployment Unit Base Casing: 62 - 72 (depending on the amount of Input Busses & Hatches)").addStructureInfo("Module Deployment Unit Core: 1").addStructureInfo("Module Deployment Unit Superconducting Magnet: 32").addStructureInfo("Control Center Base Casing: 115 - 138 (depending on the amount of Optical Slave Connectors)").addStructureInfo("Control Center Primary Windings: 20").addStructureInfo("Control Center Secondary Windings: 12").addStructureInfo("Control Center Toroid Casing: 128").addStructureInfo("Ultra High Strength Concrete Floor: 255").addStructureInfo("Awakened Draconium Coil Block: 9").addStructureInfo("Hermetic Casing X: 1").addStructureInfo("Titanium Frame Box: 16").addStructureInfo("HSS-S Frame Box: 23").addStructureInfo("Superconductor Base UHV Frame Box: 64").toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GalaxySpace");
        return tt;
    }

    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.LIGHT_PURPLE + "Operational Data:" + EnumChatFormatting.RESET, "Modules: " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.moduleCount) + EnumChatFormatting.RESET, "Power Factor: " + (this.powerFactor < 1.0 ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + GT_Utility.formatNumbers((double)(this.powerFactor * 100.0)) + "%" + EnumChatFormatting.RESET, "Theoretical Output: " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((double)((double)((long)this.moduleCount * (long)GSConfigCore.euPerModule) * this.powerFactor)) + EnumChatFormatting.RESET + " EU/t", "Current Output: " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.euPerTick) + EnumChatFormatting.RESET + " EU/t", "Computation required: " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.eRequiredData) + EnumChatFormatting.RESET + "/t", "Maintenance Status: " + (this.getRepairStatus() == this.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has problems" + EnumChatFormatting.RESET), "---------------------------------------------"};
    }

    public double getPowerFactor() {
        WorldProvider provider = this.getBaseMetaTileEntity().getWorld().field_73011_w;
        if (provider instanceof IOrbitDimension) {
            return powerFactors.getOrDefault("SS_" + ((IOrbitDimension)provider).getPlanetToOrbit(), GSConfigCore.powerFactorDefault);
        }
        if (provider.getClass().getName().equals("zarkov.utilityworlds.UW_WorldProviderGarden")) {
            return powerFactors.getOrDefault("UW_Garden", GSConfigCore.powerFactorDefault);
        }
        if (provider.getClass().getName().equals("zarkov.utilityworlds.UW_WorldProviderMining")) {
            return powerFactors.getOrDefault("UW_Mining", GSConfigCore.powerFactorDefault);
        }
        if (provider.getClass().getName().equals("zarkov.utilityworlds.UW_WorldProviderVoid")) {
            return powerFactors.getOrDefault("UW_Void", GSConfigCore.powerFactorDefault);
        }
        return powerFactors.getOrDefault(String.valueOf(provider.field_76574_g), GSConfigCore.powerFactorDefault);
    }

    private static DecimalFormat getDecimalFormat() {
        return DECIMAL_FORMATTERS.computeIfAbsent(Locale.getDefault(Locale.Category.FORMAT), locale -> {
            DecimalFormat format = new DecimalFormat();
            format.setGroupingUsed(true);
            format.setMaximumFractionDigits(5);
            format.setRoundingMode(RoundingMode.HALF_UP);
            DecimalFormatSymbols dfs = format.getDecimalFormatSymbols();
            dfs.setGroupingSeparator(',');
            format.setDecimalFormatSymbols(dfs);
            return format;
        });
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.moduleCount = aNBT.func_74762_e("moduleCount");
        this.euPerTick = aNBT.func_74763_f("euPerTick");
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("moduleCount", this.moduleCount);
        aNBT.func_74772_a("euPerTick", this.euPerTick);
    }

    public static void initCommon() {
        GSItems.DysonSwarmController = new TileEntityDysonSwarm(14001, "DysonSwarm", "Dyson Swarm Ground Unit").getStackForm(1L);
        powerFactors = new HashMap<String, Double>();
        for (String s : GSConfigCore.powerFactors) {
            String[] parts = s.split(":");
            try {
                powerFactors.put(parts[0], Double.parseDouble(parts[1]));
            }
            catch (Exception e) {
                GalaxySpace.error("Error while trying to parse \"" + s + "\"!");
                e.printStackTrace();
            }
        }
        moduleDestroyer = GSConfigCore.destroyModule_a > 0.0 ? tile -> {
            tile.moduleCount = (int)((double)tile.moduleCount - (double)tile.moduleCount * (2.0 * GSConfigCore.destroyModuleBase_chance) / (Math.exp(-GSConfigCore.destroyModule_a * (double)(tile.moduleCount - 1)) + Math.exp(GSConfigCore.destroyModule_b * (double)Math.min(tile.eAvailableData, (long)GSConfigCore.destroyModuleMaxCPS))));
            if (tile.moduleCount < 0) {
                tile.moduleCount = 0;
            }
        } : tile -> {};
    }

    public static void initClient() {
        TileEntityDysonSwarm.initCommon();
        Textures.BlockIcons.setCasingTextureForId((int)150, (ITexture)TextureFactory.of((Block)GSBlocks.DysonSwarmBlocks, (int)0));
        Textures.BlockIcons.setCasingTextureForId((int)152, (ITexture)TextureFactory.of((Block)GSBlocks.DysonSwarmBlocks, (int)2));
        Textures.BlockIcons.setCasingTextureForId((int)151, (ITexture)TextureFactory.of((Block)GSBlocks.DysonSwarmBlocks, (int)5));
        Textures.BlockIcons.setCasingTextureForId((int)153, (ITexture)TextureFactory.of((Block)GSBlocks.DysonSwarmBlocks, (int)9));
        OVERLAY_FRONT = TextureFactory.of((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_DYSONSPHERE"));
        OVERLAY_FRONT_ACTIVE = TextureFactory.of((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_DYSONSPHERE_ACTIVE"));
        OVERLAY_FRONT_GLOW = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_DYSONSPHERE_GLOW");
        OVERLAY_FRONT_ACTIVE_GLOW = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_FRONT_DYSONSPHERE_ACTIVE_GLOW");
    }

    static {
        DECIMAL_FORMATTERS = new HashMap<Locale, DecimalFormat>();
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "  ttt           ", "  ttt        k  ", "  ttt       k k ", "             k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " ttttt          ", " ttttt       k  ", " ttttt      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " ttttt          ", " ttttt       k  ", " ttttt      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " ttttt          ", " ttttt       k  ", " ttttt      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "  ttt           ", "  tst        k  ", "  ttt       k k ", "             k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----------", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "                ", "   s         k  ", "            k k ", "             k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----h-----", "     -----------", "      --------- ", "       -------  ", "        -----   ", "  ttt    ---    ", " t g t          ", " tgsgt       k  ", " t g t      k k ", "  ttt        k  ", "                "}, {"         ---    ", "        -----   ", "       -------  ", "      --------- ", "     -----------", "     -----f-----", "     -----------", "      --------- ", "       -------  ", "        -----   ", "         ---    ", "                ", "   s         k  ", "            k k ", "             k  ", "                "}, {"         ddd    ", "        d---d   ", "       d-----d  ", "      d-------d ", "     d---------d", "     d----f----d", "     d---------d", "      d-------d ", "       d-----d  ", "        d---d   ", "  ttt    ddd    ", " t g t          ", " tgsgt      kmk ", " t g t      m m ", "  ttt       kmk ", "                "}, {"                ", "         ddd    ", "        ddddd   ", "       dd---dd  ", "      dd-----dd ", "      dd--f--dd ", "      dd-----dd ", "       dd---dd  ", "        ddddd   ", "         ddd    ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "         ddd    ", "        ddddd   ", "        ddddd   ", "        ddddd   ", "         ddd    ", "                ", "                ", "  ttt           ", " t g t          ", " tgsgt      kmk ", " t g t      m m ", "  ttt       kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "  ttt           ", " t g t          ", " tgsgt      kmk ", " t g t      m m ", "  ttt       kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "                ", "                ", "   s        kmk ", "            m m ", "            kmk ", "                "}, {"                ", "                ", "                ", "                ", "         f f    ", "                ", "         f f    ", "                ", "                ", "                ", "  ppp           ", " p   p          ", " p s p      kmk ", " p   p      m m ", "  ppp       kmk ", "                "}, {"                ", "                ", "                ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "                ", "yyyyyyy         ", "yyyyyyy         ", "yypppyy    zzzzz", "yypypyy    zzzzz", "yypppyy    zzjzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz"}, {"                ", "                ", "                ", "        xeeex   ", "        eccce   ", "        eccce   ", "        eccce   ", "        xeeex   ", "                ", "ooooooo         ", "oyyyyyo         ", "oyyyyyo    ziiiz", "oyyyyyo    izzzi", "oyyyyyo    izzzi", "oyyyyyo    izzzi", "ooooooo    ziiiz"}, {"                ", "                ", "                ", "        xx~xx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "        xxxxx   ", "                ", "yyyyyyy         ", "yyyyyyy         ", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz", "yyyyyyy    zzzzz"}, {"bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbnbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbbb"}})).addElement('b', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)9)).addElement('c', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings5, (int)8)).addElement('d', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)1)).addElement('e', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addDynamoToMachineList, (int)150, (int)1), StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)0)})).addElement('f', GT_StructureUtility.ofFrame((Materials)Materials.HSSS)).addElement('g', GT_StructureUtility.ofFrame((Materials)Materials.Titanium)).addElement('h', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings6, (int)10)).addElement('i', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addInputToMachineList, (int)152, (int)2), StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)2)})).addElement('j', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)3)).addElement('k', GT_StructureUtility.ofFrame((Materials)Materials.Longasssuperconductornameforuhvwire)).addElement('m', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)4)).addElement('n', (IStructureElement)GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicMaintenanceToMachineList, (int)153, (int)3)).addElement('o', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addDataConnectorToMachineList, (int)151, (int)4), StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)5)})).addElement('p', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)6)).addElement('s', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)7)).addElement('t', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)8)).addElement('x', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)0)).addElement('y', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)5)).addElement('z', StructureUtility.ofBlock((Block)GSBlocks.DysonSwarmBlocks, (int)2)).build();
        String[] possibleLore = new String[]{"Wait, this isn't an army of vacuum cleaners?", "Number 9? Not quite.", "Not the game.", "Basically solar panels.", "Invented by a free man."};
        LORE_TOOLTIP = possibleLore[XSTR.XSTR_INSTANCE.nextInt(possibleLore.length)];
    }
}

