/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.ceres.world.dungeon;

import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.world.dungeon.GSDungeonBoundingBox;
import galaxyspace.core.world.dungeon.GSDungeonRoom;
import galaxyspace.core.world.dungeon.GSMapGenDungeon;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomChestsCeres
extends GSDungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    private final ArrayList<ChunkCoordinates> chests = new ArrayList();

    public RoomChestsCeres(GSMapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(5) + 6;
            this.sizeY = rand.nextInt(2) + 7;
            this.sizeZ = rand.nextInt(5) + 6;
        }
    }

    @Override
    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        if (j == this.posY - 1 || i == this.posX + this.sizeX) {
                            this.placeBlock(chunk, meta, i, j, k, cx, cz, GSBlocks.CeresBlocks, 4);
                        }
                        if (j == this.posY + this.sizeY || i == this.posX - 1 || i == this.posX + this.sizeX || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                            this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        }
                        if (j != this.posY + this.sizeY && i != this.posX + this.sizeX + 1) continue;
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, GSBlocks.CeresBlocks, 5);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY + 1, hz, cx, cz, (Block)Blocks.field_150486_ae, 0)) {
            this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
            this.chests.add(new ChunkCoordinates(hx, this.posY + 1, hz));
            Block block = Blocks.field_150355_j;
            for (int o = -1; o < this.sizeY; ++o) {
                this.placeBlock(chunk, meta, hx + 1, this.posY + o, hz + 1, cx, cz, block, 0);
                this.placeBlock(chunk, meta, hx + 1, this.posY + o, hz - 1, cx, cz, block, 0);
                this.placeBlock(chunk, meta, hx - 1, this.posY + o, hz + 1, cx, cz, block, 0);
                this.placeBlock(chunk, meta, hx - 1, this.posY + o, hz - 1, cx, cz, block, 0);
            }
        }
    }

    @Override
    public GSDungeonBoundingBox getBoundingBox() {
        return new GSDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected GSDungeonRoom makeRoom(GSMapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomChestsCeres(dungeon, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        if (!this.chests.isEmpty()) {
            this.worldObj.func_147465_d(this.chests.get((int)0).field_71574_a, this.chests.get((int)0).field_71572_b, this.chests.get((int)0).field_71573_c, (Block)Blocks.field_150486_ae, 0, 2);
            TileEntityChest chest = (TileEntityChest)this.worldObj.func_147438_o(this.chests.get((int)0).field_71574_a, this.chests.get((int)0).field_71572_b, this.chests.get((int)0).field_71573_c);
            if (chest != null) {
                for (int i = 0; i < chest.func_70302_i_(); ++i) {
                    chest.func_70299_a(i, (ItemStack)null);
                }
                ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)chest, (int)info.getCount(rand));
            }
            this.chests.clear();
        }
    }
}

