/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.common.handlers.IProcess;
import com.brandon3055.brandonscore.common.handlers.ProcessHandler;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.ReactorSound;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import com.brandon3055.draconicevolution.common.blocks.multiblock.IReactorPart;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.tileentities.TileObjectSync;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.ReactorExplosion;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorStabilizer;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileReactorCore
extends TileObjectSync {
    public static final int MAXIMUM_PART_DISTANCE = 10;
    public ReactorState reactorState = ReactorState.OFFLINE;
    public float renderRotation = 0.0f;
    public float renderSpeed = 0.0f;
    public boolean isStructureValid = false;
    public float stabilizerRender = 0.0f;
    private boolean startupInitialized = false;
    public int tick = 0;
    public int reactorFuel = 0;
    public int convertedFuel = 0;
    public double conversionUnit = 0.0;
    public double reactionTemperature = 20.0;
    public double maxReactTemperature = 10000.0;
    public double fieldCharge = 0.0;
    public double maxFieldCharge = 0.0;
    public int energySaturation = 0;
    public int maxEnergySaturation = 0;
    @SideOnly(value=Side.CLIENT)
    private ReactorSound reactorSound;
    public List<MultiblockHelper.TileLocation> stabilizerLocations = new ArrayList<MultiblockHelper.TileLocation>();
    private boolean hasExploded = false;
    public double tempDrainFactor;
    public double generationRate;
    public int fieldDrain;
    public double fieldInputRate;
    public double fuelUseRate;
    private boolean isStructureValidCache = false;
    private boolean startupInitializedCache = false;
    private int reactorStateCache = -1;
    private int reactorFuelCache = -1;
    private int convertedFuelCache = -1;
    private int energySaturationCache = -1;
    private int maxEnergySaturationCache = -1;
    private double reactionTemperatureCache = -1.0;
    private double maxReactTemperatureCache = -1.0;
    private double fieldChargeCache = -1.0;
    private double maxFieldChargeCache = -1.0;

    public void func_145845_h() {
        ++this.tick;
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
            this.renderSpeed = (float)Math.min((this.reactionTemperature - 20.0) / 2000.0, 1.0);
            this.stabilizerRender = (float)Math.min(this.fieldCharge / (this.maxFieldCharge * 0.1), 1.0);
            this.renderRotation += this.renderSpeed;
            this.checkPlayerCollision();
            return;
        }
        switch (this.reactorState) {
            case OFFLINE: {
                this.offlineTick();
                break;
            }
            case STARTING: {
                this.startingTick();
                break;
            }
            case ONLINE: 
            case STOPPING: {
                this.runTick();
            }
        }
        this.detectAndSendChanges();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (this.reactorSound == null) {
            this.reactorSound = (ReactorSound)DraconicEvolution.proxy.playISound((ISound)new ReactorSound(this));
        }
    }

    private void checkPlayerCollision() {
        double coreRadiusWithMargin;
        EntityPlayer player = BrandonsCore.proxy.getClientPlayer();
        double distance = Utills.getDistanceAtoB((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
        if (distance < (coreRadiusWithMargin = this.getCoreRadius() + 0.5)) {
            double distanceMod = 1.0 - distance / Math.max(0.1, coreRadiusWithMargin);
            double offsetX = player.field_70165_t - (double)this.field_145851_c + 0.5;
            double offsetY = player.field_70163_u - (double)this.field_145848_d + 0.5;
            double offsetZ = player.field_70161_v - (double)this.field_145849_e + 0.5;
            player.func_70024_g(offsetX * distanceMod, offsetY * distanceMod, offsetZ * distanceMod);
        }
    }

    private void offlineTick() {
        if (this.reactionTemperature > 20.0) {
            this.reactionTemperature -= 0.5;
        }
        this.fieldCharge = Math.max(0.0, this.fieldCharge - this.maxFieldCharge * 5.0E-4);
        this.energySaturation = (int)Math.max(0.0, (double)this.energySaturation - (double)this.maxEnergySaturation * 1.0E-6);
    }

    private void startingTick() {
        if (!this.startupInitialized) {
            int totalFuel = this.reactorFuel + this.convertedFuel;
            this.maxFieldCharge = (double)totalFuel * 96.45061728395062 * 100.0;
            this.maxEnergySaturation = (int)((double)totalFuel * 96.45061728395062 * 1000.0);
            this.energySaturation = Math.min(this.energySaturation, this.maxEnergySaturation);
            this.fieldCharge = Math.min(this.fieldCharge, this.maxFieldCharge);
            this.startupInitialized = true;
        }
    }

    private void runTick() {
        double saturation = (double)this.energySaturation / (double)this.maxEnergySaturation;
        double saturationI = (1.0 - saturation) * 99.0;
        double temp = this.reactionTemperature / this.maxReactTemperature * 50.0;
        double conversion = ((double)this.convertedFuel + this.conversionUnit) / ((double)(this.convertedFuel + this.reactorFuel) - this.conversionUnit) * 1.3 - 0.3;
        double tempOffset = 444.7;
        double tempRiseExpo = Math.pow(saturationI, 3.0) / (100.0 - saturationI) + 444.7;
        double tempRiseResist = Math.pow(temp, 4.0) / (100.0 - temp);
        double riseAmount = (tempRiseExpo - tempRiseResist * (1.0 - conversion) + conversion * 1000.0) / 10000.0;
        if (this.reactorState == ReactorState.STOPPING) {
            if (this.reactionTemperature <= 2001.0) {
                this.reactorState = ReactorState.OFFLINE;
                this.startupInitialized = false;
                return;
            }
            this.reactionTemperature = (double)this.energySaturation >= (double)this.maxEnergySaturation * 0.99 && this.reactorFuel > 0 ? (this.reactionTemperature -= 1.0 - conversion) : (this.reactionTemperature += riseAmount * 10.0);
        } else {
            this.reactionTemperature += riseAmount * 10.0;
        }
        int baseMaxRFt = (int)((double)this.maxEnergySaturation / 1000.0 * ConfigHandler.reactorOutputMultiplier * 1.5);
        int maxRFt = (int)((double)baseMaxRFt * (1.0 + conversion * 2.0));
        this.generationRate = (1.0 - saturation) * (double)maxRFt;
        this.energySaturation = (int)((double)this.energySaturation + this.generationRate);
        this.tempDrainFactor = this.reactionTemperature > 8000.0 ? 1.0 + Math.pow(this.reactionTemperature - 8000.0, 2.0) * 2.5E-6 : (this.reactionTemperature > 2000.0 ? 1.0 : (this.reactionTemperature > 1000.0 ? (this.reactionTemperature - 1000.0) / 1000.0 : 0.0));
        this.fieldDrain = (int)Math.min(this.tempDrainFactor * (1.0 - saturation) * ((double)baseMaxRFt / 10.923556), 2.147483647E9);
        double fieldNegPercent = 1.0 - this.fieldCharge / this.maxFieldCharge;
        this.fieldInputRate = (double)this.fieldDrain / fieldNegPercent;
        this.fieldCharge -= (double)this.fieldDrain;
        this.fuelUseRate = this.tempDrainFactor * (1.0 - saturation) * (0.001 * ConfigHandler.reactorFuelUsageMultiplier);
        this.conversionUnit += this.fuelUseRate;
        if (this.conversionUnit >= 1.0 && this.reactorFuel > 0) {
            this.conversionUnit -= 1.0;
            --this.reactorFuel;
            ++this.convertedFuel;
        }
        if (this.fieldCharge <= 0.0 && !this.hasExploded) {
            this.hasExploded = true;
            this.goBoom();
        }
    }

    private void goBoom() {
        if (ConfigHandler.enableReactorBigBoom) {
            float power = 2.0f + (float)(this.convertedFuel + this.reactorFuel) / 10369.0f * 18.0f;
            ProcessHandler.addProcess((IProcess)new ReactorExplosion(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, power));
            this.sendObjectToClient((byte)2, 100, (int)(power * 10.0f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 512.0));
        } else {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 5.0f, true);
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private boolean isFacingToCore(int x, int y, int z, IReactorPart part) {
        ForgeDirection facing = part.getFacing();
        int offsetX = Integer.signum(this.field_145851_c - x);
        int offsetY = Integer.signum(this.field_145848_d - y);
        int offsetZ = Integer.signum(this.field_145849_e - z);
        return offsetX == facing.offsetX && offsetY == facing.offsetY && offsetZ == facing.offsetZ;
    }

    public void updateReactorParts(boolean shouldSetUp) {
        this.stabilizerLocations.clear();
        block0: for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            for (int distance = 1; distance <= 10; ++distance) {
                IReactorPart part;
                int targetX = this.field_145851_c + direction.offsetX * distance;
                int targetY = this.field_145848_d + direction.offsetY * distance;
                int targetZ = this.field_145849_e + direction.offsetZ * distance;
                TileEntity tile = this.field_145850_b.func_147438_o(targetX, targetY, targetZ);
                if (!(tile instanceof IReactorPart) || !this.isFacingToCore(targetX, targetY, targetZ, part = (IReactorPart)tile)) continue;
                if (shouldSetUp) {
                    part.setUp(new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                }
                if (!(tile instanceof TileReactorStabilizer)) continue block0;
                this.stabilizerLocations.add(new MultiblockHelper.TileLocation(targetX, targetY, targetZ));
                continue block0;
            }
        }
    }

    public void validateStructure() {
        double margin = 0.5;
        double coreRadiusSquared = Math.pow(this.getCoreRadius() + 0.5, 2.0);
        boolean updateRequired = false;
        int stabilizersCount = 0;
        Iterator<MultiblockHelper.TileLocation> iterator = this.stabilizerLocations.iterator();
        while (iterator.hasNext()) {
            TileEntity tile;
            MultiblockHelper.TileLocation location = iterator.next();
            if ((double)location.func_71569_e(this.field_145851_c, this.field_145848_d, this.field_145849_e) > coreRadiusSquared && (tile = location.getTileEntity(this.field_145850_b)) instanceof TileReactorStabilizer) {
                TileReactorStabilizer stabilizer = (TileReactorStabilizer)tile;
                if (stabilizer.masterLocation.isThisLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    ++stabilizersCount;
                    continue;
                }
            }
            iterator.remove();
            updateRequired = true;
        }
        boolean bl = this.isStructureValid = stabilizersCount == 4;
        if (this.isStructureValid) {
            if (this.reactorState == ReactorState.INVALID) {
                this.reactorState = ReactorState.OFFLINE;
            }
        } else {
            this.reactorState = ReactorState.INVALID;
            if (this.reactionTemperature >= 2000.0) {
                this.goBoom();
            }
        }
        if (updateRequired) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void onPlaced() {
        this.updateReactorParts(true);
        this.validateStructure();
    }

    public void onBroken() {
        block0: for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            for (int distance = 1; distance <= 10; ++distance) {
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX * distance, this.field_145848_d + direction.offsetY * distance, this.field_145849_e + direction.offsetZ * distance);
                if (!(tile instanceof IReactorPart)) continue;
                IReactorPart part = (IReactorPart)tile;
                if (!part.getMasterLocation().isThisLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e)) continue block0;
                part.shutDown();
                continue block0;
            }
        }
        if (this.reactionTemperature >= 2000.0) {
            this.goBoom();
        }
    }

    public boolean onStructureRightClicked(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)DraconicEvolution.instance, 14, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public int injectEnergy(int energyToInject) {
        int energyInjected = 0;
        if (this.reactorState == ReactorState.STARTING) {
            if (!this.startupInitialized) {
                return 0;
            }
            if (this.fieldCharge < this.maxFieldCharge / 2.0) {
                energyInjected = Math.min(energyToInject, (int)(this.maxFieldCharge / 2.0) - (int)this.fieldCharge + 1);
                this.fieldCharge += (double)energyInjected;
                if (this.fieldCharge > this.maxFieldCharge / 2.0) {
                    this.fieldCharge = this.maxFieldCharge / 2.0;
                }
            } else if (this.energySaturation < this.maxEnergySaturation / 2) {
                energyInjected = Math.min(energyToInject, this.maxEnergySaturation / 2 - this.energySaturation);
                this.energySaturation += energyInjected;
            } else if (this.reactionTemperature < 2000.0) {
                energyInjected = energyToInject;
                this.reactionTemperature += (double)energyInjected / (1000.0 + (double)(this.reactorFuel * 10));
                if (this.reactionTemperature > 2000.0) {
                    this.reactionTemperature = 2000.0;
                }
            }
        } else if (this.reactorState == ReactorState.ONLINE || this.reactorState == ReactorState.STOPPING) {
            energyInjected = energyToInject;
            this.fieldCharge += (double)energyInjected * (1.0 - this.fieldCharge / this.maxFieldCharge);
            this.fieldCharge = Math.min(this.fieldCharge, this.maxFieldCharge);
        }
        return energyInjected;
    }

    public boolean canStart() {
        return this.isStructureValid && this.reactionTemperature >= 2000.0 && this.fieldCharge >= this.maxFieldCharge / 2.0 && this.energySaturation >= this.maxEnergySaturation / 2 && (double)(this.convertedFuel + this.reactorFuel) + this.conversionUnit >= 144.0;
    }

    public boolean canCharge() {
        return this.isStructureValid && this.reactorState != ReactorState.ONLINE && (double)(this.convertedFuel + this.reactorFuel) + this.conversionUnit >= 144.0;
    }

    public boolean canStop() {
        return this.isStructureValid && this.reactorState != ReactorState.OFFLINE;
    }

    public void processButtonPress(int button) {
        if (button == 0 && this.canCharge()) {
            this.reactorState = ReactorState.STARTING;
        } else if (button == 1 && this.canStart()) {
            this.reactorState = ReactorState.ONLINE;
        } else if (button == 2 && this.canStop()) {
            this.reactorState = ReactorState.STOPPING;
        }
    }

    public double getCoreRadius() {
        double volume = (double)(this.reactorFuel + this.convertedFuel) / 1296.0;
        return Math.cbrt((volume *= 1.0 + this.reactionTemperature / this.maxReactTemperature * 10.0) / 4.1887902047863905);
    }

    public double getCoreDiameter() {
        return this.getCoreRadius() * 2.0;
    }

    private void detectAndSendChanges() {
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0);
        if (this.reactionTemperatureCache != this.reactionTemperature) {
            this.reactionTemperatureCache = (Double)this.sendObjectToClient((byte)5, 8, this.reactionTemperature, targetPoint);
        }
        if (this.tick % 10 != 0) {
            return;
        }
        if (this.isStructureValidCache != this.isStructureValid) {
            this.isStructureValidCache = (Boolean)this.sendObjectToClient((byte)6, 0, this.isStructureValid, targetPoint);
        }
        if (this.startupInitializedCache != this.startupInitialized) {
            this.startupInitializedCache = (Boolean)this.sendObjectToClient((byte)6, 2, this.startupInitialized, targetPoint);
        }
        if (this.reactorStateCache != this.reactorState.ordinal()) {
            this.reactorStateCache = (Integer)this.sendObjectToClient((byte)2, 3, this.reactorState.ordinal(), targetPoint);
        }
        if (this.reactorFuelCache != this.reactorFuel) {
            this.reactorFuelCache = (Integer)this.sendObjectToClient((byte)2, 4, this.reactorFuel, targetPoint);
        }
        if (this.convertedFuelCache != this.convertedFuel) {
            this.convertedFuelCache = (Integer)this.sendObjectToClient((byte)2, 5, this.convertedFuel, targetPoint);
        }
        if (this.energySaturationCache != this.energySaturation) {
            this.energySaturationCache = (Integer)this.sendObjectToClient((byte)2, 6, this.energySaturation, targetPoint);
        }
        if (this.maxEnergySaturationCache != this.maxEnergySaturation) {
            this.maxEnergySaturationCache = (Integer)this.sendObjectToClient((byte)2, 7, this.maxEnergySaturation, targetPoint);
        }
        if (this.maxReactTemperatureCache != this.maxReactTemperature) {
            this.maxReactTemperatureCache = (Double)this.sendObjectToClient((byte)5, 9, this.maxReactTemperature, targetPoint);
        }
        if (this.fieldChargeCache != this.fieldCharge) {
            this.fieldChargeCache = (Double)this.sendObjectToClient((byte)5, 10, this.fieldCharge, targetPoint);
        }
        if (this.maxFieldChargeCache != this.maxFieldCharge) {
            this.maxFieldChargeCache = (Double)this.sendObjectToClient((byte)5, 11, this.maxFieldCharge, targetPoint);
        }
    }

    public int getComparatorOutput(IReactorPart.ComparatorMode comparatorMode) {
        int n;
        switch (comparatorMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TEMPERATURE: {
                n = this.toRedstoneStrength(this.reactionTemperature, this.maxReactTemperature, comparatorMode);
                break;
            }
            case TEMPERATURE_INVERTED: {
                n = 15 - this.toRedstoneStrength(this.reactionTemperature, this.maxReactTemperature, comparatorMode);
                break;
            }
            case FIELD_CHARGE: {
                n = this.toRedstoneStrength(this.fieldCharge, this.maxFieldCharge, comparatorMode);
                break;
            }
            case FIELD_CHARGE_INVERTED: {
                n = 15 - this.toRedstoneStrength(this.fieldCharge, this.maxFieldCharge, comparatorMode);
                break;
            }
            case ENERGY_SATURATION: {
                n = this.toRedstoneStrength(this.energySaturation, this.maxEnergySaturation, comparatorMode);
                break;
            }
            case ENERGY_SATURATION_INVERTED: {
                n = 15 - this.toRedstoneStrength(this.energySaturation, this.maxEnergySaturation, comparatorMode);
                break;
            }
            case CONVERTED_FUEL: {
                n = this.toRedstoneStrength((double)this.convertedFuel + this.conversionUnit, (double)this.reactorFuel - this.conversionUnit, comparatorMode);
                break;
            }
            case CONVERTED_FUEL_INVERTED: {
                n = 15 - this.toRedstoneStrength((double)this.convertedFuel + this.conversionUnit, (double)this.reactorFuel - this.conversionUnit, comparatorMode);
            }
        }
        return n;
    }

    private int toRedstoneStrength(double value, double maxValue, IReactorPart.ComparatorMode comparatorMode) {
        if (maxValue == 0.0) {
            return 0;
        }
        double proportion = value / maxValue;
        int redstoneStrength = (int)(proportion * 15.0);
        switch (comparatorMode) {
            case FIELD_CHARGE: 
            case FIELD_CHARGE_INVERTED: {
                if (!(proportion < 0.1)) break;
                redstoneStrength = 0;
                break;
            }
            case CONVERTED_FUEL: 
            case CONVERTED_FUEL_INVERTED: {
                if (!(proportion > 0.9)) break;
                redstoneStrength = 15;
            }
        }
        return redstoneStrength;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveObjectFromServer(int index, Object object) {
        switch (index) {
            case 0: {
                this.isStructureValid = (Boolean)object;
                break;
            }
            case 2: {
                this.startupInitialized = (Boolean)object;
                break;
            }
            case 3: {
                this.reactorState = ReactorState.getState((Integer)object);
                break;
            }
            case 4: {
                this.reactorFuel = (Integer)object;
                break;
            }
            case 5: {
                this.convertedFuel = (Integer)object;
                break;
            }
            case 6: {
                this.energySaturation = (Integer)object;
                break;
            }
            case 7: {
                this.maxEnergySaturation = (Integer)object;
                break;
            }
            case 8: {
                this.reactionTemperature = (Double)object;
                break;
            }
            case 9: {
                this.maxReactTemperature = (Double)object;
                break;
            }
            case 10: {
                this.fieldCharge = (Double)object;
                break;
            }
            case 11: {
                this.maxFieldCharge = (Double)object;
                break;
            }
            case 100: {
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new Particles.ReactorExplosionParticle(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((Integer)object).intValue()));
            }
        }
        super.receiveObjectFromServer(index, object);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 40960.0;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList stabilizerList = new NBTTagList();
        for (MultiblockHelper.TileLocation offset : this.stabilizerLocations) {
            NBTTagCompound compound1 = new NBTTagCompound();
            offset.writeToNBT(compound1, "tag");
            stabilizerList.func_74742_a((NBTBase)compound1);
        }
        if (stabilizerList.func_74745_c() > 0) {
            compound.func_74782_a("Stabilizers", (NBTBase)stabilizerList);
        }
        compound.func_74774_a("State", (byte)this.reactorState.ordinal());
        compound.func_74757_a("isStructureValid", this.isStructureValid);
        compound.func_74757_a("startupInitialized", this.startupInitialized);
        compound.func_74768_a("energySaturation", this.energySaturation);
        compound.func_74768_a("maxEnergySaturation", this.maxEnergySaturation);
        compound.func_74768_a("reactorFuel", this.reactorFuel);
        compound.func_74768_a("convertedFuel", this.convertedFuel);
        compound.func_74780_a("reactionTemperature", this.reactionTemperature);
        compound.func_74780_a("maxReactTemperature", this.maxReactTemperature);
        compound.func_74780_a("fieldCharge", this.fieldCharge);
        compound.func_74780_a("maxFieldCharge", this.maxFieldCharge);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stabilizerLocations = new ArrayList<MultiblockHelper.TileLocation>();
        if (compound.func_74764_b("Stabilizers")) {
            NBTTagList stabilizerList = compound.func_150295_c("Stabilizers", 10);
            for (int i = 0; i < stabilizerList.func_74745_c(); ++i) {
                MultiblockHelper.TileLocation offset = new MultiblockHelper.TileLocation();
                offset.readFromNBT(stabilizerList.func_150305_b(i), "tag");
                this.stabilizerLocations.add(offset);
            }
        }
        this.reactorState = ReactorState.getState(compound.func_74771_c("State"));
        this.isStructureValid = compound.func_74767_n("isStructureValid");
        this.startupInitialized = compound.func_74767_n("startupInitialized");
        this.energySaturation = compound.func_74762_e("energySaturation");
        this.maxEnergySaturation = compound.func_74762_e("maxEnergySaturation");
        this.reactorFuel = compound.func_74762_e("reactorFuel");
        this.convertedFuel = compound.func_74762_e("convertedFuel");
        this.reactionTemperature = compound.func_74769_h("reactionTemperature");
        this.maxReactTemperature = compound.func_74769_h("maxReactTemperature");
        this.fieldCharge = compound.func_74769_h("fieldCharge");
        this.maxFieldCharge = compound.func_74769_h("maxFieldCharge");
    }

    public Object[] callMethod(String methodName, Object ... args) {
        if (args.length > 0) {
            throw new IllegalArgumentException("This method does not accept arguments");
        }
        if (methodName.equals("getReactorInfo")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("temperature", Utills.round((double)this.reactionTemperature, (double)100.0));
            map.put("fieldStrength", Utills.round((double)this.fieldCharge, (double)100.0));
            map.put("maxFieldStrength", Utills.round((double)this.maxFieldCharge, (double)100.0));
            map.put("energySaturation", this.energySaturation);
            map.put("maxEnergySaturation", this.maxEnergySaturation);
            map.put("fuelConversion", Utills.round((double)((double)this.convertedFuel + this.conversionUnit), (double)1000.0));
            map.put("maxFuelConversion", this.reactorFuel + this.convertedFuel);
            map.put("generationRate", (int)this.generationRate);
            map.put("fieldDrainRate", this.fieldDrain);
            map.put("fuelConversionRate", (int)Math.round(this.fuelUseRate * 1000000.0));
            if (this.reactorState == ReactorState.STARTING) {
                map.put("status", this.canStart() ? "charged" : "charging");
            } else {
                map.put("status", this.reactorState.name().toLowerCase());
            }
            return new Object[]{map};
        }
        if (methodName.equals("chargeReactor")) {
            if (this.canCharge()) {
                this.reactorState = ReactorState.STARTING;
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        if (methodName.equals("activateReactor")) {
            if (this.canStart()) {
                this.reactorState = ReactorState.ONLINE;
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        if (methodName.equals("stopReactor")) {
            if (this.canStop()) {
                this.reactorState = ReactorState.STOPPING;
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        return new Object[0];
    }

    public static enum ReactorState {
        OFFLINE,
        STARTING,
        ONLINE,
        STOPPING,
        INVALID;

        private static final ReactorState[] values;

        public static ReactorState getState(int ordinal) {
            return ordinal >= 0 && ordinal < values.length ? values[ordinal] : INVALID;
        }

        public String toLocalizedString(boolean canStart) {
            return StatCollector.func_74838_a((String)(this == STARTING && canStart ? "gui.de.status1_5.txt" : "gui.de.status" + this.ordinal() + ".txt"));
        }

        static {
            values = ReactorState.values();
        }
    }
}

