/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.client;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Arrays;
import java.util.List;
import li.cil.oc.api.event.RackMountableRenderEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import org.lwjgl.opengl.GL11;
import pl.asie.computronics.item.ItemOpenComputers;
import pl.asie.computronics.oc.driver.DriverBoardLight;

public class RackMountableRenderer {
    private final ResourceLocation boomBoardActive = new ResourceLocation("computronics", "textures/blocks/boom_board_on.png");
    private final ResourceLocation boomBoardTicking = new ResourceLocation("computronics", "textures/blocks/boom_board_ticking.png");
    private final ResourceLocation switchBoardActive = new ResourceLocation("computronics", "textures/blocks/switch_board_on.png");
    private IIcon boomBoard;
    private IIcon rackCapacitor;
    private IIcon switchBoard;
    private static final List<Integer> mountables = Arrays.asList(10, 11, 12, 13);

    @Optional.Method(modid="OpenComputers")
    private boolean isRackMountable(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemOpenComputers && mountables.contains(stack.func_77960_j());
    }

    @SubscribeEvent
    @Optional.Method(modid="OpenComputers")
    public void onRackMountableRender(RackMountableRenderEvent.TileEntity e) {
        ItemStack stack = e.rack.func_70301_a(e.mountable);
        if (!this.isRackMountable(stack)) {
            return;
        }
        switch (stack.func_77960_j()) {
            case 10: {
                if (e.data == null) {
                    return;
                }
                this.enableLight();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                DriverBoardLight.Mode mode = DriverBoardLight.Mode.fromIndex(e.data.func_74762_e("m"));
                if (mode == null) {
                    mode = DriverBoardLight.Mode.Default;
                }
                for (int index = 1; index <= mode.lightcount; ++index) {
                    int color;
                    if (!e.data.func_74767_n("r_" + index) || (color = e.data.func_74762_e("c_" + index)) < 0) continue;
                    GL11.glColor3ub((byte)((byte)((color &= 0xFFFFFF) >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
                    float u0 = mode.getU0(index);
                    float v0 = mode.getV0(index, e.v0, e.v1);
                    this.renderOverlay(mode.foreground, u0, mode.getU1(index, u0), v0, mode.getV1(index, v0, e.v1));
                }
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                this.disableLight();
                break;
            }
            case 11: {
                if (e.data == null) {
                    return;
                }
                this.enableLight();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                if (e.data.func_74767_n("r")) {
                    e.renderOverlay(this.boomBoardActive);
                }
                if (e.data.func_74767_n("t") && (e.rack.world().func_82737_E() + (long)e.rack.hashCode() + (long)(e.mountable * 10)) % 20L < 10L) {
                    e.renderOverlay(this.boomBoardTicking);
                }
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                this.disableLight();
                break;
            }
            case 13: {
                if (e.data == null) {
                    return;
                }
                this.enableLight();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                byte switchData = e.data.func_74771_c("s");
                for (int i = 0; i < 4; ++i) {
                    if ((switchData >> i & 1) != 1) continue;
                    float u0 = (float)(i * 4) / 16.0f;
                    float u1 = u0 + 0.25f;
                    e.renderOverlay(this.switchBoardActive, u0, u1);
                }
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                this.disableLight();
                break;
            }
        }
    }

    private void renderOverlay(ResourceLocation texture, float u0, float u1, float v0, float v1) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78374_a((double)u0, (double)v1, 0.0, (double)u0, (double)v1);
        t.func_78374_a((double)u1, (double)v1, 0.0, (double)u1, (double)v1);
        t.func_78374_a((double)u1, (double)v0, 0.0, (double)u1, (double)v0);
        t.func_78374_a((double)u0, (double)v0, 0.0, (double)u0, (double)v0);
        t.func_78381_a();
    }

    private void enableLight() {
        Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
        RenderHelper.func_74518_a();
    }

    private void disableLight() {
        Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
        RenderHelper.func_74519_b();
    }

    @SubscribeEvent
    @Optional.Method(modid="OpenComputers")
    public void onRackMountableRender(RackMountableRenderEvent.Block e) {
        ItemStack stack = e.rack.func_70301_a(e.mountable);
        if (!this.isRackMountable(stack)) {
            return;
        }
        switch (stack.func_77960_j()) {
            case 10: {
                if (e.data == null) {
                    return;
                }
                DriverBoardLight.Mode mode = DriverBoardLight.Mode.fromIndex(e.data.func_74762_e("m"));
                if (mode == null) {
                    mode = DriverBoardLight.Mode.Default;
                }
                e.setFrontTextureOverride(mode.background);
                break;
            }
            case 11: {
                e.setFrontTextureOverride(this.boomBoard);
                break;
            }
            case 12: {
                e.setFrontTextureOverride(this.rackCapacitor);
                break;
            }
            case 13: {
                e.setFrontTextureOverride(this.switchBoard);
            }
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="OpenComputers")
    public void textureHook(TextureStitchEvent.Pre e) {
        if (e.map.func_130086_a() == 0) {
            for (DriverBoardLight.Mode mode : DriverBoardLight.Mode.VALUES) {
                mode.registerIcons((IIconRegister)e.map);
            }
            this.boomBoard = e.map.func_94245_a("computronics:boom_board");
            this.rackCapacitor = e.map.func_94245_a("computronics:rack_capacitor");
            this.switchBoard = e.map.func_94245_a("computronics:switch_board");
        }
    }
}

