/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.buildcraft.statements.actions;

import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.integration.buildcraft.statements.actions.ActionComputer;
import pl.asie.computronics.integration.buildcraft.statements.actions.ActionLamp;
import pl.asie.computronics.integration.buildcraft.statements.actions.ActionTapeDrive;
import pl.asie.computronics.integration.buildcraft.statements.actions.IComputronicsAction;
import pl.asie.computronics.integration.buildcraft.statements.actions.IComputronicsParameterAction;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.util.StringUtil;

public enum Actions implements IActionExternal
{
    Computer_Start("computer_start", new ActionComputer.Start()),
    Computer_Stop("computer_stop", new ActionComputer.Stop()),
    TapeDrive_Start("tape_drive_start", new ActionTapeDrive(TapeDriveState.State.PLAYING)),
    TapeDrive_Stop("tape_drive_stop", new ActionTapeDrive(TapeDriveState.State.STOPPED)),
    TapeDrive_Rewind("tape_drive_rewind", new ActionTapeDrive(TapeDriveState.State.REWINDING)),
    TapeDrive_Forward("tape_drive_forward", new ActionTapeDrive(TapeDriveState.State.FORWARDING)),
    Lamp_SetColor("lamp_color_set", new ActionLamp.Set(), 3, 3),
    Lamp_ResetColor("lamp_color_reset", new ActionLamp.Reset());

    public static final Actions[] VALUES;
    private String tag;
    private IComputronicsAction action;
    private IIcon icon;
    private int minParams = 0;
    private int maxParams = 0;

    private Actions(String tag, IComputronicsAction action) {
        this.tag = tag;
        this.action = action;
    }

    private Actions(String tag, IComputronicsAction action, int minParams, int maxParams) {
        this(tag, action);
        this.minParams = minParams;
        this.maxParams = maxParams;
    }

    public static void initialize() {
        for (Actions action : VALUES) {
            StatementManager.registerStatement((IStatement)action);
        }
    }

    public void actionActivate(TileEntity tile, ForgeDirection side, IStatementContainer container, IStatementParameter[] parameters) {
        this.action.actionActivate(tile, side, container, parameters);
    }

    public String getUniqueTag() {
        return "computroncis:action." + this.tag;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("computronics:buildcraft/actions/action." + this.tag);
    }

    public int maxParameters() {
        return this.maxParams;
    }

    public int minParameters() {
        return this.minParams;
    }

    public IStatementParameter createParameter(int i) {
        if (this.action instanceof IComputronicsParameterAction) {
            return ((IComputronicsParameterAction)this.action).createParameter(i);
        }
        return null;
    }

    public String getDescription() {
        return StringUtil.localize("tooltip.computronics.gate.action." + this.tag);
    }

    public IStatement rotateLeft() {
        return this;
    }

    static {
        VALUES = Actions.values();
    }
}

