/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.appeng;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.WorldCoord;
import appeng.hooks.TickHandler;
import appeng.me.GridAccessException;
import appeng.me.cache.SpatialPylonCache;
import appeng.tile.spatial.TileSpatialIOPort;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.io.Serializable;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.integration.CCMultiPeripheral;
import pl.asie.computronics.integration.ManagedEnvironmentOCTile;
import pl.asie.computronics.integration.util.SpatialIOUtil;

public class DriverSpatialIOPort {
    private static Object[] trigger(TileSpatialIOPort tile) {
        ItemStack cell;
        if (Platform.isServer() && SpatialIOUtil.isSpatialCell(cell = tile.func_70301_a(0))) {
            TickHandler.INSTANCE.addCallable(null, (IWorldCallable)tile);
        }
        return new Object[0];
    }

    private static Object[] canTrigger(TileSpatialIOPort tile) {
        ItemStack cell = tile.func_70301_a(0);
        if (cell != null && SpatialIOUtil.isSpatialCell(cell) && tile.func_70301_a(1) == null) {
            try {
                double req;
                double pr;
                IGrid gi = tile.getProxy().getGrid();
                IEnergyGrid energy = tile.getProxy().getEnergy();
                SpatialPylonCache spc = (SpatialPylonCache)gi.getCache(ISpatialCache.class);
                if (spc.hasRegion() && spc.isValidRegion() && Math.abs((pr = energy.extractAEPower(req = (double)spc.requiredPower(), Actionable.SIMULATE, PowerMultiplier.CONFIG)) - req) < req * 0.001) {
                    return new Object[]{true};
                }
            }
            catch (GridAccessException e) {
                return new Object[]{false};
            }
        }
        return new Object[]{false, SpatialIOUtil.getCause(tile.func_70301_a(0), tile.func_70301_a(1), false)};
    }

    private static Object[] swapCell(TileSpatialIOPort tile) {
        ItemStack cell = tile.func_70301_a(1);
        if (cell != null && SpatialIOUtil.isSpatialCell(cell) && tile.func_70301_a(0) == null) {
            tile.func_70299_a(0, cell);
            tile.func_70299_a(1, null);
            return new Object[]{true};
        }
        return new Object[]{false, SpatialIOUtil.getCause(tile.func_70301_a(0), tile.func_70301_a(1), true)};
    }

    private static Object[] canSwapCell(TileSpatialIOPort tile) {
        ItemStack cell = tile.func_70301_a(1);
        if (cell != null && SpatialIOUtil.isSpatialCell(cell) && tile.func_70301_a(0) == null) {
            return new Object[]{true};
        }
        return new Object[]{false, SpatialIOUtil.getCause(tile.func_70301_a(0), tile.func_70301_a(1), true)};
    }

    private static Object[] getCellSize(TileSpatialIOPort tile) {
        WorldCoord size;
        ItemStack cell = tile.func_70301_a(0);
        ISpatialStorageCell sc = SpatialIOUtil.getSpatialCell(cell);
        if (sc != null && (size = sc.getStoredSize(cell)) != null) {
            return new Object[]{size.x, size.y, size.z};
        }
        return new Object[]{null, SpatialIOUtil.getCause(cell, null, false)};
    }

    private static Object[] getMaxCellSize(TileSpatialIOPort tile) {
        ItemStack cell = tile.func_70301_a(0);
        ISpatialStorageCell sc = SpatialIOUtil.getSpatialCell(cell);
        if (sc != null) {
            return new Object[]{sc.getMaxStoredDim(cell)};
        }
        return new Object[]{null, SpatialIOUtil.getCause(cell, null, false)};
    }

    private static Object[] getInformation(TileSpatialIOPort tile) {
        ItemStack cell = tile.func_70301_a(0);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        try {
            IGrid gi = tile.getProxy().getGrid();
            IEnergyGrid energy = tile.getProxy().getEnergy();
            SpatialPylonCache spc = (SpatialPylonCache)gi.getCache(ISpatialCache.class);
            if (spc.hasRegion() && spc.isValidRegion()) {
                double req = spc.requiredPower();
                double pr = energy.extractAEPower(req, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                map.put("requiredEnergy", Double.valueOf(req));
                map.put("availableEnergy", Double.valueOf(energy.getStoredPower()));
                map.put("maxEnergy", Double.valueOf(energy.getMaxStoredPower()));
                map.put("efficiency", Float.valueOf(spc.currentEfficiency() / 100.0f));
                map.put("canTrigger", Boolean.valueOf(SpatialIOUtil.isSpatialCell(cell) && tile.func_70301_a(1) == null && Math.abs(pr - req) < req * 0.001));
            } else {
                map.put("requiredEnergy", Double.valueOf(-1.0));
                map.put("availableEnergy", Double.valueOf(energy.getStoredPower()));
                map.put("maxEnergy", Double.valueOf(energy.getMaxStoredPower()));
                map.put("efficiency", Float.valueOf(-1.0f));
                map.put("canTrigger", Boolean.valueOf(false));
            }
        }
        catch (GridAccessException e) {
            map.put("requiredEnergy", Double.valueOf(-1.0));
            map.put("availableEnergy", Double.valueOf(-1.0));
            map.put("maxEnergy", Double.valueOf(-1.0));
            map.put("efficiency", Float.valueOf(-1.0f));
            map.put("canTrigger", Boolean.valueOf(false));
        }
        map.put("hasInputCell", Boolean.valueOf(SpatialIOUtil.isSpatialCell(cell)));
        return new Object[]{map.isEmpty() ? null : map};
    }

    public static class CCDriver
    extends CCMultiPeripheral<TileSpatialIOPort> {
        public CCDriver() {
        }

        public CCDriver(TileSpatialIOPort tile, World world, int x, int y, int z) {
            super(tile, "spatial_io", world, x, y, z);
        }

        @Override
        public IMultiPeripheral getPeripheral(World world, int x, int y, int z, int side) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te instanceof TileSpatialIOPort) {
                return new CCDriver((TileSpatialIOPort)te, world, x, y, z);
            }
            return null;
        }

        public String[] getMethodNames() {
            return new String[]{"trigger", "canTrigger", "swapCell", "canSwapCell", "getCellSize", "getMaxCellSize", "getInformation"};
        }

        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            switch (method) {
                case 0: {
                    return DriverSpatialIOPort.trigger((TileSpatialIOPort)this.tile);
                }
                case 1: {
                    return DriverSpatialIOPort.canTrigger((TileSpatialIOPort)this.tile);
                }
                case 2: {
                    return DriverSpatialIOPort.swapCell((TileSpatialIOPort)this.tile);
                }
                case 3: {
                    return DriverSpatialIOPort.canSwapCell((TileSpatialIOPort)this.tile);
                }
                case 4: {
                    return DriverSpatialIOPort.getCellSize((TileSpatialIOPort)this.tile);
                }
                case 5: {
                    return DriverSpatialIOPort.getMaxCellSize((TileSpatialIOPort)this.tile);
                }
                case 6: {
                    return DriverSpatialIOPort.getInformation((TileSpatialIOPort)this.tile);
                }
            }
            return new Object[0];
        }
    }

    public static class OCDriver
    extends DriverSidedTileEntity {
        public Class<?> getTileEntityClass() {
            return TileSpatialIOPort.class;
        }

        public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
            return new InternalManagedEnvironment((TileSpatialIOPort)world.func_147438_o(x, y, z));
        }

        public static class InternalManagedEnvironment
        extends ManagedEnvironmentOCTile<TileSpatialIOPort> {
            public InternalManagedEnvironment(TileSpatialIOPort tile) {
                super(tile, "spatial_io");
            }

            @Callback(doc="function(); Triggers the Spatial IO Port, same effect as applying a redstone signal")
            public Object[] trigger(Context c, Arguments a) {
                return DriverSpatialIOPort.trigger((TileSpatialIOPort)this.tile);
            }

            @Callback(doc="function():boolean; Checks whether the Spatial IO Port can be triggered")
            public Object[] canTrigger(Context c, Arguments a) {
                return DriverSpatialIOPort.canTrigger((TileSpatialIOPort)this.tile);
            }

            @Callback(doc="function():boolean; Puts the cell in the IO Port's output slot into its input slot if possible; returns true on success")
            public Object[] swapCell(Context c, Arguments a) {
                return DriverSpatialIOPort.swapCell((TileSpatialIOPort)this.tile);
            }

            @Callback(doc="function():boolean; Checks whether the cell in the IO Port's output slot can be moved into its input slot")
            public Object[] canSwapCell(Context c, Arguments a) {
                return DriverSpatialIOPort.canSwapCell((TileSpatialIOPort)this.tile);
            }

            @Callback(doc="function():number, number, number; Returns the size of the storage cell in the input slot (x, y and z size)")
            public Object[] getCellSize(Context c, Arguments a) {
                return DriverSpatialIOPort.getCellSize((TileSpatialIOPort)this.tile);
            }

            @Callback(doc="function():number; Returns the maximum dimensions of the storage cell in the input slot")
            public Object[] getMaxCellSize(Context c, Arguments a) {
                return DriverSpatialIOPort.getMaxCellSize((TileSpatialIOPort)this.tile);
            }

            @Callback(doc="function():table; Returns a table with further information about the Spatial IO Port")
            public Object[] getInformation(Context c, Arguments a) {
                return DriverSpatialIOPort.getInformation((TileSpatialIOPort)this.tile);
            }
        }
    }
}

