/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.ISerializable;
import buildcraft.api.core.Position;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeManager;
import buildcraft.api.transport.PipeWire;
import buildcraft.api.transport.pluggable.IFacadePluggable;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.DefaultProps;
import buildcraft.core.internal.IDropControlInventory;
import buildcraft.core.lib.ITileBufferHolder;
import buildcraft.core.lib.TileBuffer;
import buildcraft.core.lib.network.IGuiReturnHandler;
import buildcraft.core.lib.network.ISyncedTile;
import buildcraft.core.lib.network.PacketTileState;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.FacadePluggable;
import buildcraft.transport.Gate;
import buildcraft.transport.IPipeConnectionForced;
import buildcraft.transport.ISolidSideTile;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipePluggableState;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.GateFactory;
import buildcraft.transport.gates.GatePluggable;
import buildcraft.transport.pluggable.PlugPluggable;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.logging.log4j.Level;

public class TileGenericPipe
extends TileEntity
implements IFluidHandler,
IPipeTile,
ITileBufferHolder,
IEnergyHandler,
IDropControlInventory,
ISyncedTile,
ISolidSideTile,
IGuiReturnHandler,
IRedstoneEngineReceiver,
IDebuggable,
IPipeConnection {
    public boolean initialized = false;
    public final PipeRenderState renderState = this.createRenderState();
    public final PipePluggableState pluggableState = this.createPluggableState();
    public final CoreState coreState = new CoreState();
    public boolean[] pipeConnectionsBuffer = new boolean[6];
    public Pipe pipe;
    public int redstoneInput;
    public int[] redstoneInputSide = new int[ForgeDirection.VALID_DIRECTIONS.length];
    protected boolean deletePipe = false;
    protected boolean sendClientUpdate = false;
    protected boolean blockNeighborChange = false;
    protected int blockNeighborChangedSides = 0;
    protected boolean refreshRenderState = false;
    protected boolean pipeBound = false;
    protected boolean resyncGateExpansions = false;
    protected boolean attachPluggables = false;
    protected SideProperties sideProperties = new SideProperties();
    private TileBuffer[] tileBuffer;
    private int glassColor = -1;

    protected PipeRenderState createRenderState() {
        return new PipeRenderState();
    }

    protected PipePluggableState createPluggableState() {
        return new PipePluggableState();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.glassColor >= 0) {
            nbt.func_74774_a("stainedColor", (byte)this.glassColor);
        }
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            nbt.func_74774_a(key, (byte)this.redstoneInputSide[i]);
        }
        if (this.pipe != null) {
            nbt.func_74768_a("pipeId", Item.func_150891_b((Item)this.pipe.item));
            this.pipe.writeToNBT(nbt);
        } else {
            nbt.func_74768_a("pipeId", this.coreState.pipeId);
        }
        this.sideProperties.writeToNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.glassColor = nbt.func_74764_b("stainedColor") ? (int)nbt.func_74771_c("stainedColor") : -1;
        this.redstoneInput = 0;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            if (nbt.func_74764_b(key)) {
                this.redstoneInputSide[i] = nbt.func_74771_c(key);
                if (this.redstoneInputSide[i] <= this.redstoneInput) continue;
                this.redstoneInput = this.redstoneInputSide[i];
                continue;
            }
            this.redstoneInputSide[i] = 0;
        }
        this.coreState.pipeId = nbt.func_74762_e("pipeId");
        this.pipe = BlockGenericPipe.createPipe(Item.func_150899_d((int)this.coreState.pipeId));
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.readFromNBT(nbt);
        } else {
            BCLog.logger.log(Level.WARN, "Pipe failed to load from NBT at {0},{1},{2}", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
            this.deletePipe = true;
        }
        this.sideProperties.readFromNBT(nbt);
        this.attachPluggables = true;
    }

    public void func_145843_s() {
        this.initialized = false;
        this.tileBuffer = null;
        if (this.pipe != null) {
            this.pipe.invalidate();
        }
        this.sideProperties.invalidate();
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.initialized = false;
        this.tileBuffer = null;
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.validate();
        }
        this.sideProperties.validate(this);
    }

    protected void notifyBlockChanged() {
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getBlock());
        this.scheduleRenderUpdate();
        this.sendUpdateToClient();
        if (this.pipe != null) {
            this.pipe.scheduleWireUpdate();
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.deletePipe) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.pipe == null) {
                return;
            }
            if (!this.initialized) {
                this.initialize(this.pipe);
            }
        }
        if (this.attachPluggables) {
            this.attachPluggables = false;
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                if (this.sideProperties.pluggables[i] == null) continue;
                this.pipe.eventBus.registerHandler(this.sideProperties.pluggables[i]);
                this.sideProperties.pluggables[i].onAttachedPipe(this, ForgeDirection.getOrientation((int)i));
            }
            this.notifyBlockChanged();
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return;
        }
        this.pipe.updateEntity();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            PipePluggable p = this.getPipePluggable(direction);
            if (p == null) continue;
            p.update(this, direction);
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.resyncGateExpansions) {
                this.syncGateExpansions();
            }
            return;
        }
        if (this.blockNeighborChange) {
            for (int i = 0; i < 6; ++i) {
                if ((this.blockNeighborChangedSides & 1 << i) == 0) continue;
                this.blockNeighborChangedSides ^= 1 << i;
                this.computeConnection(ForgeDirection.getOrientation((int)i));
            }
            this.pipe.onNeighborBlockChange(0);
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
        }
        if (this.refreshRenderState) {
            this.refreshRenderState();
            this.refreshRenderState = false;
        }
        if (this.sendClientUpdate) {
            this.sendClientUpdate = false;
            if (this.field_145850_b instanceof WorldServer) {
                WorldServer world = (WorldServer)this.field_145850_b;
                buildcraft.core.lib.network.Packet updatePacket = this.getBCDescriptionPacket();
                for (Object o : world.field_73010_i) {
                    EntityPlayerMP player = (EntityPlayerMP)o;
                    if (!world.func_73040_p().func_72694_a(player, this.field_145851_c >> 4, this.field_145849_e >> 4)) continue;
                    BuildCraftCore.instance.sendToPlayer((EntityPlayer)player, updatePacket);
                }
            }
        }
    }

    public void initializeFromItemMetadata(int i) {
        if (i >= 1 && i <= 16) {
            this.setPipeColor(i - 1 & 0xF);
        } else {
            this.setPipeColor(-1);
        }
    }

    public int getItemMetadata() {
        return this.getPipeColor() >= 0 ? 1 + this.getPipeColor() : 0;
    }

    @Override
    public int getPipeColor() {
        return this.field_145850_b.field_72995_K ? (int)this.renderState.getGlassColor() : this.glassColor;
    }

    public boolean setPipeColor(int color) {
        if (!this.field_145850_b.field_72995_K && color >= -1 && color < 16 && this.glassColor != color) {
            this.glassColor = color;
            this.notifyBlockChanged();
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
            return true;
        }
        return false;
    }

    protected void refreshRenderState() {
        this.renderState.setGlassColor((byte)this.glassColor);
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            this.renderState.pipeConnectionMatrix.setConnected(o, this.pipeConnectionsBuffer[o.ordinal()]);
        }
        for (int i = 0; i < 7; ++i) {
            ForgeDirection o = ForgeDirection.getOrientation((int)i);
            this.renderState.textureMatrix.setIconIndex(o, this.pipe.getIconIndex(o));
        }
        block8: for (PipeWire color : PipeWire.values()) {
            this.renderState.wireMatrix.setWire(color, this.pipe.wireSet[color.ordinal()]);
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                this.renderState.wireMatrix.setWireConnected(color, direction, this.pipe.isWireConnectedTo(this.getTile(direction), color, direction));
            }
            boolean lit = this.pipe.wireSignalStrength[color.ordinal()] > 0;
            switch (color) {
                case RED: {
                    this.renderState.wireMatrix.setWireIndex(color, lit ? 1 : 0);
                    continue block8;
                }
                case BLUE: {
                    this.renderState.wireMatrix.setWireIndex(color, lit ? 3 : 2);
                    continue block8;
                }
                case GREEN: {
                    this.renderState.wireMatrix.setWireIndex(color, lit ? 5 : 4);
                    continue block8;
                }
                case YELLOW: {
                    this.renderState.wireMatrix.setWireIndex(color, lit ? 7 : 6);
                    continue block8;
                }
            }
        }
        this.pluggableState.setPluggables(this.sideProperties.pluggables);
        if (this.renderState.isDirty()) {
            this.renderState.clean();
        }
        this.sendUpdateToClient();
    }

    public void initialize(Pipe<?> pipe) {
        this.initialized = false;
        this.field_145854_h = this.func_145838_q();
        if (pipe == null) {
            BCLog.logger.log(Level.WARN, "Pipe failed to initialize at {0},{1},{2}, deleting", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        this.pipe = pipe;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.getTile(o);
            if (tile instanceof ITileBufferHolder) {
                ((ITileBufferHolder)tile).blockCreated(o, (Block)BuildCraftTransport.genericPipeBlock, this);
            }
            if (!(tile instanceof IPipeTile)) continue;
            ((IPipeTile)tile).scheduleNeighborChange();
        }
        this.bindPipe();
        this.computeConnections();
        this.scheduleNeighborChange();
        this.scheduleRenderUpdate();
        if (!pipe.isInitialized()) {
            pipe.initialize();
        }
        this.initialized = true;
    }

    private void bindPipe() {
        if (!this.pipeBound && this.pipe != null) {
            this.pipe.setTile(this);
            this.coreState.pipeId = Item.func_150891_b((Item)this.pipe.item);
            this.pipeBound = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void scheduleNeighborChange() {
        this.blockNeighborChange = true;
        this.blockNeighborChangedSides = 63;
    }

    public void scheduleNeighborChange(ForgeDirection direction) {
        this.blockNeighborChange = true;
        this.blockNeighborChangedSides |= direction == ForgeDirection.UNKNOWN ? 63 : 1 << direction.ordinal();
    }

    @Override
    public boolean canInjectItems(ForgeDirection from) {
        if (this.getPipeType() != IPipeTile.PipeType.ITEM) {
            return false;
        }
        return this.isPipeConnected(from);
    }

    @Override
    public int injectItem(ItemStack payload, boolean doAdd, ForgeDirection from, EnumColor color) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof PipeTransportItems && this.isPipeConnected(from) && this.pipe.inputOpen(from)) {
            if (doAdd) {
                Position itemPos = new Position((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, from.getOpposite());
                itemPos.moveBackwards(0.4);
                TravelingItem pipedItem = TravelingItem.make(itemPos.x, itemPos.y, itemPos.z, payload);
                if (pipedItem.isCorrupted()) {
                    return 0;
                }
                pipedItem.color = color;
                ((PipeTransportItems)this.pipe.transport).injectItem(pipedItem, itemPos.orientation);
            }
            return payload.field_77994_a;
        }
        return 0;
    }

    @Override
    public int injectItem(ItemStack payload, boolean doAdd, ForgeDirection from) {
        return this.injectItem(payload, doAdd, from, null);
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return ((PipeTransport)this.pipe.transport).getPipeType();
        }
        return null;
    }

    @Override
    public int x() {
        return this.field_145851_c;
    }

    @Override
    public int y() {
        return this.field_145848_d;
    }

    @Override
    public int z() {
        return this.field_145849_e;
    }

    public buildcraft.core.lib.network.Packet getBCDescriptionPacket() {
        this.bindPipe();
        this.updateCoreState();
        PacketTileState packet = new PacketTileState(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.pipe != null && this.pipe.transport != null) {
            ((PipeTransport)this.pipe.transport).sendDescriptionPacket();
        }
        packet.addStateForSerialization((byte)0, this.coreState);
        packet.addStateForSerialization((byte)1, this.renderState);
        packet.addStateForSerialization((byte)2, this.pluggableState);
        if (this.pipe instanceof ISerializable) {
            packet.addStateForSerialization((byte)3, (ISerializable)((Object)this.pipe));
        }
        return packet;
    }

    public Packet func_145844_m() {
        return Utils.toPacket(this.getBCDescriptionPacket(), 1);
    }

    public void sendUpdateToClient() {
        this.sendClientUpdate = true;
    }

    @Override
    public void blockRemoved(ForgeDirection from) {
    }

    public TileBuffer[] getTileCache() {
        if (this.tileBuffer == null && this.pipe != null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((PipeTransport)this.pipe.transport).delveIntoUnloadedChunks());
        }
        return this.tileBuffer;
    }

    @Override
    public void blockCreated(ForgeDirection from, Block block, TileEntity tile) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            cache[from.getOpposite().ordinal()].set(block, tile);
        }
    }

    @Override
    public Block getBlock(ForgeDirection to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getBlock();
        }
        return null;
    }

    @Override
    public TileEntity getTile(ForgeDirection to) {
        return this.getTile(to, false);
    }

    public TileEntity getTile(ForgeDirection to, boolean forceUpdate) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getTile(forceUpdate);
        }
        return null;
    }

    protected boolean canPipeConnect_internal(TileEntity with, ForgeDirection side) {
        IPipeConnection.ConnectOverride override;
        if (!(this.pipe instanceof IPipeConnectionForced && ((IPipeConnectionForced)((Object)this.pipe)).ignoreConnectionOverrides(side) || !(with instanceof IPipeConnection) || (override = ((IPipeConnection)with).overridePipeConnection(((PipeTransport)this.pipe.transport).getPipeType(), side.getOpposite())) == IPipeConnection.ConnectOverride.DEFAULT)) {
            return override == IPipeConnection.ConnectOverride.CONNECT;
        }
        if (with instanceof IPipeTile) {
            IPipeTile other = (IPipeTile)with;
            if (other.hasBlockingPluggable(side.getOpposite())) {
                return false;
            }
            if (other.getPipeColor() >= 0 && this.glassColor >= 0 && other.getPipeColor() != this.glassColor) {
                return false;
            }
            Pipe otherPipe = (Pipe)other.getPipe();
            if (!BlockGenericPipe.isValid(otherPipe)) {
                return false;
            }
            if (!otherPipe.canPipeConnect(this, side.getOpposite())) {
                return false;
            }
        }
        return this.pipe.canPipeConnect(with, side);
    }

    protected boolean canPipeConnect(TileEntity with, ForgeDirection side) {
        if (with == null) {
            return false;
        }
        if (this.hasBlockingPluggable(side)) {
            return false;
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return false;
        }
        return this.canPipeConnect_internal(with, side);
    }

    @Override
    public boolean hasBlockingPluggable(ForgeDirection side) {
        IPipe neighborPipe;
        PipePluggable pluggable = this.getPipePluggable(side);
        if (pluggable == null) {
            return false;
        }
        if (pluggable instanceof IPipeConnection && (neighborPipe = this.getNeighborPipe(side)) != null) {
            IPipeConnection.ConnectOverride override = ((IPipeConnection)((Object)pluggable)).overridePipeConnection(neighborPipe.getTile().getPipeType(), side);
            if (override == IPipeConnection.ConnectOverride.CONNECT) {
                return true;
            }
            if (override == IPipeConnection.ConnectOverride.DISCONNECT) {
                return false;
            }
        }
        return pluggable.isBlocking(this, side);
    }

    protected void computeConnections() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.computeConnection(side);
        }
    }

    protected void computeConnection(ForgeDirection side) {
        TileBuffer[] cache = this.getTileCache();
        if (cache == null) {
            return;
        }
        TileBuffer t = cache[side.ordinal()];
        if (t.exists() || !this.initialized) {
            t.refresh();
            this.pipeConnectionsBuffer[side.ordinal()] = this.canPipeConnect(t.getTile(), side);
        }
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        if (this.field_145850_b.field_72995_K) {
            return this.renderState.pipeConnectionMatrix.isConnected(with);
        }
        return this.pipeConnectionsBuffer[with.ordinal()];
    }

    @Override
    public boolean doDrop() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.doDrop();
        }
        return false;
    }

    public void onChunkUnload() {
        if (this.pipe != null) {
            this.pipe.onChunkUnload();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, resource, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    @Override
    public void scheduleRenderUpdate() {
        this.refreshRenderState = true;
    }

    public boolean hasFacade(ForgeDirection direction) {
        if (direction == null || direction == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.sideProperties.pluggables[direction.ordinal()] instanceof IFacadePluggable;
    }

    public boolean hasGate(ForgeDirection direction) {
        if (direction == null || direction == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.sideProperties.pluggables[direction.ordinal()] instanceof GatePluggable;
    }

    public boolean setPluggable(ForgeDirection direction, PipePluggable pluggable) {
        return this.setPluggable(direction, pluggable, null);
    }

    public boolean setPluggable(ForgeDirection direction, PipePluggable pluggable, EntityPlayer player) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return false;
        }
        if (direction == null || direction == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (this.sideProperties.pluggables[direction.ordinal()] != null) {
            this.sideProperties.dropItem(this, direction, player);
            this.pipe.eventBus.unregisterHandler(this.sideProperties.pluggables[direction.ordinal()]);
        }
        this.sideProperties.pluggables[direction.ordinal()] = pluggable;
        if (pluggable != null) {
            this.pipe.eventBus.registerHandler(pluggable);
            pluggable.onAttachedPipe(this, direction);
        }
        this.notifyBlockChanged();
        return true;
    }

    protected void updateCoreState() {
    }

    public boolean hasEnabledFacade(ForgeDirection direction) {
        return this.hasFacade(direction) && !((FacadePluggable)this.getPipePluggable(direction)).isTransparent();
    }

    public void setGate(Gate gate, int direction) {
        if (this.sideProperties.pluggables[direction] == null) {
            gate.setDirection(ForgeDirection.getOrientation((int)direction));
            this.pipe.gates[direction] = gate;
            this.sideProperties.pluggables[direction] = new GatePluggable(gate);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getPipeIcons() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getIconProvider();
    }

    @Override
    public ISerializable getStateInstance(byte stateId) {
        switch (stateId) {
            case 0: {
                return this.coreState;
            }
            case 1: {
                return this.renderState;
            }
            case 2: {
                return this.pluggableState;
            }
            case 3: {
                return (ISerializable)((Object)this.pipe);
            }
        }
        throw new RuntimeException("Unknown state requested: " + stateId + " this is a bug!");
    }

    @Override
    public void afterStateUpdated(byte stateId) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        switch (stateId) {
            case 0: {
                if (this.pipe != null) break;
                if (this.coreState.pipeId != 0) {
                    this.initialize(BlockGenericPipe.createPipe((Item)Item.field_150901_e.func_148754_a(this.coreState.pipeId)));
                }
                if (this.pipe == null) break;
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 1: {
                if (!this.renderState.needsRenderUpdate()) break;
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.renderState.clean();
                break;
            }
            case 2: {
                int i;
                PipePluggable[] newPluggables = this.pluggableState.getPluggables();
                for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                    PipePluggable old = this.sideProperties.pluggables[i];
                    PipePluggable newer = newPluggables[i];
                    if (old == null && newer == null) continue;
                    if (old != null && newer != null && old.getClass() == newer.getClass()) {
                        if (!newer.requiresRenderUpdate(old)) continue;
                        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        break;
                    }
                    this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    break;
                }
                this.sideProperties.pluggables = (PipePluggable[])newPluggables.clone();
                for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                    PipePluggable pluggable = this.getPipePluggable(ForgeDirection.getOrientation((int)i));
                    if (pluggable != null && pluggable instanceof GatePluggable) {
                        GatePluggable gatePluggable = (GatePluggable)pluggable;
                        Gate gate = this.pipe.gates[i];
                        if (gate != null && gate.logic == gatePluggable.getLogic() && gate.material == gatePluggable.getMaterial()) continue;
                        this.pipe.gates[i] = GateFactory.makeGate(this.pipe, gatePluggable.getMaterial(), gatePluggable.getLogic(), ForgeDirection.getOrientation((int)i));
                        continue;
                    }
                    this.pipe.gates[i] = null;
                }
                this.syncGateExpansions();
                break;
            }
        }
    }

    private void syncGateExpansions() {
        this.resyncGateExpansions = false;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            GatePluggable gatePluggable;
            Gate gate = this.pipe.gates[i];
            if (gate == null || (gatePluggable = (GatePluggable)this.sideProperties.pluggables[i]).getExpansions().length <= 0) continue;
            for (IGateExpansion expansion : gatePluggable.getExpansions()) {
                if (expansion != null) {
                    if (gate.expansions.containsKey((Object)expansion)) continue;
                    gate.addGateExpansion(expansion);
                    continue;
                }
                this.resyncGateExpansions = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return DefaultProps.PIPE_CONTENTS_RENDER_DIST * DefaultProps.PIPE_CONTENTS_RENDER_DIST;
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        if (this.hasPipePluggable(side) && this.getPipePluggable(side).isSolidOnSide(this, side)) {
            return true;
        }
        return BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof ISolidSideTile && ((ISolidSideTile)((Object)this.pipe)).isSolidOnSide(side);
    }

    @Override
    public PipePluggable getPipePluggable(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return this.sideProperties.pluggables[side.ordinal()];
    }

    @Override
    public boolean hasPipePluggable(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.sideProperties.pluggables[side.ordinal()] != null;
    }

    public Block getBlock() {
        return this.func_145838_q();
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public void writeGuiData(ByteBuf data) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.pipe)).writeGuiData(data);
        }
    }

    @Override
    public void readGuiData(ByteBuf data, EntityPlayer sender) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.pipe)).readGuiData(data, sender);
        }
    }

    private IEnergyHandler internalGetEnergyHandler(ForgeDirection side) {
        if (this.hasPipePluggable(side)) {
            PipePluggable pluggable = this.getPipePluggable(side);
            if (pluggable instanceof IEnergyHandler) {
                return (IEnergyHandler)pluggable;
            }
            if (pluggable.isBlocking(this, side)) {
                return null;
            }
        }
        if (this.pipe instanceof IEnergyHandler) {
            return (IEnergyHandler)this.pipe;
        }
        return null;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler != null) {
            return handler.canConnectEnergy(from);
        }
        return false;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler != null) {
            return handler.receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler != null) {
            return handler.extractEnergy(from, maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler != null) {
            return handler.getEnergyStored(from);
        }
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler != null) {
            return handler.getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public Block getNeighborBlock(ForgeDirection dir) {
        return this.getBlock(dir);
    }

    @Override
    public TileEntity getNeighborTile(ForgeDirection dir) {
        return this.getTile(dir);
    }

    @Override
    public IPipe getNeighborPipe(ForgeDirection dir) {
        TileEntity neighborTile = this.getTile(dir);
        if (neighborTile instanceof IPipeTile) {
            return ((IPipeTile)neighborTile).getPipe();
        }
        return null;
    }

    @Override
    public IPipe getPipe() {
        return this.pipe;
    }

    @Override
    public boolean canConnectRedstoneEngine(ForgeDirection side) {
        if (this.pipe instanceof IRedstoneEngineReceiver) {
            return ((IRedstoneEngineReceiver)((Object)this.pipe)).canConnectRedstoneEngine(side);
        }
        return this.getPipeType() != IPipeTile.PipeType.POWER && this.getPipeType() != IPipeTile.PipeType.STRUCTURE;
    }

    @Override
    public void getDebugInfo(List<String> info, ForgeDirection side, ItemStack debugger, EntityPlayer player) {
        if (this.pipe instanceof IDebuggable) {
            ((IDebuggable)((Object)this.pipe)).getDebugInfo(info, side, debugger, player);
        }
        if (this.pipe.transport instanceof IDebuggable) {
            ((IDebuggable)this.pipe.transport).getDebugInfo(info, side, debugger, player);
        }
        if (this.getPipePluggable(side) != null && this.getPipePluggable(side) instanceof IDebuggable) {
            ((IDebuggable)((Object)this.getPipePluggable(side))).getDebugInfo(info, side, debugger, player);
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.POWER && this.hasPipePluggable(with) && this.getPipePluggable(with) instanceof IEnergyHandler) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    public static class SideProperties {
        PipePluggable[] pluggables = new PipePluggable[ForgeDirection.VALID_DIRECTIONS.length];

        public void writeToNBT(NBTTagCompound nbt) {
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                PipePluggable pluggable = this.pluggables[i];
                String key = "pluggable[" + i + "]";
                if (pluggable == null) {
                    nbt.func_82580_o(key);
                    continue;
                }
                NBTTagCompound pluggableData = new NBTTagCompound();
                pluggableData.func_74778_a("pluggableName", PipeManager.getPluggableName(pluggable.getClass()));
                pluggable.writeToNBT(pluggableData);
                nbt.func_74782_a(key, (NBTBase)pluggableData);
            }
        }

        public void readFromNBT(NBTTagCompound nbt) {
            int i;
            for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                String key = "pluggable[" + i + "]";
                if (!nbt.func_74764_b(key)) continue;
                try {
                    NBTTagCompound pluggableData = nbt.func_74775_l(key);
                    Class<Object> pluggableClass = null;
                    if (pluggableData.func_74764_b("pluggableClass")) {
                        String c = pluggableData.func_74779_i("pluggableClass");
                        if ("buildcraft.transport.gates.ItemGate$GatePluggable".equals(c)) {
                            pluggableClass = GatePluggable.class;
                        } else if ("buildcraft.transport.ItemFacade$FacadePluggable".equals(c)) {
                            pluggableClass = FacadePluggable.class;
                        } else if ("buildcraft.transport.ItemPlug$PlugPluggable".equals(c)) {
                            pluggableClass = PlugPluggable.class;
                        } else if ("buildcraft.transport.gates.ItemRobotStation$RobotStationPluggable".equals(c) || "buildcraft.transport.ItemRobotStation$RobotStationPluggable".equals(c)) {
                            pluggableClass = PipeManager.getPluggableByName("robotStation");
                        }
                    } else {
                        pluggableClass = PipeManager.getPluggableByName(pluggableData.func_74779_i("pluggableName"));
                    }
                    if (pluggableClass == null) continue;
                    if (!PipePluggable.class.isAssignableFrom(pluggableClass)) {
                        BCLog.logger.warn("Wrong pluggable class: " + pluggableClass);
                        continue;
                    }
                    PipePluggable pluggable = (PipePluggable)pluggableClass.newInstance();
                    pluggable.readFromNBT(pluggableData);
                    this.pluggables[i] = pluggable;
                    continue;
                }
                catch (Exception e) {
                    BCLog.logger.warn("Failed to load side state");
                    e.printStackTrace();
                }
            }
            for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                PipePluggable pluggable = null;
                if (nbt.func_74764_b("facadeState[" + i + "]")) {
                    pluggable = new FacadePluggable(ItemFacade.FacadeState.readArray(nbt.func_150295_c("facadeState[" + i + "]", 10)));
                } else if (nbt.func_74764_b("facadeBlocks[" + i + "]")) {
                    Block block = (Block)Block.field_149771_c.func_148754_a(nbt.func_74762_e("facadeBlocks[" + i + "]"));
                    int blockId = nbt.func_74762_e("facadeBlocks[" + i + "]");
                    if (blockId != 0) {
                        int metadata = nbt.func_74762_e("facadeMeta[" + i + "]");
                        pluggable = new FacadePluggable(new ItemFacade.FacadeState[]{ItemFacade.FacadeState.create(block, metadata)});
                    }
                } else if (nbt.func_74764_b("facadeBlocksStr[" + i + "][0]")) {
                    ItemFacade.FacadeState mainState = ItemFacade.FacadeState.create((Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("facadeBlocksStr[" + i + "][0]")), nbt.func_74762_e("facadeMeta[" + i + "][0]"));
                    if (nbt.func_74764_b("facadeBlocksStr[" + i + "][1]")) {
                        ItemFacade.FacadeState phasedState = ItemFacade.FacadeState.create((Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("facadeBlocksStr[" + i + "][1]")), nbt.func_74762_e("facadeMeta[" + i + "][1]"), PipeWire.fromOrdinal(nbt.func_74762_e("facadeWires[" + i + "]")));
                        pluggable = new FacadePluggable(new ItemFacade.FacadeState[]{mainState, phasedState});
                    } else {
                        pluggable = new FacadePluggable(new ItemFacade.FacadeState[]{mainState});
                    }
                }
                if (nbt.func_74767_n("plug[" + i + "]")) {
                    pluggable = new PlugPluggable();
                }
                if (pluggable == null) continue;
                this.pluggables[i] = pluggable;
            }
        }

        public void rotateLeft() {
            PipePluggable[] newPluggables = new PipePluggable[ForgeDirection.VALID_DIRECTIONS.length];
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                newPluggables[dir.getRotation((ForgeDirection)ForgeDirection.UP).ordinal()] = this.pluggables[dir.ordinal()];
            }
            this.pluggables = newPluggables;
        }

        public boolean dropItem(TileGenericPipe pipe, ForgeDirection direction, EntityPlayer player) {
            boolean result = false;
            PipePluggable pluggable = this.pluggables[direction.ordinal()];
            if (pluggable != null) {
                ItemStack[] stacks;
                pluggable.onDetachedPipe(pipe, direction);
                if (!pipe.getWorld().field_72995_K && (stacks = pluggable.getDropItems(pipe)) != null) {
                    for (ItemStack stack : stacks) {
                        Utils.dropTryIntoPlayerInventory(pipe.field_145850_b, pipe.field_145851_c, pipe.field_145848_d, pipe.field_145849_e, stack, player);
                    }
                }
                result = true;
            }
            return result;
        }

        public void invalidate() {
            for (PipePluggable p : this.pluggables) {
                if (p == null) continue;
                p.invalidate();
            }
        }

        public void validate(TileGenericPipe pipe) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                PipePluggable p = this.pluggables[d.ordinal()];
                if (p == null) continue;
                p.validate(pipe, d);
            }
        }
    }

    public static class CoreState
    implements ISerializable {
        public int pipeId = -1;

        @Override
        public void writeData(ByteBuf data) {
            data.writeInt(this.pipeId);
        }

        @Override
        public void readData(ByteBuf data) {
            this.pipeId = data.readInt();
        }
    }
}

