/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.worldgen;

import binnie.extratrees.worldgen.WorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenRainbowGum
extends WorldGenTree {
    public WorldGenRainbowGum(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        float leafSpawn = this.height + 2;
        float bottom = this.randBetween(0.5f, 0.6f) * (float)this.height;
        float width = (float)this.height * this.randBetween(0.15f, 0.2f);
        if (width < 1.5f) {
            width = 1.5f;
        }
        float f = leafSpawn;
        leafSpawn = f - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
        float f2 = leafSpawn;
        leafSpawn = f2 - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
        while (leafSpawn > bottom) {
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width, 1, this.leaf, false);
            float f4 = leafSpawn;
            leafSpawn = f4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), width - 0.5f, 1, this.leaf, false);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(7, 3);
        this.girth = this.determineGirth(this.treeGen.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

