/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.inventory.AccessDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;

class SidedAccess {
    private Map<ForgeDirection, AccessDirection> accesses = new HashMap<ForgeDirection, AccessDirection>();
    private AccessDirection base = AccessDirection.Both;
    private boolean insertLocked;
    private boolean extractLocked;

    public AccessDirection getAccess(ForgeDirection side) {
        return this.accesses.getOrDefault(side, this.base);
    }

    public boolean canInsert(ForgeDirection side) {
        return this.getAccess(side).canInsert();
    }

    public boolean canExtract(ForgeDirection side) {
        return this.getAccess(side).canExtract();
    }

    public void forbidInsertChange() {
        this.insertLocked = true;
    }

    public void forbidExtractChange() {
        this.extractLocked = true;
    }

    public Collection<ForgeDirection> getInsertionSides() {
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.getAccess(dir).canInsert()) continue;
            dirs.add(dir);
        }
        return dirs;
    }

    public Collection<ForgeDirection> getExtractionSides() {
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.getAccess(dir).canExtract()) continue;
            dirs.add(dir);
        }
        return dirs;
    }

    public void setExtract(ForgeDirection side, boolean b) {
        if (this.getAccess(side).canExtract() != b) {
            this.accesses.put(side, this.getAccess(side).changeExtract(b));
        }
    }

    public void setInsert(boolean b) {
        if (this.base.canInsert() != b) {
            this.base = this.base.changeInsert(b);
        }
    }

    public void setExtract(boolean b) {
        if (this.base.canExtract() != b) {
            this.base = this.base.changeExtract(b);
        }
    }
}

