/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import java.util.Random;
import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.worldgen.NoiseGen;
import mods.railcraft.common.worldgen.WorldGenSmallDeposits;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class PoorOreGenerator {
    private final OreGenEvent.GenerateMinable.EventType eventType;
    private final WorldGenerator oreGen;
    private final double scale;
    private final double denseArea;
    private final double fringeArea;
    private final int yLevel;
    private final int yRange;
    private final int noiseSeed;
    private final Map<World, NoiseGen> noiseMap = new MapMaker().weakKeys().makeMap();

    public PoorOreGenerator(OreGenEvent.GenerateMinable.EventType eventType, EnumOre ore, int density, int yLevel, int yRange, int noiseSeed) {
        this(eventType, ore, 0.0025, 0.85, 0.65, density, yLevel, yRange, noiseSeed);
    }

    public PoorOreGenerator(OreGenEvent.GenerateMinable.EventType eventType, EnumOre ore, double scale, double denseArea, double fringeArea, int density, int yLevel, int yRange, int noiseSeed) {
        this.eventType = eventType;
        this.scale = scale;
        this.denseArea = denseArea;
        this.fringeArea = fringeArea;
        this.yLevel = yLevel;
        this.yRange = yRange;
        this.noiseSeed = noiseSeed;
        this.oreGen = density >= 4 ? new WorldGenMinable((Block)BlockOre.getBlock(), ore.ordinal(), density, Blocks.field_150348_b) : new WorldGenSmallDeposits(BlockOre.getBlock(), ore.ordinal(), density, Blocks.field_150348_b);
    }

    @SubscribeEvent
    public void generate(OreGenEvent.Post event) {
        World world = event.world;
        Random rand = event.rand;
        int worldX = event.worldX;
        int worldZ = event.worldZ;
        if (!TerrainGen.generateOre((World)world, (Random)rand, (WorldGenerator)this.oreGen, (int)worldX, (int)worldZ, (OreGenEvent.GenerateMinable.EventType)this.eventType)) {
            return;
        }
        NoiseGen noise = this.noiseMap.get(world);
        if (noise == null) {
            long seed = world.func_72905_C();
            seed += (long)world.field_73011_w.field_76574_g;
            noise = new NoiseGen.NoiseGenSimplex(new Random(seed += (long)this.noiseSeed), this.scale);
            this.noiseMap.put(world, noise);
        }
        if (this.canGen(world, rand, worldX, worldZ)) {
            for (int i = 0; i < 32; ++i) {
                int z;
                int x = worldX + rand.nextInt(16);
                double strength = noise.noise(x, z = worldZ + rand.nextInt(16));
                if (!(strength > this.denseArea) && (!(strength > this.fringeArea) || !((double)rand.nextFloat() > 0.7))) continue;
                int y = this.yLevel + Math.round((float)rand.nextGaussian() * (float)this.yRange);
                this.oreGen.func_76484_a(world, rand, x, y, z);
            }
        }
    }

    protected boolean canGen(World world, Random rand, int x, int z) {
        return true;
    }
}

