/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.core;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.BOPBiomeDecorator;
import biomesoplenty.api.biome.BiomeFeatures;
import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.api.content.BOPCItems;
import biomesoplenty.common.configuration.BOPConfigurationMisc;
import biomesoplenty.common.entities.projectiles.dispenser.DispenserBehaviourDart;
import biomesoplenty.common.entities.projectiles.dispenser.DispenserBehaviourMudball;
import biomesoplenty.common.world.features.WorldGenBOPDoubleFlora;
import biomesoplenty.common.world.features.WorldGenBOPFlora;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockDispenser;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ChestGenHooks;

public class BOPVanillaCompat {
    private static Random random = new Random();

    public static void init() {
        BOPVanillaCompat.registerDispenserBehaviours();
        BOPVanillaCompat.addDungeonLoot();
        BOPVanillaCompat.addBonemealFlowers();
    }

    private static void registerDispenserBehaviours() {
        BlockDispenser.field_149943_a.func_82595_a((Object)BOPCItems.mudball, (Object)new DispenserBehaviourMudball());
        BlockDispenser.field_149943_a.func_82595_a((Object)BOPCItems.dart, (Object)new DispenserBehaviourDart());
    }

    private static void addDungeonLoot() {
        ChestGenHooks desertTemple = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
        ChestGenHooks dungeon = ChestGenHooks.getInfo((String)"dungeonChest");
        ChestGenHooks jungleTemple = ChestGenHooks.getInfo((String)"pyramidJungleChest");
        ChestGenHooks mineshaft = ChestGenHooks.getInfo((String)"mineshaftCorridor");
        ChestGenHooks strongholdCorridor = ChestGenHooks.getInfo((String)"strongholdCorridor");
        ChestGenHooks strongholdCrossing = ChestGenHooks.getInfo((String)"strongholdCrossing");
        ChestGenHooks strongholdLibrary = ChestGenHooks.getInfo((String)"strongholdLibrary");
        ChestGenHooks village = ChestGenHooks.getInfo((String)"villageBlacksmith");
        ChestGenHooks bonusChest = ChestGenHooks.getInfo((String)"bonusChest");
        if (BOPConfigurationMisc.dungeonLoot) {
            mineshaft.addItem(new WeightedRandomChestContent(new ItemStack(BOPCItems.misc, 1, 1), 2, 8, 25));
            mineshaft.addItem(new WeightedRandomChestContent(new ItemStack(BOPCBlocks.plants, 1, 5), 4, 6, 15));
            strongholdCorridor.addItem(new WeightedRandomChestContent(new ItemStack(BOPCBlocks.flowers, 1, 3), 1, 4, 25));
            strongholdCorridor.addItem(new WeightedRandomChestContent(new ItemStack(BOPCBlocks.flowers, 1, 2), 1, 4, 25));
            strongholdCrossing.addItem(new WeightedRandomChestContent(new ItemStack(BOPCBlocks.flowers, 1, 3), 1, 4, 25));
            strongholdCrossing.addItem(new WeightedRandomChestContent(new ItemStack(BOPCBlocks.flowers, 1, 2), 1, 4, 25));
            village.addItem(new WeightedRandomChestContent(new ItemStack(BOPCBlocks.plants, 1, 5), 2, 6, 25));
            village.addItem(new WeightedRandomChestContent(new ItemStack(BOPCItems.misc, 1, 1), 2, 8, 25));
            village.addItem(new WeightedRandomChestContent(new ItemStack(BOPCItems.wadingBoots, 1, 0), 1, 1, 5));
            village.addItem(new WeightedRandomChestContent(new ItemStack(BOPCItems.flippers, 1, 0), 1, 1, 5));
            bonusChest.addItem(new WeightedRandomChestContent(new ItemStack(BOPCItems.wadingBoots, 1, 0), 1, 1, 5));
            bonusChest.addItem(new WeightedRandomChestContent(new ItemStack(BOPCItems.flippers, 1, 0), 1, 1, 5));
        }
    }

    private static void addBonemealFlowers() {
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || !(biome instanceof BOPBiome)) continue;
            BOPBiome bopBiome = (BOPBiome)biome;
            Object biomeFeatures = ((BOPBiomeDecorator)((Object)bopBiome.field_76760_I)).bopFeatures;
            if (((BiomeFeatures)biomeFeatures).weightedFlowerGen == null || ((BiomeFeatures)biomeFeatures).weightedFlowerGen.isEmpty()) continue;
            HashMap<WorldGenerator, Integer> flowerMap = ((BiomeFeatures)biomeFeatures).weightedFlowerGen;
            for (Map.Entry<WorldGenerator, Integer> entry : flowerMap.entrySet()) {
                if (!(entry.getKey() instanceof WorldGenBOPFlora) || entry.getKey() instanceof WorldGenBOPDoubleFlora) continue;
                WorldGenBOPFlora flowerGenerator = (WorldGenBOPFlora)entry.getKey();
                int weight = entry.getValue();
                biome.addFlower(flowerGenerator.flora, flowerGenerator.floraMeta, weight);
            }
        }
    }
}

