/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.ToolDictNames;
import gregtech.api.util.GT_ModHandler;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeGen_ShapedCrafting
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGen_ShapedCrafting(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        Logger.WARNING("Generating Shaped Crafting recipes for " + material.getLocalizedName());
        if (ItemUtils.checkForInvalidItems(material.getPlate(1)) && ItemUtils.checkForInvalidItems(material.getIngot(1)) && material.getPlate(1) != null && material.getIngot(1) != null) {
            GT_ModHandler.addCraftingRecipe((ItemStack)material.getPlate(1), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"h", "B", "I", Character.valueOf('I'), material.getIngot(1), Character.valueOf('B'), material.getIngot(1)});
        }
        if (ItemUtils.checkForInvalidItems(material.getPlate(1)) && ItemUtils.checkForInvalidItems(material.getIngot(1))) {
            GT_ModHandler.addShapelessCraftingRecipe((ItemStack)material.getPlate(1), (Object[])new Object[]{ToolDictNames.craftingToolForgeHammer, material.getIngot(1), material.getIngot(1)});
        }
        if (ItemUtils.checkForInvalidItems(material.getPlateDouble(1)) && ItemUtils.checkForInvalidItems(material.getPlate(1))) {
            GT_ModHandler.addCraftingRecipe((ItemStack)material.getPlateDouble(1), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"I", "B", "h", Character.valueOf('I'), material.getPlate(1), Character.valueOf('B'), material.getPlate(1)});
        }
        if (ItemUtils.checkForInvalidItems(material.getPlateDouble(1)) && ItemUtils.checkForInvalidItems(material.getPlate(1))) {
            GT_ModHandler.addShapelessCraftingRecipe((ItemStack)material.getPlateDouble(1), (Object[])new Object[]{ToolDictNames.craftingToolForgeHammer, material.getPlate(1), material.getPlate(1)});
        }
        if (!material.isRadioactive && ItemUtils.checkForInvalidItems(material.getRing(1)) && ItemUtils.checkForInvalidItems(material.getRod(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getRing(1), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"h ", "fR", Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("GT:NH Ring Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("GT:NH Ring Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && ItemUtils.checkForInvalidItems(material.getFrameBox(1)) && ItemUtils.checkForInvalidItems(material.getRod(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getFrameBox(2), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"RRR", "RwR", "RRR", Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("Framebox Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Framebox Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && ItemUtils.checkForInvalidItems(material.getBolt(1)) && ItemUtils.checkForInvalidItems(material.getRod(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getBolt(2), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"s ", " R", Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("Bolt Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Bolt Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && ItemUtils.checkForInvalidItems(material.getFoil(1)) && ItemUtils.checkForInvalidItems(material.getFineWire(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getFineWire(1), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"Fx", Character.valueOf('F'), material.getFoil(1)})) {
                Logger.WARNING("Fine Wire Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Fine Wire Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(material.getFoil(1)) && ItemUtils.checkForInvalidItems(material.getPlate(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getFoil(2), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"hP", Character.valueOf('P'), material.getPlate(1)})) {
                Logger.WARNING("Foil Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Foil Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(material.getRod(1)) && ItemUtils.checkForInvalidItems(material.getIngot(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getRod(1), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"f ", " I", Character.valueOf('I'), material.getIngot(1)})) {
                Logger.WARNING("Rod Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Rod Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(material.getRod(1)) && ItemUtils.checkForInvalidItems(material.getLongRod(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getRod(2), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"s", "L", Character.valueOf('L'), material.getLongRod(1)})) {
                Logger.WARNING("Rod Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Rod Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(material.getLongRod(1)) && ItemUtils.checkForInvalidItems(material.getRod(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getLongRod(1), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"RhR", Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("Long Rod Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Long Rod Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && ItemUtils.checkForInvalidItems(material.getRotor(1)) && ItemUtils.checkForInvalidItems(material.getRing(1)) && !material.isRadioactive && ItemUtils.checkForInvalidItems(material.getPlate(1)) && ItemUtils.checkForInvalidItems(material.getScrew(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getRotor(1), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PhP", "SRf", "PdP", Character.valueOf('P'), material.getPlate(1), Character.valueOf('S'), material.getScrew(1), Character.valueOf('R'), material.getRing(1)})) {
                Logger.WARNING("Rotor Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Rotor Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && ItemUtils.checkForInvalidItems(material.getGear(1)) && ItemUtils.checkForInvalidItems(material.getPlate(1)) && ItemUtils.checkForInvalidItems(material.getRod(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getGear(1), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"RPR", "PwP", "RPR", Character.valueOf('P'), material.getPlate(1), Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("Gear Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Gear Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && ItemUtils.checkForInvalidItems(material.getScrew(1)) && ItemUtils.checkForInvalidItems(material.getBolt(1))) {
            if (GT_ModHandler.addCraftingRecipe((ItemStack)material.getScrew(1), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"fB", "B ", Character.valueOf('B'), material.getBolt(1)})) {
                Logger.WARNING("Screw Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Screw Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

