/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.reflect.FieldUtils;

public class RecipeGen_Recycling
implements Runnable {
    public static AutoMap<Runnable> mQueuedRecyclingGenerators = new AutoMap();
    final Material toGenerate;
    public static Map<String, ItemStack> mNameMap;

    public static void executeGenerators() {
        if (mQueuedRecyclingGenerators.size() > 0) {
            for (Runnable R : mQueuedRecyclingGenerators.values()) {
                R.run();
            }
        }
    }

    public RecipeGen_Recycling(Material M) {
        this.toGenerate = M;
        if (mNameMap == null) {
            mNameMap = this.getNameMap();
        }
        mQueuedRecyclingGenerators.put(this);
    }

    @Override
    public void run() {
        if (mNameMap != null) {
            RecipeGen_Recycling.generateRecipes(this.toGenerate);
        }
    }

    public static void generateRecipes(Material material) {
        Pair[] temp;
        if (material != null) {
            Logger.WARNING("Generating Recycling recipes for " + material.getLocalizedName());
        }
        OrePrefixes[] mValidPrefixesAsString = new OrePrefixes[]{OrePrefixes.ingot, OrePrefixes.ingotHot, OrePrefixes.nugget, OrePrefixes.plate, OrePrefixes.plateDense, OrePrefixes.plateDouble, OrePrefixes.plateTriple, OrePrefixes.plateQuadruple, OrePrefixes.plateQuintuple, OrePrefixes.stick, OrePrefixes.stickLong, OrePrefixes.bolt, OrePrefixes.screw, OrePrefixes.ring, OrePrefixes.rotor, OrePrefixes.gearGt, OrePrefixes.gearGtSmall, OrePrefixes.gear, OrePrefixes.block, OrePrefixes.cableGt01, OrePrefixes.cableGt02, OrePrefixes.cableGt04, OrePrefixes.cableGt08, OrePrefixes.cableGt12, OrePrefixes.wireFine, OrePrefixes.wireGt01, OrePrefixes.wireGt02, OrePrefixes.wireGt04, OrePrefixes.wireGt08, OrePrefixes.wireGt12, OrePrefixes.wireGt16, OrePrefixes.foil, OrePrefixes.frameGt, OrePrefixes.pipeHuge, OrePrefixes.pipeLarge, OrePrefixes.pipeMedium, OrePrefixes.pipeSmall, OrePrefixes.pipeTiny};
        int mSlotIndex = 0;
        Pair[] mValidPairs = new Pair[mValidPrefixesAsString.length];
        for (int r = 0; r < mValidPairs.length; ++r) {
            temp = RecipeGen_Recycling.getItemStackOfAmountFromOreDictNoBroken(mValidPrefixesAsString[r].name() + Utils.sanitizeString(material.getLocalizedName()), 1);
            if (temp == null) continue;
            mValidPairs[mSlotIndex++] = new Pair<OrePrefixes, ItemStack>(mValidPrefixesAsString[r], temp.func_77946_l());
        }
        if (mValidPairs.length > 0) {
            int validCounter = 0;
            temp = mValidPairs;
            for (ItemStack itemStack : mValidPairs) {
                if (itemStack == null) continue;
                Logger.WARNING("Valid: " + ((ItemStack)itemStack.getValue()).func_82833_r());
                ++validCounter;
            }
            Pair[] temp3 = new Pair[validCounter];
            boolean bl = false;
            for (ItemStack itemStack : mValidPairs) {
                if (itemStack == null) continue;
                temp3[++var7_12] = itemStack;
            }
            if (temp3.length > 0) {
                mValidPairs = (Pair[])temp3.clone();
            }
        }
        if (mValidPrefixesAsString.length >= 1) {
            for (ItemStack itemStack : mValidPairs) {
                try {
                    if (material == null || itemStack == null || material.getState() != MaterialState.SOLID && material.getState() != MaterialState.LIQUID || itemStack.getKey() == OrePrefixes.ingotHot) continue;
                    ItemStack tempStack = (ItemStack)itemStack.getValue();
                    ItemStack itemStack2 = RecipeGen_Recycling.getDust(material, (OrePrefixes)itemStack.getKey());
                    Pair<OrePrefixes, ItemStack> mData = RecipeGen_Recycling.getDustData(material, (OrePrefixes)itemStack.getKey());
                    int n = (int)GT_Utility.translateMaterialToFluidAmount((long)((OrePrefixes)itemStack.getKey()).mMaterialAmount, (boolean)true);
                    if (ItemUtils.checkForInvalidItems(tempStack)) {
                        if (itemStack2 != null && GT_ModHandler.addPulverisationRecipe((ItemStack)tempStack, (ItemStack)itemStack2)) {
                            Logger.WARNING("Recycle Recipe: " + material.getLocalizedName() + " - Success - Recycle " + tempStack.func_82833_r() + " and obtain " + itemStack2.func_82833_r());
                        } else {
                            Logger.WARNING("Recycle Recipe: " + material.getLocalizedName() + " - Failed");
                            if (itemStack2 == null) {
                                Logger.WARNING("Invalid Dust output.");
                            }
                        }
                    }
                    if (ItemUtils.checkForInvalidItems(tempStack)) {
                        // empty if block
                    }
                    if (!ItemUtils.checkForInvalidItems(tempStack)) continue;
                    int aFluidAmount = (int)(144L * ((OrePrefixes)itemStack.getKey()).mMaterialAmount / (3628800L * (long)tempStack.field_77994_a));
                    int aDuration = (int)Math.max(1L, 24L * ((OrePrefixes)itemStack.getKey()).mMaterialAmount / 3628800L);
                    boolean aGenFluidExtraction = CORE.RA.addFluidExtractionRecipe(tempStack, material.getFluidStack(aFluidAmount), aDuration, material.vVoltageMultiplier);
                    if (aGenFluidExtraction) {
                        Logger.WARNING("Fluid Recycle Recipe: " + material.getLocalizedName() + " - Success - Recycle " + tempStack.func_82833_r() + " and obtain " + aFluidAmount + "mb of " + material.getFluidStack(1).getLocalizedName() + ". Time: " + aDuration + ", Voltage: " + material.vVoltageMultiplier);
                        continue;
                    }
                    Logger.WARNING("Fluid Recycle Recipe: " + material.getLocalizedName() + " - Failed");
                    if (itemStack2 != null) continue;
                    Logger.WARNING("Invalid Dust output.");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static Pair<OrePrefixes, ItemStack> getDustData(Material aMaterial, OrePrefixes aPrefix) {
        return RecipeGen_Recycling.getDustData(aMaterial, aPrefix.mMaterialAmount);
    }

    public static Pair<OrePrefixes, ItemStack> getDustData(Material aMaterial, long aMaterialAmount) {
        ItemStack mDust = null;
        OrePrefixes mPrefix = null;
        if (aMaterial == null || aMaterialAmount <= 0L) {
            return null;
        }
        if (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 58060800L) {
            mDust = RecipeGen_Recycling.get(OrePrefixes.dust, aMaterial, aMaterialAmount / 3628800L);
            mPrefix = OrePrefixes.dust;
        }
        if (mDust == null && (aMaterialAmount * 4L % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            mDust = RecipeGen_Recycling.get(OrePrefixes.dustSmall, aMaterial, aMaterialAmount * 4L / 3628800L);
            mPrefix = OrePrefixes.dustSmall;
        }
        if (mDust == null && aMaterialAmount * 9L >= 3628800L) {
            mDust = RecipeGen_Recycling.get(OrePrefixes.dustTiny, aMaterial, aMaterialAmount * 9L / 3628800L);
            mPrefix = OrePrefixes.dustTiny;
        }
        if (mPrefix != null && mDust != null) {
            Logger.WARNING("Built valid dust pair.");
            return new Pair<OrePrefixes, ItemStack>(mPrefix, mDust);
        }
        Logger.WARNING("mPrefix: " + (mPrefix != null));
        Logger.WARNING("mDust: " + (mDust != null));
        Logger.WARNING("Failed to build valid dust pair.");
        return null;
    }

    public static ItemStack getDust(Material aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : RecipeGen_Recycling.getDust(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getDust(Material aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = null;
        if (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 58060800L) {
            Logger.WARNING("Trying to get a Dust");
            rStack = RecipeGen_Recycling.get(OrePrefixes.dust, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null && (aMaterialAmount * 4L % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            Logger.WARNING("Trying to get a Small Dust");
            rStack = RecipeGen_Recycling.get(OrePrefixes.dustSmall, aMaterial, aMaterialAmount * 4L / 3628800L);
        }
        if (rStack == null && aMaterialAmount * 9L >= 3628800L) {
            Logger.WARNING("Trying to get a Tiny Dust");
            rStack = RecipeGen_Recycling.get(OrePrefixes.dustTiny, aMaterial, aMaterialAmount * 9L / 3628800L);
        }
        return rStack;
    }

    public static ItemStack get(Object aName, long aAmount) {
        return RecipeGen_Recycling.get(aName, null, aAmount, true, true);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount) {
        return RecipeGen_Recycling.get(aName, aReplacement, aAmount, true, true);
    }

    public static ItemStack get(OrePrefixes aPrefix, Material aMaterial, long aAmount) {
        return RecipeGen_Recycling.get(aPrefix, aMaterial, null, aAmount);
    }

    public static ItemStack get(OrePrefixes aPrefix, Material aMaterial, ItemStack aReplacement, long aAmount) {
        return RecipeGen_Recycling.get(aPrefix.name() + Utils.sanitizeString(aMaterial.getLocalizedName()), aReplacement, aAmount, false, true);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount, boolean aMentionPossibleTypos, boolean aNoInvalidAmounts) {
        if (aNoInvalidAmounts && aAmount < 1L) {
            Logger.WARNING("Returning Null. Method: " + ReflectionUtils.getMethodName(0));
            Logger.WARNING("Called from method: " + ReflectionUtils.getMethodName(1));
            Logger.WARNING("Called from method: " + ReflectionUtils.getMethodName(2));
            Logger.WARNING("Called from method: " + ReflectionUtils.getMethodName(3));
            Logger.WARNING("Called from method: " + ReflectionUtils.getMethodName(4));
            return null;
        }
        if (!mNameMap.containsKey(aName.toString()) && aMentionPossibleTypos) {
            Logger.WARNING("Unknown Key for Unification, Typo? " + aName);
        }
        return GT_Utility.copyAmount((long)aAmount, (Object[])new Object[]{mNameMap.get(aName.toString()), RecipeGen_Recycling.getFirstOre(aName, aAmount), aReplacement});
    }

    public static ItemStack getFirstOre(Object aName, long aAmount) {
        if (GT_Utility.isStringInvalid((Object)aName)) {
            Logger.WARNING("Returning Null. Method: " + ReflectionUtils.getMethodName(0));
            Logger.WARNING("Called from method: " + ReflectionUtils.getMethodName(1));
            Logger.WARNING("Called from method: " + ReflectionUtils.getMethodName(2));
            Logger.WARNING("Called from method: " + ReflectionUtils.getMethodName(3));
            Logger.WARNING("Called from method: " + ReflectionUtils.getMethodName(4));
            return null;
        }
        ItemStack tStack = mNameMap.get(aName.toString());
        if (GT_Utility.isStackValid((Object)tStack)) {
            Logger.WARNING("Found valid stack.");
            return GT_Utility.copyAmount((long)aAmount, (Object[])new Object[]{tStack});
        }
        return GT_Utility.copyAmount((long)aAmount, (Object[])RecipeGen_Recycling.getOres(aName).toArray());
    }

    public static ArrayList<ItemStack> getOres(Object aOreName) {
        String aName = aOreName == null ? "" : aOreName.toString();
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStringValid((Object)aName)) {
            Logger.WARNING("Making a list of all OreDict entries for " + aOreName + ".");
            if (rList.addAll(OreDictionary.getOres((String)aName))) {
                Logger.WARNING("Added " + rList.size() + " elements to list.");
            } else {
                Logger.WARNING("Failed to Add Collection from oreDictionary, forcing an entry.");
                rList.add(ItemUtils.getItemStackOfAmountFromOreDict((String)aOreName, 1));
            }
        }
        return rList;
    }

    public Map<String, ItemStack> getNameMap() {
        try {
            Map tempMap = (Map)FieldUtils.readStaticField(GT_OreDictUnificator.class, (String)"sName2StackMap", (boolean)true);
            if (tempMap != null) {
                Logger.WARNING("Found 'sName2StackMap' in GT_OreDictUnificator.class.");
                return tempMap;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        Logger.WARNING("Invalid map stored in GT_OreDictUnificator.class, unable to find sName2StackMap field.");
        return null;
    }

    public static ItemStack getItemStackOfAmountFromOreDictNoBroken(String oredictName, int amount) {
        try {
            String MaterialName;
            Materials m;
            oredictName = oredictName.contains("-") || oredictName.contains("_") ? Utils.sanitizeString(oredictName, new char[]{'-', '_'}) : Utils.sanitizeString(oredictName);
            ItemStack returnValue = null;
            if (oredictName.toLowerCase().contains("dust") && (m = Materials.get((String)(MaterialName = oredictName.toLowerCase().replace("dust", "")))) != null && m != Materials._NULL && ItemUtils.checkForInvalidItems(returnValue = ItemUtils.getGregtechDust(m, amount))) {
                return returnValue;
            }
            if (returnValue == null && ItemUtils.checkForInvalidItems(returnValue = RecipeGen_Recycling.getItemStackOfAmountFromOreDict(oredictName, amount))) {
                return returnValue.func_77946_l();
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static ItemStack getItemStackOfAmountFromOreDict(String oredictName, int amount) {
        String mTemp = oredictName;
        if (oredictName.toLowerCase().contains("ingotclay")) {
            return ItemUtils.getSimpleStack(Items.field_151119_aD, amount);
        }
        ArrayList oreDictList = OreDictionary.getOres((String)mTemp);
        if (!oreDictList.isEmpty()) {
            ItemStack returnValue = ((ItemStack)oreDictList.get(0)).func_77946_l();
            returnValue.field_77994_a = amount;
            return returnValue;
        }
        return null;
    }
}

