/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.recipe.GT_RecipeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGen_MultisUsingFluidInsteadOfCells {
    private static ItemStack mEmptyCell;
    private static final AutoMap<ItemStack> mItemsToIgnore;
    private static boolean mInit;

    private static void init() {
        if (!mInit) {
            mInit = true;
            mItemsToIgnore.add(ItemUtils.simpleMetaStack(CI.emptyCells(1).func_77973_b(), 8, 1));
        }
    }

    private static boolean doesItemMatchIgnoringStackSize(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() == b.func_77973_b()) {
            return a.func_77960_j() == b.func_77960_j();
        }
        return false;
    }

    private static boolean isEmptyCell(ItemStack aCell) {
        if (aCell == null) {
            return false;
        }
        if (mEmptyCell == null) {
            mEmptyCell = CI.emptyCells(1);
        }
        if (mEmptyCell != null) {
            ItemStack aTempStack = mEmptyCell.func_77946_l();
            aTempStack.field_77994_a = aCell.field_77994_a;
            return GT_Utility.areStacksEqual((ItemStack)aTempStack, (ItemStack)aCell);
        }
        return false;
    }

    private static synchronized FluidStack getFluidFromItemStack(ItemStack ingot) {
        if (ingot == null) {
            return null;
        }
        return GT_Utility.getFluidForFilledItem((ItemStack)ingot, (boolean)true);
    }

    public static synchronized int generateRecipesNotUsingCells(GT_Recipe.GT_Recipe_Map aInputs, GT_Recipe.GT_Recipe_Map aOutputs) {
        RecipeGen_MultisUsingFluidInsteadOfCells.init();
        int aRecipesHandled = 0;
        int aInvalidRecipesToConvert = 0;
        int aOriginalCount = aInputs.mRecipeList.size();
        ArrayList<GT_Recipe> deDuplicationInputArray = new ArrayList<GT_Recipe>();
        block0: for (GT_Recipe x : aInputs.mRecipeList) {
            if (x != null) {
                int i;
                FluidStack aFoundFluid;
                ItemStack[] aInputItems = (ItemStack[])x.mInputs.clone();
                ItemStack[] aOutputItems = (ItemStack[])x.mOutputs.clone();
                FluidStack[] aInputFluids = (FluidStack[])x.mFluidInputs.clone();
                FluidStack[] aOutputFluids = (FluidStack[])x.mFluidOutputs.clone();
                AutoMap<ItemStack> aInputItemsMap = new AutoMap<ItemStack>();
                AutoMap<ItemStack> aOutputItemsMap = new AutoMap<ItemStack>();
                AutoMap<FluidStack> aInputFluidsMap = new AutoMap<FluidStack>();
                AutoMap<FluidStack> aOutputFluidsMap = new AutoMap<FluidStack>();
                for (ItemStack aInputStack : aInputItems) {
                    aFoundFluid = RecipeGen_MultisUsingFluidInsteadOfCells.getFluidFromItemStack(aInputStack);
                    if (aFoundFluid == null) {
                        for (ItemStack aBadStack : mItemsToIgnore) {
                            if (!RecipeGen_MultisUsingFluidInsteadOfCells.doesItemMatchIgnoringStackSize(aInputStack, aBadStack)) continue;
                            continue block0;
                        }
                        if (RecipeGen_MultisUsingFluidInsteadOfCells.isEmptyCell(aInputStack)) continue;
                        aInputItemsMap.add(aInputStack);
                        continue;
                    }
                    aFoundFluid.amount *= aInputStack.field_77994_a;
                    aInputFluidsMap.add(aFoundFluid);
                }
                for (ItemStack aOutputStack : aOutputItems) {
                    aFoundFluid = RecipeGen_MultisUsingFluidInsteadOfCells.getFluidFromItemStack(aOutputStack);
                    if (aFoundFluid == null) {
                        for (ItemStack aBadStack : mItemsToIgnore) {
                            if (!RecipeGen_MultisUsingFluidInsteadOfCells.doesItemMatchIgnoringStackSize(aOutputStack, aBadStack)) continue;
                            continue block0;
                        }
                        if (RecipeGen_MultisUsingFluidInsteadOfCells.isEmptyCell(aOutputStack)) continue;
                        aOutputItemsMap.add(aOutputStack);
                        continue;
                    }
                    aFoundFluid.amount *= aOutputStack.field_77994_a;
                    aOutputFluidsMap.add(aFoundFluid);
                }
                aInputFluidsMap.addAll((Collection<FluidStack>)Arrays.asList(aInputFluids));
                aOutputFluidsMap.addAll((Collection<FluidStack>)Arrays.asList(aOutputFluids));
                ItemStack[] aNewItemInputs = new ItemStack[aInputItemsMap.size()];
                ItemStack[] aNewItemOutputs = new ItemStack[aOutputItemsMap.size()];
                FluidStack[] aNewFluidInputs = new FluidStack[aInputFluidsMap.size()];
                FluidStack[] aNewFluidOutputs = new FluidStack[aOutputFluidsMap.size()];
                for (i = 0; i < aInputItemsMap.size(); ++i) {
                    aNewItemInputs[i] = (ItemStack)aInputItemsMap.get(i);
                }
                for (i = 0; i < aOutputItemsMap.size(); ++i) {
                    aNewItemOutputs[i] = (ItemStack)aOutputItemsMap.get(i);
                }
                for (i = 0; i < aInputFluidsMap.size(); ++i) {
                    aNewFluidInputs[i] = (FluidStack)aInputFluidsMap.get(i);
                }
                for (i = 0; i < aOutputFluidsMap.size(); ++i) {
                    aNewFluidOutputs[i] = (FluidStack)aOutputFluidsMap.get(i);
                }
                if (!ItemUtils.checkForInvalidItems(aNewItemInputs, aNewItemOutputs)) {
                    ++aInvalidRecipesToConvert;
                    continue;
                }
                GTPP_Recipe aNewRecipe = new GTPP_Recipe(false, aNewItemInputs, aNewItemOutputs, x.mSpecialItems, x.mChances, aNewFluidInputs, aNewFluidOutputs, x.mDuration, x.mEUt, x.mSpecialValue);
                aNewRecipe.owners = new ArrayList(x.owners);
                deDuplicationInputArray.add(aNewRecipe);
                ++aRecipesHandled;
                continue;
            }
            ++aInvalidRecipesToConvert;
        }
        List<GT_Recipe> deDuplicationOutputArray = GT_RecipeUtils.removeDuplicates(deDuplicationInputArray, aOutputs.mNEIName);
        for (GT_Recipe recipe : deDuplicationOutputArray) {
            aOutputs.add(recipe);
        }
        Logger.INFO("Generated Recipes for " + aOutputs.mNEIName);
        Logger.INFO("Original Map contains " + aOriginalCount + " recipes.");
        Logger.INFO("Output Map contains " + aRecipesHandled + " recipes.");
        Logger.INFO("There were " + aInvalidRecipesToConvert + " invalid recipes.");
        return aRecipesHandled;
    }

    static {
        mItemsToIgnore = new AutoMap();
        mInit = false;
    }
}

