/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.advanced;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_Adv_DistillationTower
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_Adv_DistillationTower>
implements ISurvivalConstructable {
    private Mode mMode = Mode.DistillationTower;
    private boolean mUpgraded = false;
    protected static final String STRUCTURE_PIECE_BASE = "base";
    protected static final String STRUCTURE_PIECE_LAYER = "layer";
    protected static final String STRUCTURE_PIECE_LAYER_HINT = "layerHint";
    protected static final String STRUCTURE_PIECE_TOP_HINT = "topHint";
    protected final List<List<GT_MetaTileEntity_Hatch_Output>> mOutputHatchesByLayer = new ArrayList<List<GT_MetaTileEntity_Hatch_Output>>();
    protected int mHeight;
    protected int mCasing;
    protected boolean mTopLayerFound;
    private static IStructureDefinition<GregtechMetaTileEntity_Adv_DistillationTower> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_Adv_DistillationTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_Adv_DistillationTower(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_Adv_DistillationTower(this.mName);
    }

    public IStructureDefinition<GregtechMetaTileEntity_Adv_DistillationTower> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            IHatchElement layeredOutputHatch = GT_HatchElement.OutputHatch.withCount(GregtechMetaTileEntity_Adv_DistillationTower::getCurrentLayerOutputHatchCount).withAdder(GregtechMetaTileEntity_Adv_DistillationTower::addLayerOutputHatch);
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_BASE, StructureUtility.transpose((String[][])new String[][]{{"b~b", "bbb", "bbb"}})).addShape(STRUCTURE_PIECE_LAYER, StructureUtility.transpose((String[][])new String[][]{{"lll", "lcl", "lll"}})).addShape(STRUCTURE_PIECE_LAYER_HINT, StructureUtility.transpose((String[][])new String[][]{{"lll", "l-l", "lll"}})).addShape(STRUCTURE_PIECE_TOP_HINT, StructureUtility.transpose((String[][])new String[][]{{"ttt", "ttt", "ttt"}})).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_Adv_DistillationTower.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch, GT_HatchElement.InputBus, GT_HatchElement.Maintenance}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP}).casingIndex(this.getCasingTextureId()).dot(1).build(), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)})).addElement('l', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_Adv_DistillationTower.class).atLeast(new IHatchElement[]{layeredOutputHatch, GT_HatchElement.Energy, GT_HatchElement.Maintenance}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}).casingIndex(this.getCasingTextureId()).dot(2).build(), GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addMufflerToMachineList, (int)this.getCasingTextureId(), (int)3), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(GregtechMetaTileEntity_Adv_DistillationTower::onTopLayerFound, (IStructureElement)GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addMufflerToMachineList, (int)this.getCasingTextureId(), (int)3)), StructureUtility.onElementPass(GregtechMetaTileEntity_Adv_DistillationTower::onTopLayerFound, (IStructureElement)GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addOutputToMachineList, (int)this.getCasingTextureId(), (int)3)), StructureUtility.onElementPass(GregtechMetaTileEntity_Adv_DistillationTower::onTopLayerFound, (IStructureElement)GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addMaintenanceToMachineList, (int)this.getCasingTextureId(), (int)3)), StructureUtility.onElementPass(GregtechMetaTileEntity_Adv_DistillationTower::onTopLayerFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)), StructureUtility.isAir()})).addElement('t', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_Adv_DistillationTower.class).atLeast(new IHatchElement[]{layeredOutputHatch, GT_HatchElement.Muffler}).disallowOnly(new ForgeDirection[]{ForgeDirection.DOWN}).casingIndex(this.getCasingTextureId()).dot(2).buildAndChain(GregTech_API.sBlockCasings4, 1)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    protected int getCurrentLayerOutputHatchCount() {
        return this.mOutputHatchesByLayer.size() < this.mHeight || this.mHeight <= 0 ? 0 : this.mOutputHatchesByLayer.get(this.mHeight - 1).size();
    }

    protected boolean addLayerOutputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null || aTileEntity.isDead() || !(aTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_Output)) {
            return false;
        }
        while (this.mOutputHatchesByLayer.size() < this.mHeight) {
            this.mOutputHatchesByLayer.add(new ArrayList());
        }
        GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aTileEntity.getMetaTileEntity();
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mOutputHatchesByLayer.get(this.mHeight - 1).add(tHatch) && this.mOutputHatches.add(tHatch);
    }

    protected void onTopLayerFound() {
        this.mTopLayerFound = true;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Advanced Distillation Tower").addInfo("Use 85% less energy in distillery mode").addInfo("250%/100% faster in DT/distillery mode").addInfo("Right click the controller with screwdriver to change mode.").addInfo("Max parallel dictated by tower tier and mode").addInfo("DTower Mode: T1=4, T2=12").addInfo("Distilery Mode: Tower Tier * (4*InputTier)").addInfo("Distilery Mode require a full height tower").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().addCasingInfoMin("Clean Stainless Steel Machine Casing", 7, false).addInputBus("Bottom Casing", new int[]{1}).addOutputBus("Bottom Casing", new int[]{1}).addInputHatch("Bottom Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addOutputHatch("One per layer except bottom", new int[]{2}).addMufflerHatch("Top Casing", new int[]{3}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 1, 0, 0);
        int tTotalHeight = Math.min(12, stackSize.field_77994_a + 2);
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, hintsOnly, 1, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, hintsOnly, 1, tTotalHeight - 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        this.mHeight = 0;
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 1, 0, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int tTotalHeight = Math.min(12, stackSize.field_77994_a + 2);
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.mHeight = i;
            built = this.survivialBuildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, 1, i, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        this.mHeight = tTotalHeight - 1;
        return this.survivialBuildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, 1, tTotalHeight - 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        boolean check;
        this.mOutputHatchesByLayer.forEach(List::clear);
        this.mHeight = 1;
        this.mTopLayerFound = false;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 1, 0, 0)) {
            return false;
        }
        while (this.mHeight < 12) {
            if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 1, this.mHeight, 0)) {
                return false;
            }
            if (this.mOutputHatchesByLayer.size() < this.mHeight || this.mOutputHatchesByLayer.get(this.mHeight - 1).isEmpty()) {
                return false;
            }
            if (this.mTopLayerFound || !this.mMufflerHatches.isEmpty()) break;
            ++this.mHeight;
        }
        boolean bl = check = this.mTopLayerFound && this.mHeight >= 2 && this.checkHatch();
        if (check && this.mHeight < 11) {
            this.mMode = Mode.DistillationTower;
            this.mLastRecipe = null;
        }
        return check;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return this.mMode.getRecipeMap();
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        if (this.mMode == Mode.Distillery) {
            return CORE.ConfigSwitches.pollutionPerSecondMultiAdvDistillationTower_ModeDistillery;
        }
        return CORE.ConfigSwitches.pollutionPerSecondMultiAdvDistillationTower_ModeDT;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mMode", (byte)this.mMode.ordinal());
        aNBT.func_74757_a("mUpgraded", this.mUpgraded);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mMode = Mode.values()[aNBT.func_74771_c("mMode")];
        this.mUpgraded = aNBT.func_74767_n("mUpgraded");
        super.loadNBTData(aNBT);
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mHeight < 11) {
            PlayerUtils.messagePlayer(aPlayer, "Cannot switch mode if not in full height.");
            return;
        }
        this.mMode = this.mMode.next();
        PlayerUtils.messagePlayer(aPlayer, "Now running in " + (Object)((Object)this.mMode) + " Mode.");
        this.mLastRecipe = null;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack copiedFluidStack = aLiquid.copy();
        for (List<GT_MetaTileEntity_Hatch_Output> hatches : this.mOutputHatchesByLayer) {
            if (!GregtechMetaTileEntity_Adv_DistillationTower.dumpFluid(hatches, (FluidStack)copiedFluidStack, (boolean)true)) continue;
            return true;
        }
        for (List<GT_MetaTileEntity_Hatch_Output> hatches : this.mOutputHatchesByLayer) {
            if (!GregtechMetaTileEntity_Adv_DistillationTower.dumpFluid(hatches, (FluidStack)copiedFluidStack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected void addFluidOutputs(FluidStack[] mOutputFluids2) {
        if (this.mMode == Mode.DistillationTower) {
            for (int i = 0; i < mOutputFluids2.length && i < this.mOutputHatchesByLayer.size(); ++i) {
                FluidStack tStack = mOutputFluids2[i].copy();
                if (GregtechMetaTileEntity_Adv_DistillationTower.dumpFluid(this.mOutputHatchesByLayer.get(i), (FluidStack)tStack, (boolean)true)) continue;
                GregtechMetaTileEntity_Adv_DistillationTower.dumpFluid(this.mOutputHatchesByLayer.get(i), (FluidStack)tStack, (boolean)false);
            }
        } else {
            for (FluidStack outputFluidStack : mOutputFluids2) {
                this.addOutput(outputFluidStack);
            }
        }
    }

    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        return this.getFluidOutputSlotsByLayer(toOutput, this.mOutputHatchesByLayer);
    }

    @Override
    public String getMachineType() {
        return "Distillery, Distillation Tower";
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setEuModifier(this.mMode == Mode.Distillery ? 0.15f : 1.0f);
        logic.setSpeedBonus(this.mMode == Mode.Distillery ? 0.5f : 0.2857143f);
    }

    @Override
    public int getMaxParallelRecipes() {
        switch (this.mMode) {
            case DistillationTower: {
                return this.getTierOfTower() == 1 ? 4 : (this.getTierOfTower() == 2 ? 12 : 0);
            }
            case Distillery: {
                return this.getTierOfTower() * (4 * GT_Utility.getTier((long)this.getMaxInputVoltage()));
            }
        }
        return 0;
    }

    private int getTierOfTower() {
        return this.mUpgraded ? 2 : 1;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER;
    }

    @Override
    protected int getCasingTextureId() {
        return 49;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        ItemStack aGuiStack;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 20L == 0L && !this.mUpgraded && (aGuiStack = this.getControllerSlot()) != null && GT_Utility.areStacksEqual((ItemStack)aGuiStack, (ItemStack)GregtechItemList.Distillus_Upgrade_Chip.get(1L, new Object[0]))) {
            this.mUpgraded = true;
            this.mInventory[1] = ItemUtils.depleteStack(aGuiStack);
        }
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        aNBT.func_74757_a("mUpgraded", this.mUpgraded);
        super.setItemNBT(aNBT);
    }

    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        super.addAdditionalTooltipInformation(stack, tooltip);
        NBTTagCompound aNBT = stack.func_77978_p();
        if (aNBT != null && aNBT.func_74764_b("mUpgraded")) {
            tooltip.add(StatCollector.func_74838_a((String)"tooltip.large_distill_tower.upgraded"));
        }
    }

    private static enum Mode {
        DistillationTower(GT_Recipe.GT_Recipe_Map.sDistillationRecipes),
        Distillery(GT_Recipe.GT_Recipe_Map.sDistilleryRecipes);

        static final Mode[] VALUES;
        private final GT_Recipe.GT_Recipe_Map recipeMap;

        private Mode(GT_Recipe.GT_Recipe_Map recipeMap) {
            this.recipeMap = recipeMap;
        }

        public GT_Recipe.GT_Recipe_Map getRecipeMap() {
            return this.recipeMap;
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        static {
            VALUES = Mode.values();
        }
    }
}

