/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.recipes;

import advsolar.common.AdvancedSolarPanel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class RecipeRemovals {
    public static void postInit() {
        if (Mods.AdvancedSolarPanel.isModLoaded()) {
            RecipeUtils.removeRecipeByOutput(ItemUtils.getSimpleStack(AdvancedSolarPanel.blockMolecularTransformer));
        }
    }

    public static void onLoadComplete() {
        RecipeRemovals.removeCrudeTurbineRotors();
        RecipeRemovals.removeGTRareEarthRecipe();
    }

    private static void removeCrudeTurbineRotors() {
        int aRemoved = 0;
        int CUT = CORE.turbineCutoffBase;
        Collection aAssRecipes = GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.mRecipeList;
        if (aAssRecipes.size() > 0) {
            block5: for (GT_Recipe aG : aAssRecipes) {
                if (!ArrayUtils.isNotEmpty((Object[])aG.mOutputs)) continue;
                for (ItemStack aI : aG.mOutputs) {
                    String aType;
                    int aCutoff;
                    int aMeta;
                    Item aU;
                    if (aI == null || (aU = aI.func_77973_b()) == null || !(aU instanceof GT_MetaGenerated_Tool_01) || (aMeta = aI.func_77960_j()) < 170 || aMeta > 176) continue;
                    switch (aMeta) {
                        case 170: {
                            aCutoff = CUT;
                            aType = "Small ";
                            break;
                        }
                        case 172: {
                            aCutoff = 2 * CUT;
                            aType = "";
                            break;
                        }
                        case 174: {
                            aCutoff = 3 * CUT;
                            aType = "Large ";
                            break;
                        }
                        default: {
                            aCutoff = 4 * CUT;
                            aType = "Huge ";
                        }
                    }
                    Materials aMainMaterial = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aI);
                    Materials aSecondaryMaterial = GT_MetaGenerated_Tool.getSecondaryMaterial((ItemStack)aI);
                    long rotorDurabilityMax = GT_MetaGenerated_Tool.getToolMaxDamage((ItemStack)aI);
                    if (rotorDurabilityMax >= (long)aCutoff) continue block5;
                    Logger.WARNING("[Turbine Cleanup] " + MaterialUtils.getMaterialName(aMainMaterial) + " " + aType + "Turbines have " + rotorDurabilityMax + ", which is below the cutoff durability of " + aCutoff + ", disabling.");
                    aG.mEnabled = false;
                    aG.mHidden = true;
                    aG.mCanBeBuffered = false;
                    ++aRemoved;
                }
            }
        }
        Logger.INFO("Removed " + aRemoved + " useless Turbines.");
    }

    private static void removeGTRareEarthRecipe() {
        Logger.INFO("Processing Gregtech recipe maps, removing recipes to suit GT++.");
        GT_Recipe aRareEarthCentrifuging = GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.findRecipe(null, false, 20L, new FluidStack[0], new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustRareEarth", 1)});
        if (aRareEarthCentrifuging != null && aRareEarthCentrifuging.mEnabled) {
            aRareEarthCentrifuging.mEnabled = false;
            aRareEarthCentrifuging.mHidden = true;
            GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.mRecipeList.remove(aRareEarthCentrifuging);
            GTPP_Recipe.GTPP_Recipe_Map.sMultiblockCentrifugeRecipes_GT.mRecipeList.remove(aRareEarthCentrifuging);
            Logger.INFO("Removed vanilla GT Rare Earth processing.");
        }
    }
}

