/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.general;

import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TileEntityPlayerDoorBase
extends TileEntity {
    public boolean mIsOpen = false;
    private short mMeta = 0;
    private long mTickCounter = 0L;
    private final Block mBlockType;
    private BlockPos mNeighbourDoor;
    AutoMap<Entity> mNearbyEntityCache = new AutoMap();

    public TileEntityPlayerDoorBase(Block aBlock, int meta) {
        this.mBlockType = aBlock;
    }

    public void func_145839_a(NBTTagCompound aNBT) {
        super.func_145839_a(aNBT);
        this.mIsOpen = aNBT.func_74767_n("mIsOpen");
    }

    public void func_145841_b(NBTTagCompound aNBT) {
        super.func_145841_b(aNBT);
        aNBT.func_74757_a("mIsOpen", this.mIsOpen);
    }

    public int getNeighbourState() {
        World aWorld;
        if (this.mNeighbourDoor != null && (aWorld = this.field_145850_b) != null) {
            BlockDoor aDoor;
            TileEntity t = aWorld.func_147438_o(this.mNeighbourDoor.xPos, this.mNeighbourDoor.yPos, this.mNeighbourDoor.zPos);
            if (t != null) {
                if (t instanceof TileEntityPlayerDoorBase) {
                    TileEntityPlayerDoorBase d = (TileEntityPlayerDoorBase)t;
                    if (d.mIsOpen) {
                        return 100;
                    }
                    return -100;
                }
                return -100;
            }
            Block aBlock = this.mNeighbourDoor.getBlockAtPos();
            BlockDoor blockDoor = aDoor = aBlock instanceof BlockDoor ? (BlockDoor)aBlock : null;
            if (aDoor != null) {
                int i1 = aDoor.func_150012_g((IBlockAccess)this.mNeighbourDoor.world, this.mNeighbourDoor.xPos, this.mNeighbourDoor.yPos, this.mNeighbourDoor.zPos);
                if ((i1 & 4) != 0) {
                    return 100;
                }
                return -100;
            }
        }
        return 0;
    }

    public void func_145845_h() {
        World aWorld;
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.mTickCounter % 100L == 0L || this.mTickCounter == 0L) {
            aWorld = this.func_145831_w();
            BlockPos aThisPos = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e, aWorld);
            BlockPos[] aNeighbors = new BlockPos[]{aThisPos.getXNeg(), aThisPos.getXPos(), aThisPos.getZNeg(), aThisPos.getZPos()};
            boolean aFoundDoor = false;
            for (BlockPos b : aNeighbors) {
                BlockDoor aDoor;
                Block aBlock = aWorld.func_147439_a(b.xPos, b.yPos, b.zPos);
                BlockDoor blockDoor = aDoor = aBlock instanceof BlockDoor ? (BlockDoor)aBlock : null;
                if (aDoor == null) continue;
                this.mNeighbourDoor = b;
                aFoundDoor = true;
                if (this.mMeta != 0) break;
                TileEntity t = aWorld.func_147438_o(b.xPos, b.yPos, b.zPos);
                if (t != null) {
                    if (t instanceof TileEntityPlayerDoorBase) {
                        TileEntityPlayerDoorBase d = (TileEntityPlayerDoorBase)t;
                        if (d.mMeta != 0) {
                            this.mMeta = (short)-1;
                            break;
                        }
                        this.mMeta = 1;
                        break;
                    }
                    this.mMeta = (short)-1;
                    break;
                }
                this.mMeta = (short)-1;
                break;
            }
            if (this.mMeta < 1 && !aFoundDoor) {
                this.mMeta = 1;
            }
        }
        aWorld = this.func_145831_w();
        Block aBlock = aWorld.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        BlockPos aThisPos = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        if (this.mTickCounter % 20L == 0L) {
            int x = 0;
            int y = 0;
            int z = 0;
            x = this.field_145851_c;
            y = this.field_145848_d;
            z = this.field_145849_e;
            ArrayList aEntityList = new ArrayList();
            Chunk aThisChunk = aWorld.func_72938_d(x, z);
            for (List l : aThisChunk.field_76645_j) {
                aEntityList.addAll(l);
            }
            for (Object o : aEntityList) {
                Entity e;
                BlockPos p;
                if (o == null || !(o instanceof Entity) || o instanceof EntityPlayer || (p = EntityUtils.findBlockPosUnderEntity(e = (Entity)o)) == null) continue;
                int newY = p.yPos + 1;
                if (e.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 2.0) {
                    this.mNearbyEntityCache.put(e);
                    continue;
                }
                if (aThisPos.distanceFrom(p.xPos, newY, p.zPos) > 2) continue;
                this.mNearbyEntityCache.put(e);
            }
        }
        if (this.mTickCounter % 4L == 0L) {
            for (Entity y : this.mNearbyEntityCache) {
                if (!(y.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) > 2.0)) continue;
                this.mNearbyEntityCache.remove(y);
            }
            boolean foundMonster = this.mNearbyEntityCache.size() > 0;
            int aNeighbourDoorState = 0;
            if (this.mNeighbourDoor != null) {
                aNeighbourDoorState = this.getNeighbourState();
            }
            BlockDoor aDoor = aBlock instanceof BlockDoor ? (BlockDoor)aBlock : null;
            boolean aPlayers = this.checkForPlayers(this.func_145831_w());
            if (aDoor != null) {
                if (aNeighbourDoorState != 0 && this.mMeta == -1) {
                    if (aNeighbourDoorState == 100) {
                        if (!this.mIsOpen && !foundMonster) {
                            aDoor.func_150014_a(aWorld, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
                            this.mIsOpen = true;
                        }
                    } else if ((aNeighbourDoorState == -100 || foundMonster) && this.mIsOpen) {
                        aDoor.func_150014_a(aWorld, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                        this.mIsOpen = false;
                    }
                } else if (aDoor != null && !this.hasRedstone()) {
                    if (aPlayers) {
                        if (!this.mIsOpen && !foundMonster) {
                            aDoor.func_150014_a(aWorld, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
                            this.mIsOpen = true;
                        }
                    } else if (this.mIsOpen || foundMonster) {
                        aDoor.func_150014_a(aWorld, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                        this.mIsOpen = false;
                    }
                }
            }
        }
        super.func_145845_h();
        ++this.mTickCounter;
    }

    public int func_145832_p() {
        return this.mMeta;
    }

    public boolean hasRedstone() {
        World aWorld = this.field_145850_b;
        if (aWorld != null && !aWorld.field_72995_K) {
            return aWorld.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || aWorld.func_72864_z(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
        return false;
    }

    public Block func_145838_q() {
        return this.mBlockType;
    }

    public boolean canUpdate() {
        return true;
    }

    private boolean checkForPlayers(World aWorld) {
        int x = 0;
        int y = 0;
        int z = 0;
        x = this.field_145851_c;
        y = this.field_145848_d;
        z = this.field_145849_e;
        EntityPlayer aPlayer = aWorld.func_72977_a((double)x, (double)y, (double)z, 3.5);
        return aPlayer != null;
    }

    private short getClosedMeta() {
        return 0;
    }

    private short getOpenMeta() {
        return 1;
    }
}

