/*
 * Decompiled with CFR 0.152.
 */
package rwg.commands;

import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import rwg.util.NoiseGeneratorWrapper;
import rwg.util.NoiseImplementation;
import rwg.world.RwgWorldSavedData;

public class RwgNoiseCommand
extends CommandBase {
    public String func_71517_b() {
        return "rwg_noise";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/rwg_noise get|opensimplex|perlin";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        boolean wasDynamic;
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        NoiseImplementation current = RwgWorldSavedData.getNoiseImplementation();
        if (args[0].equals("get")) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("rwg.noise.current_type", new Object[]{current}));
            return;
        }
        NoiseImplementation noiseImplementation = NoiseImplementation.valueOf(args[0].toUpperCase(Locale.ROOT));
        switch (current) {
            case UNKNOWN: 
            case DYNAMICPERLIN: 
            case DYNAMICOPENSIMPLEX: {
                wasDynamic = true;
                break;
            }
            case PERLIN: 
            case OPENSIMPLEX: {
                wasDynamic = false;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid current noise implementation value: " + noiseImplementation.toString());
            }
        }
        if (current != noiseImplementation) {
            switch (noiseImplementation) {
                case UNKNOWN: {
                    NoiseGeneratorWrapper.useOpenSimplex = false;
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("rwg.noise.was_set_to.unknown", new Object[0]));
                    break;
                }
                case DYNAMICPERLIN: 
                case PERLIN: {
                    NoiseGeneratorWrapper.useOpenSimplex = false;
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("rwg.noise.was_set_to.generic", new Object[]{noiseImplementation.toString()}));
                    break;
                }
                case DYNAMICOPENSIMPLEX: 
                case OPENSIMPLEX: {
                    NoiseGeneratorWrapper.useOpenSimplex = true;
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("rwg.noise.was_set_to.generic", new Object[]{noiseImplementation.toString()}));
                }
            }
            if (wasDynamic) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("rwg.noise.instant_new_chunks", new Object[0]));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("rwg.noise.needs_restart", new Object[0]));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("rwg.noise.unchanged", new Object[0]));
        }
        RwgWorldSavedData.setNoiseImplementation(noiseImplementation);
    }
}

