/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.recipe;

import appeng.util.ReadableNumberConverter;
import codechicken.nei.PositionedStack;
import com.github.technus.tectech.recipe.EyeOfHarmonyRecipe;
import com.github.technus.tectech.util.CommonValues;
import com.google.common.math.LongMath;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.GT_NEI_DefaultHandler;
import gregtech.nei.NEIRecipeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class TT_recipe
extends GT_Recipe {
    public static final String E_RECIPE_ID = "eRecipeID";

    public TT_recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
    }

    public static class Eye_Of_Harmony_Recipe_Map
    extends GT_Recipe.GT_Recipe_Map {
        private static final int xDirMaxCount = 9;
        private static final int yOrigin = 8;
        private static final long TRILLION = LongMath.pow((long)10L, (int)12);
        public static final int maxItemsToRender = 80;

        public Eye_Of_Harmony_Recipe_Map(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
            this.useModularUI(true);
            this.setLogoPos(8, 8);
            this.setNEISpecialInfoFormatter((recipeInfo, applyPrefixAndSuffix) -> {
                EyeOfHarmonyRecipe recipe = (EyeOfHarmonyRecipe)recipeInfo.recipe.mSpecialItems;
                ArrayList<String> result = new ArrayList<String>();
                result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.Hydrogen.In", (String)"Hydrogen") + ": " + GT_Utility.formatNumbers((long)recipe.getHydrogenRequirement()) + " L");
                result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.Helium.In", (String)"Helium") + ": " + GT_Utility.formatNumbers((long)recipe.getHydrogenRequirement()) + " L");
                result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.SpacetimeTier", (String)"Spacetime Tier") + ": " + CommonValues.EOH_TIER_FANCY_NAMES[(int)recipe.getSpacetimeCasingTierRequired()]);
                if (recipe.getEUOutput() < TRILLION) {
                    result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.EU.Out", (String)"EU Output") + ": " + GT_Utility.formatNumbers((long)recipe.getEUOutput()) + " EU");
                } else {
                    result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.EU.Out", (String)"EU Output") + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(recipe.getEUOutput()) + " EU");
                }
                if (recipe.getEUOutput() < TRILLION) {
                    result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.EU.In", (String)"EU Input") + ": " + GT_Utility.formatNumbers((long)recipe.getEUStartCost()) + " EU");
                } else {
                    result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.EU.In", (String)"EU Input") + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(recipe.getEUStartCost()) + " EU");
                }
                result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.BaseRecipeChance", (String)"Base Recipe Chance") + ": " + GT_Utility.formatNumbers((double)(100.0 * recipe.getBaseRecipeSuccessChance())) + "%");
                result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.RecipeEnergyEfficiency", (String)"Recipe Energy Efficiency") + ": " + GT_Utility.formatNumbers((double)(100.0 * recipe.getRecipeEnergyEfficiency())) + "%");
                if (recipe.getOutputItems().size() > 80) {
                    result.add("" + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.Warning.0", (String)"Warning") + EnumChatFormatting.RESET + ": " + GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.Warning.1", (String)"Not all items displayed."));
                }
                return result;
            });
        }

        public boolean usesSpecialSlot() {
            return false;
        }

        public List<Pos2d> getItemInputPositions(int itemInputCount) {
            return UIHelper.getGridPositions((int)itemInputCount, (int)79, (int)8, (int)1, (int)1);
        }

        public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
            return UIHelper.getGridPositions((int)Math.min(itemOutputCount, 81), (int)7, (int)44, (int)9, (int)12);
        }

        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getGridPositions((int)fluidInputCount, (int)0, (int)0, (int)0, (int)0);
        }

        public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
            return UIHelper.getGridPositions((int)fluidOutputCount, (int)7, (int)206, (int)9, (int)3);
        }

        public ModularWindow.Builder createNEITemplate(IItemHandlerModifiable itemInputsInventory, IItemHandlerModifiable itemOutputsInventory, IItemHandlerModifiable specialSlotInventory, IItemHandlerModifiable fluidInputsInventory, IItemHandlerModifiable fluidOutputsInventory, Supplier<Float> progressSupplier, Pos2d windowOffset) {
            this.setNEIBackgroundSize(172, 117 + Math.max(this.getItemRowCount() + this.getFluidRowCount() - 4, 0) * 18);
            return super.createNEITemplate(itemInputsInventory, itemOutputsInventory, specialSlotInventory, fluidInputsInventory, fluidOutputsInventory, progressSupplier, windowOffset);
        }

        private int getItemRowCount() {
            return (Math.max(this.mUsualInputCount, this.mUsualOutputCount) - 1) / 9 + 1;
        }

        private int getFluidRowCount() {
            return (Math.max(this.getUsualFluidInputCount(), this.getUsualFluidOutputCount()) - 1) / 9 + 1;
        }

        protected void drawNEIText(NEIRecipeInfo recipeInfo, String text, int yShift) {
            this.drawNEIText(recipeInfo, text, 7, yShift);
        }

        public List<String> handleNEIItemTooltip(ItemStack stack, List<String> currentTip, GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
            super.handleNEIItemTooltip(stack, currentTip, neiCachedRecipe);
            if (stack == null) {
                return currentTip;
            }
            EyeOfHarmonyRecipe currentRecipe = (EyeOfHarmonyRecipe)neiCachedRecipe.mRecipe.mSpecialItems;
            if (stack.func_77969_a(currentRecipe.getRecipeTriggerItem())) {
                currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"Total Items: ") + GT_Utility.formatNumbers((long)currentRecipe.getSumOfItems()));
                return currentTip;
            }
            double percentage = (Double)currentRecipe.getItemStackToProbabilityMap().getOrDefault((Object)stack, (Object)-1.0);
            if (percentage != -1.0) {
                currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"Percentage of Solid Mass: ") + percentage + "%");
                currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"Item Count: ") + GT_Utility.formatNumbers((long)((Long)currentRecipe.getItemStackToTrueStackSizeMap().get((Object)stack))));
            }
            return currentTip;
        }

        public void drawNEIOverlays(GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
            EyeOfHarmonyRecipe EOHRecipe = (EyeOfHarmonyRecipe)neiCachedRecipe.mRecipe.mSpecialItems;
            for (PositionedStack stack : neiCachedRecipe.mInputs) {
                if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack) || !stack.item.func_77969_a(EOHRecipe.getRecipeTriggerItem())) continue;
                this.drawNEIOverlayText(StatCollector.func_74838_a((String)"NC"), stack);
            }
            for (PositionedStack stack : neiCachedRecipe.mOutputs) {
                if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack) || !EOHRecipe.getItemStackToTrueStackSizeMap().containsKey((Object)stack.item)) continue;
                long stackSize = (Long)EOHRecipe.getItemStackToTrueStackSizeMap().get((Object)stack.item);
                String displayString = stackSize > 9999L ? ReadableNumberConverter.INSTANCE.toWideReadableForm(stackSize) : String.valueOf(stackSize);
                this.drawNEIOverlayText(displayString, stack, 0xFFFFFF, 0.5f, true, Alignment.BottomRight);
            }
        }
    }

    public static class TT_assLineRecipe
    extends GT_Recipe {
        public final ItemStack mResearchItem;

        public TT_assLineRecipe(boolean aOptimize, ItemStack researchItem, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, FluidStack[] aFluidInputs, int aDuration, int aEUt, int aSpecialValue) {
            super(aOptimize, aInputs, aOutputs, aSpecialItems, null, aFluidInputs, null, aDuration, aEUt, aSpecialValue);
            this.mResearchItem = researchItem;
        }
    }

    public static class GT_Recipe_MapTT
    extends GT_Recipe.GT_Recipe_Map {
        public static final GT_Recipe.GT_Recipe_Map sEyeofHarmonyRecipes = new Eye_Of_Harmony_Recipe_Map(new HashSet<GT_Recipe>(250), "gt.recipe.eyeofharmony", "Eye of Harmony", null, "gregtech:textures/gui/basicmachines/Extractor", 1, 81, 1, 0, 1, "", 1, "", true, false).setProgressBar(GT_UITextures.PROGRESSBAR_HAMMER, ProgressBar.Direction.DOWN).setProgressBarPos(78, 26).setUsualFluidOutputCount(18).setLogoPos(10, 10);
        public static GT_Recipe_MapTT sResearchableFakeRecipes = new GT_Recipe_MapTT(new HashSet<GT_Recipe>(32), "gt.recipe.researchStation", "Research station", null, "gregtech:textures/gui/multimachines/ResearchFake", 1, 1, 1, 0, 1, "", 1, "", true, false);
        public static GT_Recipe_MapTT sScannableFakeRecipes = new GT_Recipe_MapTT(new HashSet<GT_Recipe>(32), "gt.recipe.em_scanner", "EM Scanner Research", null, "gregtech:textures/gui/multimachines/ResearchFake", 1, 1, 1, 0, 1, "", 1, "", true, false);
        public static ArrayList<GT_Recipe.GT_Recipe_AssemblyLine> sAssemblylineRecipes = new ArrayList();

        public GT_Recipe_MapTT(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }
    }

    public static class TT_Recipe_Map<T extends GT_Recipe> {
        public static TT_Recipe_Map<TT_assLineRecipe> sCrafterRecipes = new TT_Recipe_Map();
        public static TT_Recipe_Map<TT_assLineRecipe> sMachineRecipes = new TT_Recipe_Map();
        private final HashMap<String, T> mRecipeMap = new HashMap(16);

        public T findRecipe(String identifier) {
            return (T)((GT_Recipe)this.mRecipeMap.get(identifier));
        }

        public T findRecipe(ItemStack dataHandler) {
            if (dataHandler == null || dataHandler.field_77990_d == null) {
                return null;
            }
            return (T)((GT_Recipe)this.mRecipeMap.get(dataHandler.field_77990_d.func_74779_i(TT_recipe.E_RECIPE_ID)));
        }

        public void add(T recipe) {
            GameRegistry.UniqueIdentifier uid = GameRegistry.findUniqueIdentifierFor((Item)((GT_Recipe)recipe).mOutputs[0].func_77973_b());
            this.mRecipeMap.put(uid + ":" + ((GT_Recipe)recipe).mOutputs[0].func_77960_j(), recipe);
        }

        public Collection<T> recipeList() {
            return this.mRecipeMap.values();
        }
    }
}

