/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.pipe;

import com.github.technus.tectech.mechanics.pipe.IActivePipe;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import eu.usrv.yamcore.network.server.AbstractServerMessageHandler;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PipeActivityMessage
implements IMessage {
    int mPosX;
    int mPosY;
    int mPosZ;
    int mPosD;
    int mActive;

    public PipeActivityMessage() {
    }

    private PipeActivityMessage(IActivePipe metaTile) {
        IGregTechTileEntity base = metaTile.getBaseMetaTileEntity();
        this.mPosX = base.getXCoord();
        this.mPosY = base.getYCoord();
        this.mPosZ = base.getZCoord();
        this.mPosD = base.getWorld().field_73011_w.field_76574_g;
        this.mActive = metaTile.getActive() ? 1 : 0;
    }

    private PipeActivityMessage(World world, int x, int y, int z, boolean active) {
        this.mPosX = x;
        this.mPosY = y;
        this.mPosZ = z;
        this.mPosD = world.field_73011_w.field_76574_g;
        this.mActive = active ? 1 : 0;
    }

    public void fromBytes(ByteBuf pBuffer) {
        NBTTagCompound tTag = ByteBufUtils.readTag((ByteBuf)pBuffer);
        this.mPosX = tTag.func_74762_e("posx");
        this.mPosY = tTag.func_74762_e("posy");
        this.mPosZ = tTag.func_74762_e("posz");
        this.mPosD = tTag.func_74762_e("posd");
        this.mActive = tTag.func_74762_e("active");
    }

    public void toBytes(ByteBuf pBuffer) {
        NBTTagCompound tFXTag = new NBTTagCompound();
        tFXTag.func_74768_a("posx", this.mPosX);
        tFXTag.func_74768_a("posy", this.mPosY);
        tFXTag.func_74768_a("posz", this.mPosZ);
        tFXTag.func_74768_a("posd", this.mPosD);
        tFXTag.func_74768_a("active", this.mActive);
        ByteBufUtils.writeTag((ByteBuf)pBuffer, (NBTTagCompound)tFXTag);
    }

    public static class ServerHandler
    extends AbstractServerMessageHandler<PipeActivityQuery> {
        public IMessage handleServerMessage(EntityPlayer pPlayer, PipeActivityQuery pMessage, MessageContext pCtx) {
            IMetaTileEntity meta;
            TileEntity te;
            WorldServer world = DimensionManager.getWorld((int)pMessage.mPosD);
            if (world != null && (te = world.func_147438_o(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ)) instanceof IGregTechTileEntity && (meta = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof IActivePipe) {
                pMessage.mActive = ((IActivePipe)meta).getActive() ? 1 : 0;
                return new PipeActivityData(pMessage);
            }
            return null;
        }
    }

    public static class ClientHandler
    extends AbstractClientMessageHandler<PipeActivityData> {
        public IMessage handleClientMessage(EntityPlayer pPlayer, PipeActivityData pMessage, MessageContext pCtx) {
            IMetaTileEntity meta;
            TileEntity te;
            if (pPlayer.field_70170_p.field_73011_w.field_76574_g == pMessage.mPosD && (te = pPlayer.field_70170_p.func_147438_o(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ)) instanceof IGregTechTileEntity && (meta = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof IActivePipe) {
                ((IActivePipe)meta).setActive(pMessage.mActive == 1);
            }
            return null;
        }
    }

    public static class PipeActivityData
    extends PipeActivityMessage {
        public PipeActivityData() {
        }

        private PipeActivityData(PipeActivityQuery query) {
            this.mPosX = query.mPosX;
            this.mPosY = query.mPosY;
            this.mPosZ = query.mPosZ;
            this.mPosD = query.mPosD;
            this.mActive = query.mActive;
        }

        public PipeActivityData(IActivePipe metaTile) {
            super(metaTile);
        }

        public PipeActivityData(World world, int x, int y, int z, boolean active) {
            super(world, x, y, z, active);
        }
    }

    public static class PipeActivityQuery
    extends PipeActivityMessage {
        public PipeActivityQuery() {
        }

        public PipeActivityQuery(IActivePipe metaTile) {
            super(metaTile);
        }

        public PipeActivityQuery(World world, int x, int y, int z, boolean active) {
            super(world, x, y, z, active);
        }
    }
}

