/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.tile;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import remoteio.common.tile.core.TileCore;

public class TileMachineReservoir
extends TileCore
implements IFluidHandler {
    public boolean filled = false;

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("filled", this.filled);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.filled = nbt.func_74767_n("filled");
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.update();
            if (this.filled) {
                this.push();
            }
        }
    }

    @Override
    public void onNeighborUpdated() {
        this.update();
    }

    private void update() {
        boolean newFilled;
        int found = 0;
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + forgeDirection.offsetX, this.field_145848_d + forgeDirection.offsetY, this.field_145849_e + forgeDirection.offsetZ);
            if (block == null || block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
            ++found;
        }
        boolean bl = newFilled = found >= 2;
        if (this.filled != newFilled) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.filled = newFilled;
    }

    private void push() {
        int found = 0;
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + forgeDirection.offsetX, this.field_145848_d + forgeDirection.offsetY, this.field_145849_e + forgeDirection.offsetZ);
            if (!(tileEntity instanceof IFluidHandler)) continue;
            ++found;
        }
        int amount = (int)(1000.0f / (float)found);
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + forgeDirection.offsetX, this.field_145848_d + forgeDirection.offsetY, this.field_145849_e + forgeDirection.offsetZ);
            if (!(tileEntity instanceof IFluidHandler)) continue;
            ((IFluidHandler)tileEntity).fill(forgeDirection.getOpposite(), new FluidStack(FluidRegistry.WATER, amount), true);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource.getFluid().equals(FluidRegistry.WATER)) {
            return new FluidStack(FluidRegistry.WATER, resource.amount);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return new FluidStack(FluidRegistry.WATER, maxDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(FluidRegistry.WATER, 1000), 1000)};
    }
}

