/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ItemModTypeFilter;

public class ModRedstone
extends ItemModTypeFilter {
    public String tooltipName = "\u00a74Haste";
    public int max = 50;

    public ModRedstone(int effect, ItemStack[] items, int[] values) {
        super(effect, "Redstone", items, values);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (tool.func_77973_b() instanceof ToolCore) {
            ToolCore toolItem = (ToolCore)tool.func_77973_b();
            if (!this.validType(toolItem)) {
                return false;
            }
            if (this.matchingAmount(input) > this.max) {
                return false;
            }
            NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
            if (!tags.func_74764_b(this.key)) {
                return tags.func_74762_e("Modifiers") > 0 && this.matchingAmount(input) <= this.max;
            }
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] + this.matchingAmount(input) <= keyPair[1]) {
                return true;
            }
            if (keyPair[0] == keyPair[1]) {
                return tags.func_74762_e("Modifiers") > 0;
            }
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        int current;
        int modifiers;
        int[] keyPair;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int increase = this.matchingAmount(input);
        if (tags.func_74764_b(this.key)) {
            keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.func_74783_a(this.key, keyPair);
                modifiers = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.func_74783_a(this.key, keyPair);
            }
            current = keyPair[0];
            this.updateModTag(tool, keyPair);
        } else {
            modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
            String modName = "\u00a74Redstone (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            keyPair = new int[]{increase, this.max, tooltipIndex};
            current = keyPair[0];
            tags.func_74783_a(this.key, keyPair);
        }
        int miningSpeed = tags.func_74762_e("MiningSpeed");
        int boost = 8 + (current - 1) / 50 * 2;
        Item temp = tool.func_77973_b();
        if (temp instanceof ToolCore) {
            ToolCore toolcore = (ToolCore)temp;
            if (toolcore.durabilityTypeHandle() == 2) {
                boost += 2;
            }
            if (toolcore.durabilityTypeAccessory() == 2) {
                boost += 2;
            }
            if (toolcore.durabilityTypeExtra() == 2) {
                boost += 2;
            }
        }
        tags.func_74768_a("MiningSpeed", miningSpeed += increase * boost);
        String[] type = new String[]{"MiningSpeed2", "MiningSpeedHandle", "MiningSpeedExtra"};
        for (int i = 0; i < 3; ++i) {
            if (!tags.func_74764_b(type[i])) continue;
            int speed = tags.func_74762_e(type[i]);
            tags.func_74768_a(type[i], speed += increase * boost);
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a74Redstone (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }

    @Override
    public boolean validType(IModifyable input) {
        return input.getModifyType().equals("Tool");
    }

    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.getTraits());
        if (list.contains("windup")) {
            return false;
        }
        return list.contains("harvest") || list.contains("utility");
    }
}

