/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.botany.flowers;

import codechicken.nei.api.API;
import codechicken.nei.config.Option;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ISpeciesRoot;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.botany.AddonBotany;
import net.bdew.neiaddons.botany.flowers.FlowerBreedingHandler;
import net.bdew.neiaddons.forestry.MutationDumper;

public class FlowerHelper {
    public static Class<? extends IAlleleSpecies> flowerSpeciesClass;
    public static ISpeciesRoot root;

    public static void setup() {
        root = AlleleManager.alleleRegistry.getSpeciesRoot("rootFlowers");
        if (root == null) {
            AddonBotany.instance.logWarning("Failed to load Flower root, Botany support disabled", new Object[0]);
            return;
        }
        try {
            flowerSpeciesClass = Utils.getAndCheckClass("binnie.botany.api.IAlleleFlowerSpecies", IAlleleSpecies.class);
        }
        catch (Throwable e) {
            AddonBotany.instance.logWarningExc(e, "Failed to load Flower species interface, Botany support disabled", new Object[0]);
            return;
        }
        AddonBotany.instance.logInfo("Root=%s Species=%s", root, flowerSpeciesClass);
        if (AddonBotany.showFlowerMutations) {
            FlowerBreedingHandler breedingRecipeHandler = new FlowerBreedingHandler();
            API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
            API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
            AddonBotany.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        }
        API.addOption((Option)new MutationDumper(root, "flower_mutation"));
    }
}

