/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.integration.DrawUtils;
import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidChunkLocation;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps.RenderStep;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;

public class UndergroundFluidChunkRenderStep
implements RenderStep {
    private final UndergroundFluidChunkLocation undergroundFluidChunkLocation;

    public UndergroundFluidChunkRenderStep(UndergroundFluidChunkLocation location) {
        this.undergroundFluidChunkLocation = location;
    }

    private String getFluidAmountFormatted() {
        if (this.undergroundFluidChunkLocation.getFluidAmount() >= 1000) {
            return this.undergroundFluidChunkLocation.getFluidAmount() / 1000 + "kL";
        }
        return this.undergroundFluidChunkLocation.getFluidAmount() + "L";
    }

    @Override
    public void draw(@Nullable GuiScreen gui, double cameraX, double cameraZ, double scale) {
        if (this.undergroundFluidChunkLocation.getFluidAmount() > 0 && scale >= Utils.journeyMapScaleToLinear(Config.minZoomLevelForUndergroundFluidDetails)) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.undergroundFluidChunkLocation.getBlockX() - 0.5 - cameraX), (double)(this.undergroundFluidChunkLocation.getBlockZ() - 0.5 - cameraZ), (double)0.0);
            float alpha = (float)(this.undergroundFluidChunkLocation.getFluidAmount() - this.undergroundFluidChunkLocation.getMinAmountInField()) / (float)(this.undergroundFluidChunkLocation.getMaxAmountInField() - this.undergroundFluidChunkLocation.getMinAmountInField() + 1);
            alpha *= alpha * 204.0f;
            int fluidColor = this.undergroundFluidChunkLocation.getFluid().getColor() | (int)alpha << 24;
            DrawUtils.drawGradientRect(0.0, 0.0, 16.0, 16.0, 0.0, fluidColor, fluidColor);
            if (this.undergroundFluidChunkLocation.getFluidAmount() >= this.undergroundFluidChunkLocation.getMaxAmountInField()) {
                int borderColor = -855648512;
                DrawUtils.drawGradientRect(0.0, 0.0, 15.0, 1.0, 0.0, -855648512, -855648512);
                DrawUtils.drawGradientRect(15.0, 0.0, 16.0, 15.0, 0.0, -855648512, -855648512);
                DrawUtils.drawGradientRect(1.0, 15.0, 16.0, 16.0, 0.0, -855648512, -855648512);
                DrawUtils.drawGradientRect(0.0, 1.0, 1.0, 16.0, 0.0, -855648512, -855648512);
            }
            GL11.glScaled((double)(1.0 / scale), (double)(1.0 / scale), (double)1.0);
            if (gui != null) {
                DrawUtils.drawSimpleLabel(gui, this.getFluidAmountFormatted(), 13.0, 13.0, -1, -1275068416, false);
            }
            GL11.glPopMatrix();
        }
    }
}

