/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;

public class OreVeinPosition {
    private static final int MAX_BYTES = 13;
    public final int dimensionId;
    public final int chunkX;
    public final int chunkZ;
    public final VeinType veinType;
    private boolean depleted = false;

    public OreVeinPosition(int dimensionId, int chunkX, int chunkZ, VeinType veinType) {
        this.dimensionId = dimensionId;
        this.chunkX = Utils.mapToCenterOreChunkCoord(chunkX);
        this.chunkZ = Utils.mapToCenterOreChunkCoord(chunkZ);
        this.veinType = veinType;
    }

    public OreVeinPosition(int dimensionId, int chunkX, int chunkZ, VeinType veinType, boolean depleted) {
        this.dimensionId = dimensionId;
        this.chunkX = Utils.mapToCenterOreChunkCoord(chunkX);
        this.chunkZ = Utils.mapToCenterOreChunkCoord(chunkZ);
        this.veinType = veinType;
        this.depleted = depleted;
    }

    public int getBlockX() {
        return Utils.coordChunkToBlock(this.chunkX) + 8;
    }

    public int getBlockZ() {
        return Utils.coordChunkToBlock(this.chunkZ) + 8;
    }

    public boolean isDepleted() {
        return this.depleted;
    }

    public void toggleDepleted() {
        this.depleted = !this.depleted;
    }

    public OreVeinPosition joinDepletedState(OreVeinPosition other) {
        this.depleted = this.depleted || other.depleted;
        return this;
    }

    public static int getMaxBytes() {
        return 13 + VeinTypeCaching.getLongesOreNameLength();
    }
}

