/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.List;
import java.util.ListIterator;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.coremod.transformers.TransformerBase;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class EntityPlayerTransformer
extends TransformerBase {
    private String entityPlayerClassName;
    private String inventoryClassName;
    private String itemStackClassName;
    private String entityClassName;
    private String entityLivingClassName;
    private String playerInventoryFieldName;
    private String playerItemInUseField;
    private String swingProgressBooleanField;
    private String swingProgressIntField;
    private String swingProgressFloatField;
    private String onItemFinishMethodName;
    private String setCurrentItemArmourMethodName;
    private String setCurrentItemArmourMethodDesc;
    private String onUpdateMethodName;
    private String playerUpdateArmSwingMethodName;
    private String getArmSwingEndMethodName;
    private String interactWithMethodName;
    private String interactWithMethodDesc;

    public EntityPlayerTransformer() {
        super("net.minecraft.entity.player.EntityPlayer");
    }

    @Override
    void addInterface(List<String> interfaces) {
        interfaces.add(Type.getInternalName(IBattlePlayer.class));
    }

    @Override
    boolean processFields(List<FieldNode> fields) {
        this.logger.log(Level.INFO, "\tAdding new fields to EntityPlayer");
        fields.add(fields.size(), new FieldNode(1, "offHandSwingProgress", "F", null, (Object)Float.valueOf(0.0f)));
        fields.add(fields.size(), new FieldNode(1, "prevOffHandSwingProgress", "F", null, (Object)Float.valueOf(0.0f)));
        fields.add(fields.size(), new FieldNode(1, "offHandSwingProgressInt", "I", null, (Object)0));
        fields.add(fields.size(), new FieldNode(1, "isOffHandSwingInProgress", "Z", null, (Object)false));
        fields.add(fields.size(), new FieldNode(1, "specialActionTimer", "I", null, (Object)0));
        fields.add(fields.size(), new FieldNode(1, "isShielding", "Z", null, (Object)false));
        return true;
    }

    @Override
    boolean processMethods(List<MethodNode> methods) {
        int found = 0;
        for (MethodNode mn : methods) {
            InsnList newList;
            if (mn.name.equals("<init>")) {
                this.logger.log(Level.INFO, "\tPatching constructor in EntityPlayer");
                for (AbstractInsnNode insn : mn.instructions) {
                    if (insn instanceof TypeInsnNode) {
                        if (!((TypeInsnNode)insn).desc.equals(this.inventoryClassName)) continue;
                        ((TypeInsnNode)insn).desc = "mods/battlegear2/api/core/InventoryPlayerBattle";
                        continue;
                    }
                    if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals(this.inventoryClassName)) continue;
                    ((MethodInsnNode)insn).owner = "mods/battlegear2/api/core/InventoryPlayerBattle";
                }
                ++found;
                continue;
            }
            if (mn.name.equals(this.onItemFinishMethodName) && mn.desc.equals("()V")) {
                this.sendPatchLog("onItemUseFinish");
                newList = new InsnList();
                for (AbstractInsnNode next : mn.instructions) {
                    if (next instanceof MethodInsnNode && ((MethodInsnNode)next).owner.equals("net/minecraftforge/event/ForgeEventFactory")) {
                        ++found;
                        int index = ((MethodInsnNode)next).desc.indexOf(")");
                        String newDesc = ((MethodInsnNode)next).desc.substring(0, index) + "I" + ((MethodInsnNode)next).desc.substring(index);
                        newList.add((AbstractInsnNode)new VarInsnNode(21, 1));
                        newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/BattlegearUtils", "beforeFinishUseEvent", newDesc));
                        continue;
                    }
                    newList.add(next);
                }
                mn.instructions = newList;
                continue;
            }
            if (mn.name.equals(this.onUpdateMethodName) && mn.desc.equals("()V")) {
                this.sendPatchLog("onUpdate");
                newList = new InsnList();
                ListIterator it = mn.instructions.iterator();
                while (it.hasNext()) {
                    AbstractInsnNode next;
                    next = (AbstractInsnNode)it.next();
                    if (next instanceof FieldInsnNode && ((FieldInsnNode)next).owner.equals(this.entityPlayerClassName) && ((FieldInsnNode)next).name.equals(this.playerInventoryFieldName)) {
                        ++found;
                        newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerItemInUseField, "L" + this.itemStackClassName + ";"));
                        newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/BattlegearUtils", "getCurrentItemOnUpdate", "(L" + this.entityPlayerClassName + ";L" + this.itemStackClassName + ";)L" + this.itemStackClassName + ";"));
                        next = (AbstractInsnNode)it.next();
                        continue;
                    }
                    newList.add(next);
                }
                mn.instructions = newList;
                continue;
            }
            if (mn.name.equals(this.setCurrentItemArmourMethodName) && mn.desc.equals(this.setCurrentItemArmourMethodDesc)) {
                this.sendPatchLog("setCurrentItemOrArmor");
                EntityPlayerTransformer.replaceInventoryArrayAccess(mn, this.entityPlayerClassName, this.playerInventoryFieldName, mn.maxStack, mn.maxLocals);
                ++found;
                continue;
            }
            if (!mn.name.equals(this.interactWithMethodName) || !mn.desc.equals(this.interactWithMethodDesc)) continue;
            this.sendPatchLog("interactWith");
            MethodNode mv = new MethodNode(1, this.interactWithMethodName, this.interactWithMethodDesc, null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "mods/battlegear2/api/core/BattlegearUtils", "interactWith", "(L" + this.entityPlayerClassName + ";L" + this.entityClassName + ";)Z");
            mv.visitInsn(172);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + this.entityPlayerClassName + ";", null, l0, l1, 0);
            mv.visitLocalVariable("p_70998_1_", "L" + this.entityClassName + ";", null, l0, l1, 1);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            mn.instructions = mv.instructions;
            ++found;
        }
        this.logger.log(Level.INFO, "\tCreating new methods in EntityPlayer");
        methods.add(methods.size(), this.generateAttackOffhandMethod());
        methods.add(methods.size(), this.generateSwingOffhand());
        methods.add(methods.size(), this.generateGetOffSwingMethod());
        methods.add(methods.size(), this.generateUpdateSwingArm());
        methods.add(methods.size(), this.generateIsBattleMode());
        methods.add(methods.size(), this.generateIsBlockingWithShield());
        methods.add(methods.size(), this.generateSetBlockingWithShield());
        methods.add(methods.size(), EntityPlayerTransformer.generateGetter(this.entityPlayerClassName, "getSpecialActionTimer", "specialActionTimer", "I"));
        methods.add(methods.size(), EntityPlayerTransformer.generateSetter(this.entityPlayerClassName, "setSpecialActionTimer", "specialActionTimer", "I"));
        return found == 5;
    }

    private MethodNode generateIsBlockingWithShield() {
        MethodNode mv = new MethodNode(1, "isBlockingWithShield", "()Z", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "mods/battlegear2/api/core/BattlegearUtils", "canBlockWithShield", "(L" + this.entityPlayerClassName + ";)Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "isShielding", "Z");
        mv.visitJumpInsn(153, l1);
        mv.visitInsn(4);
        Label l2 = new Label();
        mv.visitJumpInsn(167, l2);
        mv.visitLabel(l1);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(3);
        mv.visitLabel(l2);
        mv.visitFrame(4, 0, null, 1, new Object[]{INTEGER});
        mv.visitInsn(172);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + this.entityPlayerClassName + ";", null, l0, l3, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return mv;
    }

    private MethodNode generateSetBlockingWithShield() {
        MethodNode mv = new MethodNode(1, "setBlockingWithShield", "(Z)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "mods/battlegear2/api/core/BattlegearUtils", "canBlockWithShield", "(L" + this.entityPlayerClassName + ";)Z");
        mv.visitJumpInsn(153, l1);
        mv.visitInsn(4);
        Label l2 = new Label();
        mv.visitJumpInsn(167, l2);
        mv.visitLabel(l1);
        mv.visitFrame(4, 0, null, 1, new Object[]{this.entityPlayerClassName});
        mv.visitInsn(3);
        mv.visitLabel(l2);
        mv.visitFrame(0, 2, new Object[]{this.entityPlayerClassName, INTEGER}, 2, new Object[]{this.entityPlayerClassName, INTEGER});
        mv.visitFieldInsn(181, this.entityPlayerClassName, "isShielding", "Z");
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitInsn(177);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "L" + this.entityPlayerClassName + ";", null, l0, l4, 0);
        mv.visitLocalVariable("block", "Z", null, l0, l4, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        return mv;
    }

    private MethodNode generateAttackOffhandMethod() {
        MethodNode mv = new MethodNode(1, "attackTargetEntityWithCurrentOffItem", "(L" + this.entityClassName + ";)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "mods/battlegear2/api/core/BattlegearUtils", "attackTargetEntityWithCurrentOffItem", "(L" + this.entityPlayerClassName + ";L" + this.entityClassName + ";)V");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "L" + this.entityPlayerClassName + ";", null, l0, l2, 0);
        mv.visitLocalVariable("target", "L" + this.entityClassName + ";", null, l0, l2, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        return mv;
    }

    private MethodNode generateSwingOffhand() {
        MethodNode mv = new MethodNode(1, "swingOffItem", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.entityPlayerClassName, this.getArmSwingEndMethodName, "()I");
        mv.visitInsn(5);
        mv.visitInsn(108);
        mv.visitJumpInsn(162, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        Label l2 = new Label();
        mv.visitJumpInsn(156, l2);
        mv.visitLabel(l1);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(2);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z");
        mv.visitLabel(l2);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "L" + this.entityPlayerClassName + ";", null, l0, l4, 0);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        return mv;
    }

    private MethodNode generateGetOffSwingMethod() {
        MethodNode mv = new MethodNode(1, "getOffSwingProgress", "(F)F", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "offHandSwingProgress", "F");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "prevOffHandSwingProgress", "F");
        mv.visitInsn(102);
        mv.visitVarInsn(56, 2);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(23, 2);
        mv.visitInsn(11);
        mv.visitInsn(150);
        Label l2 = new Label();
        mv.visitJumpInsn(156, l2);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitVarInsn(23, 2);
        mv.visitInsn(12);
        mv.visitInsn(98);
        mv.visitVarInsn(56, 2);
        mv.visitLabel(l2);
        mv.visitFrame(1, 1, new Object[]{FLOAT}, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "prevOffHandSwingProgress", "F");
        mv.visitVarInsn(23, 2);
        mv.visitVarInsn(23, 1);
        mv.visitInsn(106);
        mv.visitInsn(98);
        mv.visitInsn(174);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "L" + this.entityPlayerClassName + ";", null, l0, l4, 0);
        mv.visitLocalVariable("frame", "F", null, l0, l4, 1);
        mv.visitLocalVariable("diff", "F", null, l1, l4, 2);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        return mv;
    }

    private MethodNode generateUpdateSwingArm() {
        MethodNode mv = new MethodNode(4, this.playerUpdateArmSwingMethodName, "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.entityLivingClassName, this.playerUpdateArmSwingMethodName, "()V");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "offHandSwingProgress", "F");
        mv.visitFieldInsn(181, this.entityPlayerClassName, "prevOffHandSwingProgress", "F");
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.entityPlayerClassName, this.getArmSwingEndMethodName, "()I");
        mv.visitVarInsn(54, 1);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z");
        Label l4 = new Label();
        mv.visitJumpInsn(153, l4);
        Label l5 = new Label();
        mv.visitLabel(l5);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        mv.visitInsn(4);
        mv.visitInsn(96);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        Label l6 = new Label();
        mv.visitLabel(l6);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        mv.visitVarInsn(21, 1);
        Label l7 = new Label();
        mv.visitJumpInsn(161, l7);
        Label l8 = new Label();
        mv.visitLabel(l8);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        Label l9 = new Label();
        mv.visitLabel(l9);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z");
        mv.visitJumpInsn(167, l7);
        mv.visitLabel(l4);
        mv.visitFrame(1, 1, new Object[]{INTEGER}, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        mv.visitLabel(l7);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        mv.visitInsn(134);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(134);
        mv.visitInsn(110);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "offHandSwingProgress", "F");
        Label l10 = new Label();
        mv.visitLabel(l10);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.entityPlayerClassName, "specialActionTimer", "I");
        Label l11 = new Label();
        mv.visitJumpInsn(158, l11);
        Label l12 = new Label();
        mv.visitLabel(l12);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z");
        Label l13 = new Label();
        mv.visitLabel(l13);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, this.entityPlayerClassName, this.swingProgressBooleanField, "Z");
        Label l14 = new Label();
        mv.visitLabel(l14);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(11);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "offHandSwingProgress", "F");
        Label l15 = new Label();
        mv.visitLabel(l15);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I");
        Label l16 = new Label();
        mv.visitLabel(l16);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(11);
        mv.visitFieldInsn(181, this.entityPlayerClassName, this.swingProgressFloatField, "F");
        Label l17 = new Label();
        mv.visitLabel(l17);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, this.entityPlayerClassName, this.swingProgressIntField, "I");
        mv.visitLabel(l11);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        Label l18 = new Label();
        mv.visitLabel(l18);
        mv.visitLocalVariable("this", "L" + this.entityPlayerClassName + ";", null, l0, l18, 0);
        mv.visitLocalVariable("var1", "I", null, l3, l18, 1);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        return mv;
    }

    private MethodNode generateIsBattleMode() {
        MethodNode mv = new MethodNode(1, "isBattlemode", "()Z", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "mods/battlegear2/api/core/BattlegearUtils", "isPlayerInBattlemode", "(L" + this.entityPlayerClassName + ";)Z");
        mv.visitInsn(172);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + this.entityPlayerClassName + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return mv;
    }

    @Override
    void setupMappings() {
        this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayer");
        this.inventoryClassName = BattlegearTranslator.getMapedClassName("entity.player.InventoryPlayer");
        this.itemStackClassName = BattlegearTranslator.getMapedClassName("item.ItemStack");
        this.entityClassName = BattlegearTranslator.getMapedClassName("entity.Entity");
        this.entityLivingClassName = BattlegearTranslator.getMapedClassName("entity.EntityLivingBase");
        this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("field_71071_by", "inventory");
        this.playerItemInUseField = BattlegearTranslator.getMapedFieldName("field_71074_e", "itemInUse");
        this.swingProgressBooleanField = BattlegearTranslator.getMapedFieldName("field_82175_bq", "isSwingInProgress");
        this.swingProgressIntField = BattlegearTranslator.getMapedFieldName("field_110158_av", "swingProgressInt");
        this.swingProgressFloatField = BattlegearTranslator.getMapedFieldName("field_70733_aJ", "swingProgress");
        this.onItemFinishMethodName = BattlegearTranslator.getMapedMethodName("func_71036_o", "onItemUseFinish");
        this.setCurrentItemArmourMethodName = BattlegearTranslator.getMapedMethodName("func_70062_b", "setCurrentItemOrArmor");
        this.setCurrentItemArmourMethodDesc = "(IL" + this.itemStackClassName + ";)V";
        this.onUpdateMethodName = BattlegearTranslator.getMapedMethodName("func_70071_h_", "onUpdate");
        this.playerUpdateArmSwingMethodName = BattlegearTranslator.getMapedMethodName("func_82168_bl", "updateArmSwingProgress");
        this.getArmSwingEndMethodName = BattlegearTranslator.getMapedMethodName("func_82166_i", "getArmSwingAnimationEnd");
        this.interactWithMethodName = BattlegearTranslator.getMapedMethodName("func_70998_m", "interactWith");
        this.interactWithMethodDesc = "(L" + this.entityClassName + ";)Z";
    }
}

