/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.integration.table.gui.component.area;

import elan.tweaks.common.gui.dto.VectorXY;
import elan.tweaks.common.gui.layout.hex.HexLayout;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.ResearchProcessPort;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.dto.AspectHex;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.layout.ParchmentHexMapLayout;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.textures.RuneTexture;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001fB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u0017J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/area/Runes;", "", "uiOrigin", "Lelan/tweaks/common/gui/dto/VectorXY;", "runeLimit", "", "hexLayout", "Lelan/tweaks/common/gui/layout/hex/HexLayout;", "Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/dto/AspectHex;", "research", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearchProcessPort;", "(Lelan/tweaks/common/gui/dto/VectorXY;ILelan/tweaks/common/gui/layout/hex/HexLayout;Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearchProcessPort;)V", "keysToRunes", "", "", "Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/area/Runes$Rune;", "clear", "", "decayRunes", "partialTicks", "", "forEach", "action", "Lkotlin/Function1;", "introduceRunes", "random", "Ljava/util/Random;", "obstructingExisting", "", "aspectHex", "update", "Rune", "ThaumcraftResearchTweaks"})
public final class Runes {
    @NotNull
    private final VectorXY uiOrigin;
    private final int runeLimit;
    @NotNull
    private final HexLayout<AspectHex> hexLayout;
    @NotNull
    private final ResearchProcessPort research;
    @NotNull
    private final Map<String, Rune> keysToRunes;

    public Runes(@NotNull VectorXY uiOrigin, int runeLimit, @NotNull HexLayout<AspectHex> hexLayout, @NotNull ResearchProcessPort research) {
        Intrinsics.checkNotNullParameter((Object)uiOrigin, (String)"uiOrigin");
        Intrinsics.checkNotNullParameter(hexLayout, (String)"hexLayout");
        Intrinsics.checkNotNullParameter((Object)research, (String)"research");
        this.uiOrigin = uiOrigin;
        this.runeLimit = runeLimit;
        this.hexLayout = hexLayout;
        this.research = research;
        boolean bl = false;
        this.keysToRunes = new LinkedHashMap();
    }

    public final void forEach(@NotNull Function1<? super Rune, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$forEach$iv = this.keysToRunes.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    public final void clear() {
        this.keysToRunes.clear();
    }

    public final void update(float partialTicks, @NotNull Random random2) {
        Intrinsics.checkNotNullParameter((Object)random2, (String)"random");
        this.introduceRunes(random2);
        this.decayRunes(partialTicks);
    }

    private final void introduceRunes(Random random2) {
        Map.Entry<String, ParchmentHexMapLayout.Hex> entry;
        if (this.research.missingNotes() || this.research.notesCorrupted()) {
            return;
        }
        if (this.keysToRunes.size() >= this.runeLimit) {
            return;
        }
        Map.Entry<String, ParchmentHexMapLayout.Hex> entry2 = entry = ParchmentHexMapLayout.INSTANCE.randomHex();
        boolean bl = false;
        String key = entry2.getKey();
        Map.Entry<String, ParchmentHexMapLayout.Hex> entry3 = entry;
        boolean bl2 = false;
        ParchmentHexMapLayout.Hex hex = entry3.getValue();
        if (this.keysToRunes.containsKey(key)) {
            return;
        }
        AspectHex aspectHex = (AspectHex)this.hexLayout.get(hex.getCenter().plus(this.uiOrigin));
        if (this.obstructingExisting(aspectHex)) {
            return;
        }
        Rune rune = new Rune(hex.getOrigin().plus(this.uiOrigin).plus(RuneTexture.Companion.getOffsetToFitInHexCenter()), 200.0f + (float)random2.nextInt(700));
        Runes runes = this;
        Map<String, Rune> map = runes.keysToRunes;
        Pair pair = TuplesKt.to((Object)key, (Object)rune);
        boolean bl3 = false;
        map.put((String)pair.getFirst(), (Rune)pair.getSecond());
    }

    private final boolean obstructingExisting(AspectHex aspectHex) {
        return this.research.incomplete() && aspectHex != null || !this.research.incomplete() && aspectHex instanceof AspectHex.Occupied;
    }

    private final void decayRunes(float partialTicks) {
        Map<String, Rune> $this$onEach$iv = this.keysToRunes;
        boolean $i$f$onEach = false;
        Object object = $this$onEach$iv;
        boolean bl = false;
        boolean bl2 = false;
        Map<String, Rune> $this$apply$iv = object;
        boolean bl3 = false;
        Map<String, Rune> map = $this$apply$iv;
        boolean bl4 = false;
        Iterator<Map.Entry<String, Rune>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Rune> element$iv;
            Map.Entry<String, Rune> $dstr$_u24__u24$rune = element$iv = iterator.next();
            boolean bl5 = false;
            Map.Entry<String, Rune> entry = $dstr$_u24__u24$rune;
            boolean bl6 = false;
            Rune rune = entry.getValue();
            rune.decay(partialTicks);
        }
        Map<String, Rune> $this$filterValues$iv = object;
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, Rune> result$iv = new LinkedHashMap<String, Rune>();
        Map<String, Rune> map2 = $this$filterValues$iv;
        bl2 = false;
        for (Map.Entry<String, Rune> entry$iv : map2.entrySet()) {
            Rune p0 = entry$iv.getValue();
            boolean bl7 = false;
            if (!p0.getDecayed()) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map decayedRunes = result$iv;
        Runes runes = this;
        Map<String, Rune> map3 = runes.keysToRunes;
        object = decayedRunes.keySet();
        boolean bl8 = false;
        CollectionsKt.removeAll((Collection)map3.keySet(), (Iterable)object);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005J\u0013\u0010 \u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\t\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/area/Runes$Rune;", "", "uiOrigin", "Lelan/tweaks/common/gui/dto/VectorXY;", "totalLifetime", "", "(Lelan/tweaks/common/gui/dto/VectorXY;F)V", "alpha", "getAlpha", "()F", "decayProgress", "getDecayProgress", "decayed", "", "getDecayed", "()Z", "texture", "Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/textures/RuneTexture;", "getTexture", "()Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/textures/RuneTexture;", "timeToDecayTicks", "getTotalLifetime", "setTotalLifetime", "(F)V", "getUiOrigin", "()Lelan/tweaks/common/gui/dto/VectorXY;", "component1", "component2", "copy", "decay", "", "ticks", "equals", "other", "hashCode", "", "toString", "", "ThaumcraftResearchTweaks"})
    public static final class Rune {
        @NotNull
        private final VectorXY uiOrigin;
        private float totalLifetime;
        @NotNull
        private final RuneTexture texture;
        private float timeToDecayTicks;

        public Rune(@NotNull VectorXY uiOrigin, float totalLifetime) {
            Intrinsics.checkNotNullParameter((Object)uiOrigin, (String)"uiOrigin");
            this.uiOrigin = uiOrigin;
            this.totalLifetime = totalLifetime;
            this.texture = RuneTexture.Companion.random();
            this.timeToDecayTicks = this.totalLifetime;
        }

        @NotNull
        public final VectorXY getUiOrigin() {
            return this.uiOrigin;
        }

        public final float getTotalLifetime() {
            return this.totalLifetime;
        }

        public final void setTotalLifetime(float f) {
            this.totalLifetime = f;
        }

        @NotNull
        public final RuneTexture getTexture() {
            return this.texture;
        }

        public final float getAlpha() {
            return 0.66f * (this.getDecayProgress() < 0.25f ? this.getDecayProgress() * 2.0f : (this.getDecayProgress() > 0.5f ? 1.0f - this.getDecayProgress() : 0.5f));
        }

        public final boolean getDecayed() {
            return this.timeToDecayTicks <= 0.0f;
        }

        private final float getDecayProgress() {
            return this.timeToDecayTicks / this.totalLifetime;
        }

        public final void decay(float ticks) {
            Rune rune = this;
            rune.timeToDecayTicks -= ticks;
        }

        @NotNull
        public final VectorXY component1() {
            return this.uiOrigin;
        }

        public final float component2() {
            return this.totalLifetime;
        }

        @NotNull
        public final Rune copy(@NotNull VectorXY uiOrigin, float totalLifetime) {
            Intrinsics.checkNotNullParameter((Object)uiOrigin, (String)"uiOrigin");
            return new Rune(uiOrigin, totalLifetime);
        }

        public static /* synthetic */ Rune copy$default(Rune rune, VectorXY vectorXY, float f, int n, Object object) {
            if ((n & 1) != 0) {
                vectorXY = rune.uiOrigin;
            }
            if ((n & 2) != 0) {
                f = rune.totalLifetime;
            }
            return rune.copy(vectorXY, f);
        }

        @NotNull
        public String toString() {
            return "Rune(uiOrigin=" + this.uiOrigin + ", totalLifetime=" + this.totalLifetime + ')';
        }

        public int hashCode() {
            int result = this.uiOrigin.hashCode();
            result = result * 31 + Float.hashCode(this.totalLifetime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rune)) {
                return false;
            }
            Rune rune = (Rune)other;
            if (!Intrinsics.areEqual((Object)this.uiOrigin, (Object)rune.uiOrigin)) {
                return false;
            }
            return Intrinsics.areEqual((Object)Float.valueOf(this.totalLifetime), (Object)Float.valueOf(rune.totalLifetime));
        }
    }
}

