/*
 * Decompiled with CFR 0.152.
 */
package witchinggadgets.common.util.handler;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import witchinggadgets.common.util.handler.Log;

public class BaublesUtil {
    private static final BaublesUtil instance = new BaublesUtil();
    private static final boolean baublesLoaded = Loader.isModLoaded((String)"Baubles");
    private static boolean failedDirectAccess = false;

    private BaublesUtil() {
    }

    public static BaublesUtil instance() {
        return instance;
    }

    public boolean hasBaubles() {
        return baublesLoaded;
    }

    public IInventory getBaubles(EntityPlayer player) {
        return this.hasBaubles() ? this.getBaublesInvUnsafe(player) : null;
    }

    private IInventory getBaublesInvUnsafe(EntityPlayer player) {
        return BaublesApi.getBaubles((EntityPlayer)player);
    }

    public void disableCallbacks(IInventory baubles, boolean b) {
        if (!failedDirectAccess) {
            try {
                Class<?> inventoryBaubles = Class.forName("baubles.common.container.InventoryBaubles");
                Field blockEvents = inventoryBaubles.getDeclaredField("blockEvents");
                blockEvents.set(baubles, b);
            }
            catch (Throwable t) {
                Log.info("Failed to access Baubles internals: " + t);
                failedDirectAccess = true;
            }
        }
    }

    public static enum WhoAmI {
        SPCLIENT,
        MPCLIENT,
        SPSERVER,
        MPSERVER,
        OTHER;


        public static WhoAmI whoAmI(World world) {
            Side side = FMLCommonHandler.instance().getSide();
            if (side == Side.CLIENT) {
                if (Minecraft.func_71410_x().func_71387_A()) {
                    if (world.field_72995_K) {
                        return SPCLIENT;
                    }
                    return SPSERVER;
                }
                return MPCLIENT;
            }
            if (side == Side.SERVER) {
                if (MinecraftServer.func_71276_C().func_71262_S()) {
                    return MPSERVER;
                }
                if (Minecraft.func_71410_x().func_71387_A()) {
                    return SPSERVER;
                }
            }
            return OTHER;
        }
    }
}

