/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.botania.commands;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.ICommandFunction;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StringHelper;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipePetals;

public class BotaniaLogger
implements ICommandFunction {
    private static final List<String> validArguments = new LinkedList<String>();

    public void execute(String[] arguments, IPlayer player) {
        List<String> args = StringHelper.toLowerCase(Arrays.asList(arguments));
        if (!validArguments.containsAll(args)) {
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("Invalid arguments for command. Valid arguments: " + StringHelper.join(validArguments, ", ")));
            }
        } else {
            if (args.isEmpty() || args.contains("Apothecary")) {
                for (RecipePetals recipe : BotaniaAPI.petalRecipes) {
                    MineTweakerAPI.logCommand((String)String.format("mods.botania.Apothecary.addRecipe(%s, %s);", LogHelper.getStackDescription(recipe.getOutput()), LogHelper.getListDescription(recipe.getInputs())));
                }
            }
            if (args.isEmpty() || args.contains("Brew")) {
                for (RecipePetals recipe : BotaniaAPI.brewRecipes) {
                    MineTweakerAPI.logCommand((String)String.format("mods.botania.Brew.addRecipe(%s, \"%s\");", LogHelper.getListDescription(recipe.getInputs()), recipe.getBrew().getKey()));
                }
            }
            if (args.isEmpty() || args.contains("ElvenTrade")) {
                for (RecipePetals recipe : BotaniaAPI.elvenTradeRecipes) {
                    MineTweakerAPI.logCommand((String)String.format("mods.botania.ElvenTrade.addRecipe(%s, %s);", LogHelper.getStackDescription(recipe.getOutput()), LogHelper.getListDescription(recipe.getInputs())));
                }
            }
            if (args.isEmpty() || args.contains("ManaInfusion")) {
                for (RecipePetals recipe : BotaniaAPI.manaInfusionRecipes) {
                    MineTweakerAPI.logCommand((String)String.format("mods.botania.ManaInfusion.add%s(%s, %s, %d);", recipe.isAlchemy() ? "Alchemy" : (recipe.isConjuration() ? "Conjuration" : "Infusion"), LogHelper.getStackDescription(recipe.getOutput()), LogHelper.getStackDescription(recipe.getInput()), recipe.getManaToConsume()));
                }
            }
            if (args.isEmpty() || args.contains("PureDaisy")) {
                for (RecipePetals recipe : BotaniaAPI.pureDaisyRecipes) {
                    MineTweakerAPI.logCommand((String)String.format("mods.botania.PureDaisy.addRecipe(%s, %s);", LogHelper.getStackDescription(recipe.getInput()), LogHelper.getStackDescription(new ItemStack(recipe.getOutput(), 1, recipe.getOutputMeta()))));
                }
            }
            if (args.isEmpty() || args.contains("RuneAltar")) {
                for (RecipePetals recipe : BotaniaAPI.runeAltarRecipes) {
                    MineTweakerAPI.logCommand((String)String.format("mods.botania.RuneAltar.addRecipe(%s, %s, %d);", LogHelper.getStackDescription(recipe.getOutput()), LogHelper.getListDescription(recipe.getInputs()), recipe.getManaUsage()));
                }
            }
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("List generated; see minetweaker.log in your minecraft dir"));
            }
        }
    }

    static {
        validArguments.add("Apothecary");
        validArguments.add("Brew");
        validArguments.add("ElvenTrade");
        validArguments.add("ManaInfusion");
        validArguments.add("PureDaisy");
        validArguments.add("RuneAltar");
    }
}

