/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.galacticgreg.registry;

import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.api.Enums;
import bloodasp.galacticgreg.api.ModContainer;
import bloodasp.galacticgreg.api.ModDimensionDef;
import bloodasp.galacticgreg.dynconfig.DynamicDimensionConfig;
import bloodasp.galacticgreg.generators.GenEllipsoid;
import cpw.mods.fml.common.Loader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.chunk.IChunkProvider;

public class GalacticGregRegistry {
    private static final Map<String, ModContainer> _mModContainers = new HashMap<String, ModContainer>();
    public static final String DIM_UNKNOWN = "GGREG_DIMENSION_UNKNOWN";
    private static boolean _mInitializationDone = false;

    public static boolean registerModContainer(ModContainer pModContainer) {
        if (_mInitializationDone) {
            GalacticGreg.Logger.warn("Initialization is already done, you can't add more ModContainers!", new Object[0]);
            return false;
        }
        if (_mModContainers.containsKey(pModContainer.getModName())) {
            GalacticGreg.Logger.warn("There is already a mod registered with that name: [%s]", pModContainer.getModName());
            return false;
        }
        GalacticGreg.Logger.info("Registered new mod to generate ores: [%s] Dimensions provided: [%d]", pModContainer.getModName(), pModContainer.getDimensionList().size());
        _mModContainers.put(pModContainer.getModName(), pModContainer);
        return true;
    }

    public static ModDimensionDef getDimensionTypeByChunkGenerator(IChunkProvider pChunkProvider) {
        try {
            if (!_mInitializationDone) {
                return null;
            }
            String tFQCPN = pChunkProvider.toString().split("@")[0];
            ModDimensionDef tReturnMDD = null;
            block2: for (ModContainer mc : _mModContainers.values()) {
                for (ModDimensionDef mdd : mc.getDimensionList()) {
                    if (!mdd.getChunkProviderName().equals(tFQCPN)) continue;
                    tReturnMDD = mdd;
                    continue block2;
                }
            }
            return tReturnMDD;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Collection<ModContainer> getModContainers() {
        if (!_mInitializationDone) {
            return null;
        }
        return _mModContainers.values();
    }

    public static boolean InitRegistry() {
        if (_mInitializationDone) {
            return false;
        }
        GalacticGregRegistry.InitModContainers();
        DynamicDimensionConfig.InitDynamicConfig();
        return true;
    }

    private static void InitModContainers() {
        for (ModContainer mc : _mModContainers.values()) {
            if (!Loader.isModLoaded((String)mc.getModName()) && !mc.getModName().equalsIgnoreCase("vanilla")) {
                GalacticGreg.Logger.warn("Ignoring ModRegistration for OreGen: [%s], because mod is not loaded. Did you misspell the name?", mc.getModName());
                mc.setEnabled(false);
                continue;
            }
            GalacticGreg.Logger.info("Mod [%s] is now enabled for OreGen by GalacticGreg", mc.getModName());
            mc.setEnabled(true);
            for (ModDimensionDef md : mc.getDimensionList()) {
                GalacticGreg.Logger.info("ModID: [%s] DimName: [%s] ValidBlocks: [%d] Identifier: [%s] Generators: [%d]", mc.getModName(), md.getDimensionName(), md.getReplaceableBlocks().size(), md.getDimIdentifier(), md.getSpaceObjectGenerators().size());
                if (md.getDimensionType() == Enums.DimensionType.AsteroidAndPlanet || md.getDimensionType() == Enums.DimensionType.Asteroid) {
                    if (md.getSpaceObjectGenerators().size() == 0) {
                        GalacticGreg.Logger.debug("No generators found, adding build-in ellipsoid generator", new Object[0]);
                        md.registerSpaceObjectGenerator(new GenEllipsoid());
                    }
                    GalacticGreg.Logger.info("Asteroid-Enabled dimension. Registered Generators: [%d]", md.getSpaceObjectGenerators().size());
                }
                md.finalizeReplaceableBlocks(mc.getModName());
            }
        }
        _mInitializationDone = true;
    }

    public static ModContainer getModContainerForDimension(ModDimensionDef pDimensionDefinition) {
        if (!_mInitializationDone) {
            return null;
        }
        try {
            for (ModContainer mc : _mModContainers.values()) {
                for (ModDimensionDef md : mc.getDimensionList()) {
                    if (!pDimensionDefinition.getDimIdentifier().equals(md.getDimIdentifier())) continue;
                    return mc;
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

