/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.TileEntities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Containers.ContainerBase;
import vswe.stevescarts.Containers.ContainerCargo;
import vswe.stevescarts.Containers.ContainerManager;
import vswe.stevescarts.Helpers.CargoItemSelection;
import vswe.stevescarts.Helpers.ComponentTypes;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ManagerTransfer;
import vswe.stevescarts.Helpers.TransferHandler;
import vswe.stevescarts.Interfaces.GuiBase;
import vswe.stevescarts.Interfaces.GuiCargo;
import vswe.stevescarts.Items.ModItems;
import vswe.stevescarts.Slots.ISlotExplosions;
import vswe.stevescarts.Slots.SlotArrow;
import vswe.stevescarts.Slots.SlotBridge;
import vswe.stevescarts.Slots.SlotBuilder;
import vswe.stevescarts.Slots.SlotCake;
import vswe.stevescarts.Slots.SlotCargo;
import vswe.stevescarts.Slots.SlotChest;
import vswe.stevescarts.Slots.SlotFertilizer;
import vswe.stevescarts.Slots.SlotFirework;
import vswe.stevescarts.Slots.SlotFuel;
import vswe.stevescarts.Slots.SlotMilker;
import vswe.stevescarts.Slots.SlotSapling;
import vswe.stevescarts.Slots.SlotSeed;
import vswe.stevescarts.Slots.SlotTorch;
import vswe.stevescarts.TileEntities.TileEntityManager;

public class TileEntityCargo
extends TileEntityManager {
    public static ArrayList<CargoItemSelection> itemSelections;
    public int[] target = new int[]{0, 0, 0, 0};
    public ArrayList<SlotCargo> cargoSlots;
    public int lastLayout = -1;
    private ManagerTransfer latestTransferToBeUsed;

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiCargo(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerCargo((IInventory)inv, this);
    }

    public static void loadSelectionSettings() {
        itemSelections = new ArrayList();
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_ALL, Slot.class, new ItemStack((Item)ModItems.carts, 1, 0)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_ENGINE, SlotFuel.class, new ItemStack((Item)ModItems.modules, 1, 0)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_RAILER, SlotBuilder.class, new ItemStack((Item)ModItems.modules, 1, 10)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_STORAGE, SlotChest.class, new ItemStack((Block)Blocks.field_150486_ae, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_TORCHES, SlotTorch.class, new ItemStack(Blocks.field_150478_aa, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_EXPLOSIVES, ISlotExplosions.class, ComponentTypes.DYNAMITE.getItemStack()));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_ARROWS, SlotArrow.class, new ItemStack(Items.field_151032_g, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_BRIDGE, SlotBridge.class, new ItemStack(Blocks.field_150336_V, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_SEEDS, SlotSeed.class, new ItemStack(Items.field_151014_N, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_FERTILIZER, SlotFertilizer.class, new ItemStack(Items.field_151100_aR, 1, 15)));
        itemSelections.add(new CargoItemSelection(null, null, null));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_SAPLINGS, SlotSapling.class, new ItemStack(Blocks.field_150345_g, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_FIREWORK, SlotFirework.class, new ItemStack(Items.field_151152_bP, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_BUCKETS, SlotMilker.class, new ItemStack(Items.field_151133_ar, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_CAKES, SlotCake.class, new ItemStack(Items.field_151105_aU, 1)));
    }

    public int func_70302_i_() {
        return 60;
    }

    @Override
    public String func_145825_b() {
        return "container.cargomanager";
    }

    @Override
    protected void updateLayout() {
        if (this.cargoSlots != null && this.lastLayout != this.layoutType) {
            for (SlotCargo slot : this.cargoSlots) {
                slot.updatePosition();
            }
            this.lastLayout = this.layoutType;
        }
    }

    @Override
    protected boolean isTargetValid(ManagerTransfer transfer) {
        return this.target[transfer.getSetting()] >= 0 && this.target[transfer.getSetting()] < itemSelections.size();
    }

    @Override
    protected void receiveClickData(int packetid, int id, int dif) {
        if (packetid == 1) {
            int n = id;
            this.target[n] = this.target[n] + dif;
            if (this.target[id] >= itemSelections.size()) {
                this.target[id] = 0;
            } else if (this.target[id] < 0) {
                this.target[id] = itemSelections.size() - 1;
            }
            if (this.color[id] - 1 == this.getSide()) {
                this.reset();
            }
            if (itemSelections.get(this.target[id]).getValidSlot() == null && dif != 0) {
                this.receiveClickData(packetid, id, dif);
            }
        }
    }

    @Override
    public void checkGuiData(ContainerManager conManager, ICrafting crafting, boolean isNew) {
        super.checkGuiData(conManager, crafting, isNew);
        ContainerCargo con = (ContainerCargo)conManager;
        short targetShort = 0;
        for (int i = 0; i < 4; ++i) {
            targetShort = (short)(targetShort | (this.target[i] & 0xF) << i * 4);
        }
        if (isNew || con.lastTarget != targetShort) {
            this.updateGuiData(con, crafting, 2, targetShort);
            con.lastTarget = targetShort;
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 2) {
            for (int i = 0; i < 4; ++i) {
                this.target[i] = (data & 15 << i * 4) >> i * 4;
            }
        } else {
            super.receiveGuiData(id, data);
        }
    }

    public int getAmount(int id) {
        int val = this.getAmountId(id);
        switch (val) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    public int getAmountType(int id) {
        int val = this.getAmountId(id);
        if (val == 0) {
            return 0;
        }
        if (val <= 6) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getAmountCount() {
        return 11;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.setWorkload(nbttagcompound.func_74771_c("workload"));
        for (int i = 0; i < 4; ++i) {
            this.target[i] = nbttagcompound.func_74771_c("target" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74774_a("workload", (byte)this.getWorkload());
        for (int i = 0; i < 4; ++i) {
            nbttagcompound.func_74774_a("target" + i, (byte)this.target[i]);
        }
    }

    @Override
    protected boolean doTransfer(ManagerTransfer transfer) {
        Class toValid;
        Container toCont;
        IInventory toInv;
        Class fromValid;
        ContainerCargo fromCont;
        IInventory fromInv;
        Class slotCart = itemSelections.get(this.target[transfer.getSetting()]).getValidSlot();
        if (slotCart == null) {
            transfer.setLowestSetting(transfer.getSetting() + 1);
            return true;
        }
        Class slotCargo = SlotCargo.class;
        if (this.toCart[transfer.getSetting()]) {
            fromInv = this;
            fromCont = new ContainerCargo(null, this);
            fromValid = slotCargo;
            toInv = transfer.getCart();
            toCont = transfer.getCart().getCon(null);
            toValid = slotCart;
        } else {
            fromInv = transfer.getCart();
            fromCont = transfer.getCart().getCon(null);
            fromValid = slotCart;
            toInv = this;
            toCont = new ContainerCargo(null, this);
            toValid = slotCargo;
        }
        this.latestTransferToBeUsed = transfer;
        for (int i = 0; i < fromInv.func_70302_i_(); ++i) {
            if (!TransferHandler.isSlotOfType(fromCont.func_75139_a(i), fromValid) || fromInv.func_70301_a(i) == null) continue;
            ItemStack iStack = fromInv.func_70301_a(i);
            int stacksize = iStack.field_77994_a;
            int maxNumber = this.getAmountType(transfer.getSetting()) == 1 ? this.getAmount(transfer.getSetting()) - transfer.getWorkload() : -1;
            TransferHandler.TransferItem(iStack, toInv, toCont, toValid, maxNumber, TransferHandler.TRANSFER_TYPE.MANAGER);
            if (iStack.field_77994_a == stacksize) continue;
            if (this.getAmountType(transfer.getSetting()) == 1) {
                transfer.setWorkload(transfer.getWorkload() + stacksize - iStack.field_77994_a);
            } else if (this.getAmountType(transfer.getSetting()) == 2) {
                transfer.setWorkload(transfer.getWorkload() + 1);
            }
            this.func_70296_d();
            transfer.getCart().func_70296_d();
            if (iStack.field_77994_a == 0) {
                fromInv.func_70299_a(i, null);
            }
            if (transfer.getWorkload() >= this.getAmount(transfer.getSetting()) && this.getAmountType(transfer.getSetting()) != 0) {
                transfer.setLowestSetting(transfer.getSetting() + 1);
            }
            return true;
        }
        return false;
    }

    public boolean func_94041_b(int slotId, ItemStack item) {
        return true;
    }

    public ManagerTransfer getCurrentTransferForSlots() {
        return this.latestTransferToBeUsed;
    }
}

