/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.CookingConfig;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.api.kitchen.IKitchenItemProvider;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSink
extends TileEntity
implements IKitchenItemProvider,
IFluidHandler {
    protected int color;
    private final List<ItemStack> itemStacks = new ArrayList<ItemStack>();
    private final FluidTank waterTank = new WaterTank(16000);
    private int craftingBuffer;

    public TileSink() {
        this.itemStacks.add(new ItemStack(Items.field_151131_as));
        ItemStack pamsWater = GameRegistry.findItemStack((String)"harvestcraft", (String)"freshwaterItem", (int)1);
        if (pamsWater != null) {
            this.itemStacks.add(pamsWater);
        }
    }

    @Override
    public List<ItemStack> getProvidedItemStacks() {
        return this.itemStacks;
    }

    @Override
    public boolean addToCraftingBuffer(ItemStack itemStack) {
        if (!CookingConfig.sinkRequiresWater) {
            return true;
        }
        if (this.waterTank.getFluidAmount() < 1000) {
            return false;
        }
        this.craftingBuffer += 1000;
        return true;
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.waterTank.setFluid(new FluidStack(FluidRegistry.WATER, value));
            return true;
        }
        return false;
    }

    @Override
    public void clearCraftingBuffer() {
        this.craftingBuffer = 0;
    }

    @Override
    public void craftingComplete() {
        this.drain(ForgeDirection.UNKNOWN, this.craftingBuffer, true);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74774_a("Color", (byte)this.color);
        this.waterTank.writeToNBT(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.color = tagCompound.func_74771_c("Color");
        this.waterTank.readFromNBT(tagCompound);
    }

    public int getWaterAmount() {
        return this.waterTank.getFluidAmount();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int result = this.waterTank.fill(resource, doFill);
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, CookingForBlockheads.blockSink, 1, this.waterTank.getFluidAmount());
        return result;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack result = this.waterTank.drain(maxDrain, doDrain);
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, CookingForBlockheads.blockSink, 1, this.waterTank.getFluidAmount());
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return CookingConfig.sinkRequiresWater && fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return CookingConfig.sinkRequiresWater && fluid == FluidRegistry.WATER;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.waterTank.getInfo()};
    }

    public void setColor(int color) {
        this.color = color;
        this.func_70296_d();
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 2, color);
    }

    public int getColor() {
        return this.color;
    }

    private static class WaterTank
    extends FluidTank {
        public WaterTank(int capacity) {
            super(capacity);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource.getFluid() != FluidRegistry.WATER) {
                return 0;
            }
            return super.fill(resource, doFill);
        }
    }
}

