/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.loader;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;

public class RecipeResourceCopier {
    private static final int INITIAL_RESOURCE_CAPACITY = 20;
    private static final Pattern DOT_COMPILE_PATTERN = Pattern.compile(".", 16);
    private static final String FILE_PROTOCOL = "file";
    private static final String CLASS_EXTENSION = ".class";
    private static final String JAR_PROTOCOL = "jar";
    private static final String UTF_8_ENCODING = "UTF-8";
    private final String root;

    public RecipeResourceCopier(@Nonnull String root) {
        Preconditions.checkNotNull((Object)root);
        this.root = root;
    }

    public void copyTo(@Nonnull String identifier, @Nonnull File destination) throws URISyntaxException, IOException {
        Preconditions.checkNotNull((Object)destination);
        Preconditions.checkArgument((boolean)destination.isDirectory());
        this.copyTo(identifier, destination, this.root);
    }

    private void copyTo(@Nonnull String identifier, @Nonnull File destination, @Nonnull String directory) throws URISyntaxException, IOException {
        String[] listing;
        assert (identifier != null);
        assert (destination != null);
        assert (directory != null);
        Class<?> copierClass = this.getClass();
        for (String list : listing = this.getResourceListing(copierClass, directory)) {
            if (list.endsWith(identifier)) {
                FileUtils.forceMkdir((File)destination);
                this.copyFile(destination, directory, list);
                continue;
            }
            if (list.contains(".")) continue;
            File subDirectory = new File(destination, list);
            this.copyTo(identifier, subDirectory, directory + list + "/");
        }
    }

    private void copyFile(@Nonnull File destination, @Nonnull String directory, @Nonnull String fileName) throws IOException {
        assert (destination != null);
        assert (directory != null);
        assert (fileName != null);
        Class<?> copierClass = this.getClass();
        InputStream inStream = copierClass.getResourceAsStream('/' + directory + fileName);
        File outFile = new File(destination, fileName);
        if (!outFile.exists() && inStream != null) {
            FileUtils.copyInputStreamToFile((InputStream)inStream, (File)outFile);
            inStream.close();
        }
    }

    @Nonnull
    private String[] getResourceListing(@Nonnull Class<?> clazz, @Nonnull String path) throws URISyntaxException, IOException {
        String protocol;
        assert (clazz != null);
        assert (path != null);
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("ClassLoader was not found. It was probably loaded at a inappropriate time");
        }
        URL dirURL = classLoader.getResource(path);
        if (dirURL != null && (protocol = dirURL.getProtocol()).equals(FILE_PROTOCOL)) {
            URI uriOfURL = dirURL.toURI();
            File fileOfURI = new File(uriOfURL);
            String[] filesAndDirectoriesOfURI = fileOfURI.list();
            if (filesAndDirectoriesOfURI == null) {
                throw new IllegalStateException("Files and Directories were illegal. Either an abstract pathname does not denote a directory, or an I/O error occured.");
            }
            return filesAndDirectoriesOfURI;
        }
        if (dirURL == null) {
            String className = clazz.getName();
            Matcher matcher = DOT_COMPILE_PATTERN.matcher(className);
            String me = matcher.replaceAll("/") + CLASS_EXTENSION;
            dirURL = classLoader.getResource(me);
        }
        if (dirURL != null && (protocol = dirURL.getProtocol()).equals(JAR_PROTOCOL)) {
            String dirPath = dirURL.getPath();
            String jarPath = dirPath.substring(5, dirPath.indexOf(33));
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, UTF_8_ENCODING));){
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>(20);
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryFullName = entry.getName();
                    if (!entryFullName.startsWith(path)) continue;
                    String entryName = entryFullName.substring(path.length());
                    int checkSubDir = entryName.indexOf(47);
                    if (checkSubDir >= 0) {
                        entryName = entryName.substring(0, checkSubDir);
                    }
                    result.add(entryName);
                }
                String[] stringArray = result.toArray(new String[result.size()]);
                return stringArray;
            }
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }
}

