/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketNEIBookmark
extends AppEngPacket {
    private ItemStack bookmarkItem;

    public PacketNEIBookmark(ByteBuf stream) throws IOException {
        ByteArrayInputStream bytes = new ByteArrayInputStream(stream.array());
        bytes.skip(stream.readerIndex());
        NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)bytes);
        if (comp != null) {
            this.bookmarkItem = ItemStack.func_77949_a((NBTTagCompound)comp);
        }
    }

    public PacketNEIBookmark(NBTTagCompound bookmarkItemComp) throws IOException {
        ByteBuf data = Unpooled.buffer();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bytes);
        data.writeInt(this.getPacketID());
        CompressedStreamTools.func_74799_a((NBTTagCompound)bookmarkItemComp, (OutputStream)outputStream);
        data.writeBytes(bytes.toByteArray());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ContainerMEMonitorable monitorable;
        IMEMonitor<IAEItemStack> monitor;
        this.bookmarkItem.field_77994_a = this.fitStack(player, this.bookmarkItem);
        EntityPlayerMP pmp = (EntityPlayerMP)player;
        Container con = pmp.field_71070_bA;
        if (con instanceof ContainerMEMonitorable && (monitor = (monitorable = (ContainerMEMonitorable)con).getMonitor()) != null) {
            IEnergySource energy = monitorable.getPowerSource();
            BaseActionSource actionSource = monitorable.getActionSource();
            AEItemStack request = AEItemStack.create(this.bookmarkItem);
            IAEItemStack out = Platform.poweredExtraction(energy, monitor, request, actionSource);
            if (out != null) {
                InventoryAdaptor adp = InventoryAdaptor.getAdaptor(player, ForgeDirection.UNKNOWN);
                ItemStack outItem = out.getItemStack();
                adp.addItems(outItem);
            }
        }
    }

    private int fitStack(EntityPlayer player, ItemStack itemStack) {
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        int remainingStackSize = itemStack.field_77994_a;
        for (ItemStack slotStack : inv) {
            if (slotStack == null) {
                return itemStack.field_77994_a;
            }
            if (!slotStack.func_77969_a(itemStack) || (remainingStackSize -= itemStack.func_77976_d() - slotStack.field_77994_a) >= 0) continue;
            return itemStack.field_77994_a;
        }
        if (remainingStackSize == itemStack.func_77976_d()) {
            return 0;
        }
        return itemStack.field_77994_a - remainingStackSize;
    }
}

