/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.legacylootgames.gol.tiles;

import eu.usrv.legacylootgames.auxiliary.ExtendedDirections;
import eu.usrv.legacylootgames.blocks.DungeonBrick;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import ru.timeconqueror.lootgames.LegacyMigrator;
import ru.timeconqueror.lootgames.registry.LGBlocks;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.WorldExt;

public class LegacyGameOfLightTile
extends TileEntity {
    private static final String NBTTAG_ISACTIVE = "mIsActive";
    private static final String NBTTAG_ISMASTER = "mIsMaster";
    private static final String NBTTAG_DIRECTION = "mTEDirection";
    private static final String NBTTAG_BLOCK_NORTH = "mGameBlockNorth";
    private static final String NBTTAG_BLOCK_SOUTH = "mGameBlockSouth";
    private static final String NBTTAG_BLOCK_WEST = "mGameBlockEast";
    private static final String NBTTAG_BLOCK_EAST = "mGameBlockWest";
    private static final String NBTTAG_BLOCK_NW = "mGameBlockNW";
    private static final String NBTTAG_BLOCK_NE = "mGameBlockNE";
    private static final String NBTTAG_BLOCK_SW = "mGameBlockSW";
    private static final String NBTTAG_BLOCK_SE = "mGameBlockSE";
    private static final String NBTTAG_BLOCK_MASTER = "mMasterBlock";
    private static final String NBTTAG_BLOCKPOS_X = "posX";
    private static final String NBTTAG_BLOCKPOS_Y = "posY";
    private static final String NBTTAG_BLOCKPOS_Z = "posZ";
    private Vec3 mNorthPos;
    private Vec3 mSouthPos;
    private Vec3 mWestPos;
    private Vec3 mEastPos;
    private Vec3 mNorthWestPos;
    private Vec3 mNorthEastPos;
    private Vec3 mSouthWestPos;
    private Vec3 mSouthEastPos;
    private Vec3 mMasterPos;
    private LegacyGameOfLightTile _mGameBlockNorth;
    private LegacyGameOfLightTile _mGameBlockWest;
    private LegacyGameOfLightTile _mGameBlockSouth;
    private LegacyGameOfLightTile _mGameBlockEast;
    private LegacyGameOfLightTile _mGameBlockNE;
    private LegacyGameOfLightTile _mGameBlockNW;
    private LegacyGameOfLightTile _mGameBlockSE;
    private LegacyGameOfLightTile _mGameBlockSW;
    private LegacyGameOfLightTile _mMasterTE;
    private ExtendedDirections mTEDirection = ExtendedDirections.UP;
    private boolean mIsMaster;
    private boolean mIsActive;

    public boolean getIsActive() {
        return this.mIsActive;
    }

    public ExtendedDirections getDirection() {
        return this.mTEDirection;
    }

    private LegacyGameOfLightTile getBlockNorth() {
        if (this._mGameBlockNorth == null && this.mNorthPos != null) {
            this._mGameBlockNorth = (LegacyGameOfLightTile)this.field_145850_b.func_147438_o((int)this.mNorthPos.field_72450_a, (int)this.mNorthPos.field_72448_b, (int)this.mNorthPos.field_72449_c);
        }
        return this._mGameBlockNorth;
    }

    private LegacyGameOfLightTile getBlockWest() {
        if (this._mGameBlockWest == null && this.mWestPos != null) {
            this._mGameBlockWest = (LegacyGameOfLightTile)this.field_145850_b.func_147438_o((int)this.mWestPos.field_72450_a, (int)this.mWestPos.field_72448_b, (int)this.mWestPos.field_72449_c);
        }
        return this._mGameBlockWest;
    }

    private LegacyGameOfLightTile getBlockSouth() {
        if (this._mGameBlockSouth == null && this.mSouthPos != null) {
            this._mGameBlockSouth = (LegacyGameOfLightTile)this.field_145850_b.func_147438_o((int)this.mSouthPos.field_72450_a, (int)this.mSouthPos.field_72448_b, (int)this.mSouthPos.field_72449_c);
        }
        return this._mGameBlockSouth;
    }

    private LegacyGameOfLightTile getBlockEast() {
        if (this._mGameBlockEast == null && this.mEastPos != null) {
            this._mGameBlockEast = (LegacyGameOfLightTile)this.field_145850_b.func_147438_o((int)this.mEastPos.field_72450_a, (int)this.mEastPos.field_72448_b, (int)this.mEastPos.field_72449_c);
        }
        return this._mGameBlockEast;
    }

    private LegacyGameOfLightTile getBlockMaster() {
        if (this._mMasterTE == null && this.mMasterPos != null) {
            this._mMasterTE = (LegacyGameOfLightTile)this.field_145850_b.func_147438_o((int)this.mMasterPos.field_72450_a, (int)this.mMasterPos.field_72448_b, (int)this.mMasterPos.field_72449_c);
        }
        return this._mMasterTE;
    }

    private LegacyGameOfLightTile getBlockNW() {
        if (this._mGameBlockNW == null && this.mNorthWestPos != null) {
            this._mGameBlockNW = (LegacyGameOfLightTile)this.field_145850_b.func_147438_o((int)this.mNorthWestPos.field_72450_a, (int)this.mNorthWestPos.field_72448_b, (int)this.mNorthWestPos.field_72449_c);
        }
        return this._mGameBlockNW;
    }

    private LegacyGameOfLightTile getBlockNE() {
        if (this._mGameBlockNE == null && this.mNorthEastPos != null) {
            this._mGameBlockNE = (LegacyGameOfLightTile)this.field_145850_b.func_147438_o((int)this.mNorthEastPos.field_72450_a, (int)this.mNorthEastPos.field_72448_b, (int)this.mNorthEastPos.field_72449_c);
        }
        return this._mGameBlockNE;
    }

    private LegacyGameOfLightTile getBlockSW() {
        if (this._mGameBlockSW == null && this.mSouthWestPos != null) {
            this._mGameBlockSW = (LegacyGameOfLightTile)this.field_145850_b.func_147438_o((int)this.mSouthWestPos.field_72450_a, (int)this.mSouthWestPos.field_72448_b, (int)this.mSouthWestPos.field_72449_c);
        }
        return this._mGameBlockSW;
    }

    private LegacyGameOfLightTile getBlockSE() {
        if (this._mGameBlockSE == null && this.mSouthEastPos != null) {
            this._mGameBlockSE = (LegacyGameOfLightTile)this.field_145850_b.func_147438_o((int)this.mSouthEastPos.field_72450_a, (int)this.mSouthEastPos.field_72448_b, (int)this.mSouthEastPos.field_72449_c);
        }
        return this._mGameBlockSE;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private Vec3 readGameBlockFromNBT(NBTTagCompound pTag, String tTagName) {
        NBTTagCompound tSubTag = pTag.func_74775_l(tTagName);
        int x = tSubTag.func_74762_e(NBTTAG_BLOCKPOS_X);
        int y = tSubTag.func_74762_e(NBTTAG_BLOCKPOS_Y);
        int z = tSubTag.func_74762_e(NBTTAG_BLOCKPOS_Z);
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    private void addGameBlockToNBT(LegacyGameOfLightTile pTargetObject, NBTTagCompound pTag, String tTagName) {
        NBTTagCompound tSubTag = new NBTTagCompound();
        tSubTag.func_74768_a(NBTTAG_BLOCKPOS_X, pTargetObject.field_145851_c);
        tSubTag.func_74768_a(NBTTAG_BLOCKPOS_Y, pTargetObject.field_145848_d);
        tSubTag.func_74768_a(NBTTAG_BLOCKPOS_Z, pTargetObject.field_145849_e);
        pTag.func_74782_a(tTagName, (NBTBase)tSubTag);
    }

    public void func_145839_a(NBTTagCompound pNBTTagCompound) {
        super.func_145839_a(pNBTTagCompound);
        this.mIsMaster = pNBTTagCompound.func_74767_n(NBTTAG_ISMASTER);
        this.mIsActive = pNBTTagCompound.func_74767_n(NBTTAG_ISACTIVE);
        this.mTEDirection = ExtendedDirections.VALID_DIRECTIONS[pNBTTagCompound.func_74762_e(NBTTAG_DIRECTION)];
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_NORTH)) {
            this.mNorthPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_NORTH);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_SOUTH)) {
            this.mSouthPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_SOUTH);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_WEST)) {
            this.mWestPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_WEST);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_EAST)) {
            this.mEastPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_EAST);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_NE)) {
            this.mNorthEastPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_NE);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_NW)) {
            this.mNorthWestPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_NW);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_SW)) {
            this.mSouthWestPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_SW);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_SE)) {
            this.mSouthEastPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_SE);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_MASTER)) {
            this.mMasterPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_MASTER);
        }
    }

    public void func_145841_b(NBTTagCompound pNBTTagCompound) {
        super.func_145841_b(pNBTTagCompound);
        pNBTTagCompound.func_74757_a(NBTTAG_ISMASTER, this.mIsMaster);
        pNBTTagCompound.func_74757_a(NBTTAG_ISACTIVE, this.mIsActive);
        pNBTTagCompound.func_74768_a(NBTTAG_DIRECTION, this.mTEDirection.ordinal());
        if (this.getBlockNorth() != null) {
            this.addGameBlockToNBT(this.getBlockNorth(), pNBTTagCompound, NBTTAG_BLOCK_NORTH);
        }
        if (this.getBlockSouth() != null) {
            this.addGameBlockToNBT(this.getBlockSouth(), pNBTTagCompound, NBTTAG_BLOCK_SOUTH);
        }
        if (this.getBlockWest() != null) {
            this.addGameBlockToNBT(this.getBlockWest(), pNBTTagCompound, NBTTAG_BLOCK_WEST);
        }
        if (this.getBlockEast() != null) {
            this.addGameBlockToNBT(this.getBlockEast(), pNBTTagCompound, NBTTAG_BLOCK_EAST);
        }
        if (this.getBlockNW() != null) {
            this.addGameBlockToNBT(this.getBlockNW(), pNBTTagCompound, NBTTAG_BLOCK_NW);
        }
        if (this.getBlockNE() != null) {
            this.addGameBlockToNBT(this.getBlockNE(), pNBTTagCompound, NBTTAG_BLOCK_NE);
        }
        if (this.getBlockSW() != null) {
            this.addGameBlockToNBT(this.getBlockSW(), pNBTTagCompound, NBTTAG_BLOCK_SW);
        }
        if (this.getBlockSE() != null) {
            this.addGameBlockToNBT(this.getBlockSE(), pNBTTagCompound, NBTTAG_BLOCK_SE);
        }
        if (this.getBlockMaster() != null) {
            this.addGameBlockToNBT(this.getBlockMaster(), pNBTTagCompound, NBTTAG_BLOCK_MASTER);
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ExtendedDirections direction = this.getDirection();
            BlockPos pos = BlockPos.of(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (ExtendedDirections.isHorizontal(direction)) {
                WorldExt.setBlock(this.field_145850_b, pos, LGBlocks.DUNGEON_WALL, DungeonBrick.Type.FLOOR_SHIELDED.ordinal(), 3);
            } else if (direction == ExtendedDirections.UP) {
                WorldExt.setBlock(this.field_145850_b, pos, LGBlocks.DUNGEON_WALL, DungeonBrick.Type.FLOOR_SHIELDED.ordinal(), 3);
                BlockPos puzzle = pos.offset(0, 2, 0);
                if (WorldExt.getBlock(this.field_145850_b, puzzle).isReplaceable((IBlockAccess)this.field_145850_b, puzzle.getX(), puzzle.getY(), puzzle.getZ())) {
                    LegacyMigrator.LOGGER.debug("Found old Game Of Light block on {}! Converting structure back to puzzle master!", new Object[]{pos});
                    WorldExt.setBlock(this.field_145850_b, puzzle, LGBlocks.PUZZLE_MASTER);
                } else {
                    LegacyMigrator.LOGGER.debug("Found old Game Of Light block on {}! But the position for puzzle master is obstructed, so I just delete this minigame block, sorry :c", new Object[]{pos});
                }
            }
        }
    }
}

