/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board;

class MyCastlingRights {
    private static final int WHITE_KINGSIDE = 1;
    private static final int WHITE_QUEENSIDE = 2;
    private static final int BLACK_KINGSIDE = 4;
    private static final int BLACK_QUEENSIDE = 8;
    private int castlingRights;

    public MyCastlingRights() {
        this.clear();
    }

    public MyCastlingRights(int castlingRights) {
        this.castlingRights = castlingRights;
    }

    public void setWhiteKingside() {
        this.castlingRights |= 1;
    }

    public void setWhiteQueenside() {
        this.castlingRights |= 2;
    }

    public void setBlackKingside() {
        this.castlingRights |= 4;
    }

    public void setBlackQueenside() {
        this.castlingRights |= 8;
    }

    public void removeWhiteKingside() {
        this.castlingRights &= 0xFFFFFFFE;
    }

    public void removeWhiteQueenside() {
        this.castlingRights &= 0xFFFFFFFD;
    }

    public void removeBlackKingside() {
        this.castlingRights &= 0xFFFFFFFB;
    }

    public void removeBlackQueenside() {
        this.castlingRights &= 0xFFFFFFF7;
    }

    public boolean isWhiteKingside() {
        return (this.castlingRights & 1) > 0;
    }

    public boolean isWhiteQueenside() {
        return (this.castlingRights & 2) > 0;
    }

    public boolean isBlackKingside() {
        return (this.castlingRights & 4) > 0;
    }

    public boolean isBlackQueenside() {
        return (this.castlingRights & 8) > 0;
    }

    public void addAll() {
        this.castlingRights = 15;
    }

    public void clear() {
        this.castlingRights = 0;
    }

    public int getValue() {
        return this.castlingRights;
    }

    public void setValue(int castlingRights) {
        this.castlingRights = castlingRights;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MyCastlingRights)) {
            return false;
        }
        MyCastlingRights that = (MyCastlingRights)obj;
        return this.castlingRights == that.castlingRights;
    }

    public int hashCode() {
        return this.castlingRights;
    }
}

