/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.util;

import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.util.WorldGenChance;
import java.util.Random;

public final class IslandSpawnChecker {
    private static final Random coordCheckRand = new Random(0L);
    public static final int minSpacing = 13;
    public static final int maxSpacing = 28;
    public static final int minDistanceFromCenter = 1600;
    public static final int featureSize = 208;

    public static final byte getIslandBiomeAt(int chunkX, int chunkZ, long seed1, int seed2) {
        int origChunkX = chunkX;
        int origChunkZ = chunkZ;
        if (chunkX < 0) {
            chunkX -= 27;
        }
        if (chunkZ < 0) {
            chunkZ -= 27;
        }
        int x2 = chunkX / 28;
        int z2 = chunkZ / 28;
        coordCheckRand.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L + seed1 + 358041L);
        coordCheckRand.nextInt(seed2);
        x2 *= 28;
        z2 *= 28;
        if (origChunkX != (x2 += coordCheckRand.nextInt(15)) || origChunkZ != (z2 += coordCheckRand.nextInt(15))) {
            return -1;
        }
        double dist = Math.sqrt(MathUtil.square((long)x2 * 16L + 104L) + MathUtil.square((long)z2 * 16L + 104L));
        if (dist >= 1600.0 && coordCheckRand.nextInt(7) <= 4 && WorldGenChance.checkChance(0.65 + 0.35 * WorldGenChance.linear2Incr.calculate(dist, 1600.0, 4000.0), coordCheckRand)) {
            int x = origChunkX * 16;
            int z = origChunkZ * 16;
            coordCheckRand.setSeed((long)(x / 9) * 238504L + (long)(z / 9) * 10058432215L ^ seed1);
            coordCheckRand.nextInt(25);
            return IslandBiomeBase.pickRandomBiome((Random)IslandSpawnChecker.coordCheckRand).biomeID;
        }
        return -1;
    }

    private IslandSpawnChecker() {
    }
}

