/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.forest;

import chylex.hee.init.BlockList;
import chylex.hee.world.structure.island.biome.IslandBiomeInfestedForest;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import chylex.hee.world.util.Direction;
import java.util.Random;

public class StructureSpookyTree
extends AbstractIslandStructure {
    private TreeType treeType;
    private boolean canGenerateFace;
    private boolean looseSpaceCheck;

    public StructureSpookyTree setTreeType(TreeType treeType) {
        this.treeType = treeType;
        return this;
    }

    public StructureSpookyTree setCanGenerateFace(boolean canGenerateFace) {
        this.canGenerateFace = canGenerateFace;
        return this;
    }

    public StructureSpookyTree setLooseSpaceCheck(boolean looseSpaceCheck) {
        this.looseSpaceCheck = looseSpaceCheck;
        return this;
    }

    @Override
    protected boolean generate(Random rand) {
        int x = this.getRandomXZ(rand, this.treeType.rad);
        int z = this.getRandomXZ(rand, this.treeType.rad);
        int y = this.world.getHighestY(x, z);
        if (this.world.getBlock(x, y++, z) == this.surface()) {
            int checkY;
            boolean tallTrees = this.biomeData.hasDeviation(IslandBiomeInfestedForest.TALL_TREES);
            int treeHeight = rand.nextInt(4 + rand.nextInt(4)) + (tallTrees ? 5 + rand.nextInt(1 + rand.nextInt(7)) : 4);
            for (checkY = 0; checkY <= (this.looseSpaceCheck ? treeHeight + 1 : treeHeight - 3); ++checkY) {
                if (this.world.isAir(x, y + checkY, z)) continue;
                return false;
            }
            if (!this.looseSpaceCheck) {
                for (checkY = treeHeight - 2; checkY <= treeHeight + 1; ++checkY) {
                    for (int checkX = -this.treeType.rad; checkX <= this.treeType.rad; ++checkX) {
                        for (int checkZ = -this.treeType.rad; checkZ <= this.treeType.rad; ++checkZ) {
                            if (this.world.isAir(x + checkX, y + checkY, z + checkZ)) continue;
                            return false;
                        }
                    }
                }
            }
            boolean hasFace = false;
            int meta = 0;
            for (int treeY = 0; treeY < treeHeight; ++treeY) {
                this.world.setBlock(x, y + treeY, z, BlockList.spooky_log, hasFace ? 0 : meta);
                if (meta > 0) {
                    hasFace = true;
                }
                meta = this.canGenerateFace && rand.nextInt(12) == 0 ? rand.nextInt(5) : 0;
            }
            if (this.treeType == TreeType.SIMPLE_PYRAMID) {
                int topY;
                int pyramidBottomHeight = treeHeight < 5 ? 0 : rand.nextInt(3);
                int pyramidYOffset = pyramidBottomHeight > 0 ? rand.nextInt(3) : rand.nextInt(2);
                for (int py = topY = y + treeHeight + pyramidYOffset; py >= y + treeHeight; --py) {
                    this.world.setBlock(x, py, z, BlockList.spooky_leaves);
                }
                for (int dir = 0; dir < 4; ++dir) {
                    this.world.setBlock(x + Direction.offsetX[dir], topY - 1, z + Direction.offsetZ[dir], BlockList.spooky_leaves);
                }
                for (int pyramidBottomY = topY - 2; pyramidBottomY >= topY - 3 - pyramidBottomHeight; --pyramidBottomY) {
                    for (int px = x - 1; px <= x + 1; ++px) {
                        for (int pz = z - 1; pz <= z + 1; ++pz) {
                            if (px == x && pz == z) continue;
                            this.world.setBlock(px, pyramidBottomY, pz, BlockList.spooky_leaves, 0);
                        }
                    }
                }
            } else if (this.treeType == TreeType.SIMPLE_BULGING || this.treeType == TreeType.SIMPLE_SPHERICAL) {
                int dir;
                int bulgeHeight = treeHeight < 5 ? 1 : 1 + rand.nextInt(3);
                for (int py = y + treeHeight + 2; py >= y + treeHeight; --py) {
                    this.world.setBlock(x, py, z, BlockList.spooky_leaves);
                }
                for (int middleY = 0; middleY <= 2 + bulgeHeight; ++middleY) {
                    for (dir = 0; dir < 4; ++dir) {
                        this.world.setBlock(x + Direction.offsetX[dir], y + treeHeight + 1 - middleY, z + Direction.offsetZ[dir], BlockList.spooky_leaves);
                    }
                }
                for (int bulgeY = 0; bulgeY <= bulgeHeight; ++bulgeY) {
                    for (int offX = 0; offX < 2; ++offX) {
                        for (int offZ = 0; offZ < 2; ++offZ) {
                            this.world.setBlock(x - 1 + 2 * offX, y + treeHeight - bulgeY, z - 1 + 2 * offZ, BlockList.spooky_leaves);
                        }
                    }
                    if (this.treeType != TreeType.SIMPLE_SPHERICAL) continue;
                    for (dir = 0; dir < 4; ++dir) {
                        this.world.setBlock(x + Direction.offsetX[dir] * 2, y + treeHeight - bulgeY, z + Direction.offsetZ[dir] * 2, BlockList.spooky_leaves);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static enum TreeType {
        SIMPLE_PYRAMID(1),
        SIMPLE_BULGING(1),
        SIMPLE_SPHERICAL(2);

        public static final TreeType[] values;
        final byte rad;

        private TreeType(int rad) {
            this.rad = (byte)rad;
        }

        static {
            values = TreeType.values();
        }
    }
}

