/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.render;

import chylex.hee.block.BlockEnderGoo;
import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.item.ItemBiomeCompass;
import chylex.hee.mechanics.energy.EnergyClusterHealth;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityEnergyCluster;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class OverlayManager {
    private static OverlayManager instance;
    private static final ResourceLocation texGoo;
    private TileEntityEnergyCluster clusterLookedAt;
    private final List<Notification> notifications = new ArrayList<Notification>();
    public static BlockPosM tmpPos;

    public static void addNotification(String notification) {
        if (instance == null) {
            OverlayManager.register();
        }
        OverlayManager.instance.notifications.add(new Notification(notification));
    }

    public static void register() {
        if (instance == null) {
            instance = new OverlayManager();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    private OverlayManager() {
    }

    @SubscribeEvent
    public void onRenderTick(RenderWorldLastEvent e) {
        Set<ChunkCoordinates> coords;
        ItemStack is;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (mc.field_71439_g.field_71093_bK == 1 && (is = mc.field_71439_g.field_71071_by.func_70448_g()) != null && is.func_77973_b() == ItemList.biome_compass && ItemBiomeCompass.currentBiome != -1 && !(coords = ItemBiomeCompass.locations.get(ItemBiomeCompass.currentBiome)).isEmpty()) {
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPushMatrix();
            mc.field_71446_o.func_110577_a(TextureMap.field_110576_c);
            for (ChunkCoordinates coord : coords) {
                double viewRot = 90.0 + Math.toDegrees(Math.atan2(mc.field_71439_g.field_70165_t - (double)coord.field_71574_a, mc.field_71439_g.field_70161_v - (double)coord.field_71573_c));
                float dist = (float)MathUtil.distance(mc.field_71439_g.field_70165_t - (double)coord.field_71574_a, mc.field_71439_g.field_70161_v - (double)coord.field_71573_c);
                if (dist <= 40.0f) continue;
                if (dist < 140.0f) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f * ((dist - 40.0f) / 100.0f)));
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                }
                GL11.glPushMatrix();
                GL11.glRotated((double)viewRot, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                GL11.glTranslated((double)(5.0f + dist * 0.05f), (double)0.0, (double)0.0);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glRotated((double)270.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScalef((float)6.0f, (float)6.0f, (float)6.0f);
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                IIcon icon = ItemList.special_effects.func_77617_a(20 + ItemBiomeCompass.currentBiome);
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (e.type == RenderGameOverlayEvent.ElementType.HELMET && mc.field_71439_g.func_70055_a(BlockEnderGoo.enderGoo)) {
            int w = e.resolution.func_78326_a();
            int h = e.resolution.func_78328_b();
            GL11.glDisable((int)3008);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(texGoo);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a(0.0, (double)h, -90.0, 0.0, 1.0);
            tessellator.func_78374_a((double)w, (double)h, -90.0, 1.0, 1.0);
            tessellator.func_78374_a((double)w, 0.0, -90.0, 1.0, 0.0);
            tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public void onPostRenderGameOverlay(RenderGameOverlayEvent.Post e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (e.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            FontRenderer font;
            if (!this.notifications.isEmpty()) {
                font = mc.field_71466_p;
                boolean prevUnicode = font.func_82883_a();
                font.func_78264_a(true);
                int scale = e.resolution.func_78325_e();
                double fontScale = scale == 1 ? 2.0 : (scale == 2 ? 1.0 : (scale == 3 ? 0.677 : 0.5));
                double fontScale2 = 1.0 / fontScale;
                GL11.glPushMatrix();
                GL11.glScaled((double)fontScale, (double)fontScale, (double)fontScale);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2929);
                int scaledW = (int)((double)e.resolution.func_78326_a() * fontScale2);
                int scaledH = (int)((double)e.resolution.func_78328_b() * fontScale2);
                Iterator<Notification> iter = this.notifications.iterator();
                while (iter.hasNext()) {
                    Notification n = iter.next();
                    int w = font.func_78256_a(n.text);
                    font.func_78261_a(n.text, scaledW - w - 3, scaledH - 10 - n.yy, (int)Math.max(4.0, Math.floor(255.0f * n.alpha)) << 24 | 0xFF0000 | 0xFF00 | 0xFF);
                    if (!n.update()) continue;
                    iter.remove();
                }
                font.func_78264_a(prevUnicode);
                GL11.glEnable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
            if (this.clusterLookedAt != null) {
                font = mc.field_71466_p;
                int x = e.resolution.func_78326_a() >> 1;
                int y = e.resolution.func_78328_b() >> 1;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.drawStringCentered(font, I18n.func_135052_a((String)"energy.overlay.title", (Object[])new Object[0]), x, y - 40, 255, 255, 255);
                this.drawStringCentered(font, I18n.func_135052_a((String)"energy.overlay.holding", (Object[])new Object[0]).replace("$", DragonUtil.formatTwoPlaces.format(this.clusterLookedAt.data.getEnergyLevel())), x, y - 30, 220, 220, 220);
                this.drawStringCentered(font, I18n.func_135052_a((String)"energy.overlay.regen", (Object[])new Object[0]).replace("$", DragonUtil.formatTwoPlaces.format(this.clusterLookedAt.data.getMaxEnergyLevel())), x, y - 20, 220, 220, 220);
                EnergyClusterHealth health = this.clusterLookedAt.data.getHealthStatus();
                this.drawStringCentered(font, I18n.func_135052_a((String)health.translationText, (Object[])new Object[0]), x, y - 10, health.color);
                GL11.glDisable((int)3042);
                this.clusterLookedAt = null;
            }
        }
    }

    private void drawStringCentered(FontRenderer font, String text, int x, int y, int red, int green, int blue) {
        font.func_78261_a(text, x - (font.func_78256_a(text) >> 1), y - (font.field_78288_b >> 1), 0xDC000000 | red << 16 | green << 8 | blue);
    }

    private void drawStringCentered(FontRenderer font, String text, int x, int y, int color) {
        font.func_78261_a(text, x - (font.func_78256_a(text) >> 1), y - (font.field_78288_b >> 1), color);
    }

    @SubscribeEvent
    public void onRenderBlockOutline(DrawBlockHighlightEvent e) {
        BlockPosM tmp = tmpPos.set(e.target.field_72311_b, e.target.field_72312_c, e.target.field_72309_d);
        if (tmp.getBlock((IBlockAccess)e.player.field_70170_p) == BlockList.energy_cluster) {
            this.clusterLookedAt = (TileEntityEnergyCluster)tmp.getTileEntity((IBlockAccess)e.player.field_70170_p);
            e.setCanceled(true);
        }
    }

    static {
        texGoo = new ResourceLocation("hardcoreenderexpansion:textures/overlay/endergoo.png");
        tmpPos = new BlockPosM();
    }

    private static class Notification {
        final String text;
        byte yy;
        float alpha;
        long lastTime;

        Notification(String text) {
            this.text = text;
        }

        boolean update() {
            if (this.lastTime == Minecraft.func_71410_x().field_71441_e.func_82737_E()) {
                return false;
            }
            this.lastTime = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            if ((this.lastTime & 3L) == 0L) {
                this.yy = (byte)(this.yy + 1);
            }
            if (this.yy < 6) {
                this.alpha = Math.min(1.0f, this.alpha + 0.1f);
            } else if (this.yy > 10) {
                float f;
                this.alpha -= 0.1f;
                if (f <= 0.0f) {
                    return true;
                }
            }
            return false;
        }
    }
}

