/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.misc;

import chylex.hee.entity.mob.EntityMobAngryEnderman;
import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.util.MathUtil;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.storage.WorldInfo;

public enum GemSideEffects implements IWeightProvider
{
    DEFLECTION(10),
    SLOWNESS(10),
    NAUSEA(8),
    WEAKNESS(6),
    HUNGER(5, 0.72f),
    ENDERMEN(3, 0.78f),
    ITEMDROP(2, 0.82f),
    STORM(1, 0.88f);

    private byte weight;
    private float minPerc;

    private GemSideEffects(int weight, float minPercentage) {
        this.weight = (byte)weight;
        this.minPerc = minPercentage;
    }

    private GemSideEffects(int weight) {
        this(weight, 0.66f);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public static void performRandomEffect(Entity entity, float percBroken) {
        Random rand = entity.field_70170_p.field_73012_v;
        WeightedList list = new WeightedList((IWeightProvider[])new GemSideEffects[0]);
        for (GemSideEffects effect : GemSideEffects.values()) {
            if (!(percBroken > effect.minPerc)) continue;
            list.add(effect);
        }
        switch ((GemSideEffects)list.getRandomItem(rand)) {
            case DEFLECTION: {
                double ang = rand.nextDouble() * 2.0 * Math.PI;
                double len = rand.nextDouble() * 72.0 * (double)percBroken * (double)percBroken;
                double x = entity.field_70165_t + Math.cos(ang) * len;
                double z = entity.field_70161_v + Math.sin(ang) * len;
                entity.func_70012_b(x + 0.5, (double)entity.field_70170_p.func_72825_h(MathUtil.floor(x), MathUtil.floor(z)) + 1.0, z + 0.5, entity.field_70177_z, entity.field_70125_A);
                break;
            }
            case SLOWNESS: {
                if (!(entity instanceof EntityLivingBase)) break;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, MathUtil.ceil(280.0f * percBroken), 1, true));
                break;
            }
            case NAUSEA: {
                if (!(entity instanceof EntityLivingBase)) break;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, MathUtil.ceil(340.0f * percBroken), 0, true));
                break;
            }
            case WEAKNESS: {
                if (!(entity instanceof EntityLivingBase)) break;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, MathUtil.ceil(320.0f * percBroken), 1, true));
                break;
            }
            case HUNGER: {
                if (!(entity instanceof EntityLivingBase)) break;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, MathUtil.ceil(265.0f * percBroken), 0, true));
                break;
            }
            case ENDERMEN: {
                for (int a = 0; a < rand.nextInt(3) + 2; ++a) {
                    entity.field_70170_p.func_72838_d((Entity)new EntityMobAngryEnderman(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                }
                break;
            }
            case ITEMDROP: {
                if (!(entity instanceof EntityPlayer)) break;
                EntityPlayer player = (EntityPlayer)entity;
                for (int a = 0; a < 10 + rand.nextInt(12); ++a) {
                    int slot = rand.nextInt(player.field_71071_by.func_70302_i_());
                    ItemStack is = player.field_71071_by.func_70301_a(slot);
                    if (is == null) continue;
                    player.func_70099_a(is, 0.0f);
                    player.field_71071_by.func_70299_a(slot, null);
                }
                break;
            }
            case STORM: {
                WorldInfo info = entity.field_70170_p.func_72912_H();
                int i = (140 + rand.nextInt(75)) * 20;
                info.func_76080_g(i);
                info.func_76090_f(i);
                info.func_76084_b(true);
                info.func_76069_a(true);
                break;
            }
        }
    }
}

