/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.charms.handler;

import chylex.hee.mechanics.charms.CharmPouchInfo;
import chylex.hee.mechanics.charms.CharmRecipe;
import chylex.hee.mechanics.charms.CharmType;
import chylex.hee.mechanics.charms.handler.CharmPouchHandlerClient;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gnu.trove.list.array.TFloatArrayList;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class CharmEventsClient {
    public static float[] getProp(String prop) {
        CharmPouchInfo info = CharmPouchHandlerClient.getActivePouch();
        if (info == null) {
            return ArrayUtils.EMPTY_FLOAT_ARRAY;
        }
        TFloatArrayList values = new TFloatArrayList(5);
        for (Pair<CharmType, CharmRecipe> entry : info.charms) {
            float value = ((CharmRecipe)entry.getRight()).getProp(prop);
            if (value == -1.0f) continue;
            values.add(value);
        }
        return values.toArray();
    }

    public static float getPropPercentIncrease(String prop, float baseValue) {
        float finalValue = 0.0f;
        for (float val : CharmEventsClient.getProp(prop)) {
            finalValue += val * baseValue - baseValue;
        }
        return finalValue;
    }

    CharmEventsClient() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreakSpeed(PlayerEvent.BreakSpeed e) {
        if (e.entity.field_70170_p.field_72995_K) {
            e.newSpeed += CharmEventsClient.getPropPercentIncrease("breakspd", e.originalSpeed);
        }
    }
}

