/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.api;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class TGSaveData
extends WorldSavedData {
    private static TGSaveData INSTANCE;
    public HashMap<UUID, NBTTagCompound> playerData = new HashMap();
    public static HashMap<UUID, NBTTagCompound> clientData;
    public static final String dataName = "TG-SaveData";

    public TGSaveData(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("playerList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            UUID uuid = new UUID(tag.func_74763_f("UUIDMost"), tag.func_74763_f("UUIDLeast"));
            this.playerData.put(uuid, tag);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<UUID, NBTTagCompound> entry : this.playerData.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            NBTTagCompound tag = entry.getValue();
            tag.func_74772_a("UUIDMost", entry.getKey().getMostSignificantBits());
            tag.func_74772_a("UUIDLeast", entry.getKey().getLeastSignificantBits());
            tagList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("playerList", (NBTBase)tagList);
    }

    public static NBTTagCompound getPlayerData(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (INSTANCE != null) {
                return TGSaveData.INSTANCE.playerData.get(player.getPersistentID());
            }
        } else {
            return clientData.get(player.getPersistentID());
        }
        return new NBTTagCompound();
    }

    public static void setPlayerData(EntityPlayer player, NBTTagCompound tag) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (INSTANCE != null) {
                TGSaveData.INSTANCE.playerData.put(player.getPersistentID(), tag);
            }
        } else {
            clientData.put(player.getPersistentID(), tag);
        }
    }

    public static void setDirty() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && INSTANCE != null) {
            INSTANCE.func_76185_a();
        }
    }

    public static void setInstance(TGSaveData in) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            INSTANCE = in;
        }
    }

    static {
        clientData = new HashMap();
    }
}

