/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.combustion;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.generator.combustion.ContainerCombustionEngine;
import crazypants.enderio.machine.generator.combustion.GuiCombustionGenerator;
import crazypants.enderio.machine.generator.combustion.PacketCombustionTank;
import crazypants.enderio.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.network.PacketHandler;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCombustionGenerator
extends AbstractMachineBlock<TileCombustionGenerator> {
    public static int renderId = -1;
    private IIcon overlayPullSides;
    private IIcon overlayPullTopBottom;
    private IIcon overlayDisabledNoCenter;

    public static BlockCombustionGenerator create() {
        PacketHandler.INSTANCE.registerMessage(PacketCombustionTank.class, PacketCombustionTank.class, PacketHandler.nextID(), Side.CLIENT);
        BlockCombustionGenerator gen = new BlockCombustionGenerator();
        gen.init();
        return gen;
    }

    protected BlockCombustionGenerator() {
        super(ModObject.blockCombustionGenerator, TileCombustionGenerator.class);
    }

    public int func_149717_k() {
        return 0;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCombustionGenerator) {
            return new ContainerCombustionEngine(player.field_71071_by, (TileCombustionGenerator)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCombustionGenerator) {
            return new GuiCombustionGenerator(player.field_71071_by, (TileCombustionGenerator)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 21;
    }

    @Override
    public int func_149645_b() {
        return renderId;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerOverlayIcons(IIconRegister iIconRegister) {
        super.registerOverlayIcons(iIconRegister);
        this.overlayPullSides = iIconRegister.func_94245_a("enderio:overlays/pullSides");
        this.overlayPullTopBottom = iIconRegister.func_94245_a("enderio:overlays/pullTopBottom");
        this.overlayDisabledNoCenter = iIconRegister.func_94245_a("enderio:overlays/disabledNoCenter");
    }

    @Override
    public IIcon getOverlayIconForMode(TileCombustionGenerator tile, ForgeDirection face, IoMode mode) {
        if (face.offsetY == 0 || mode == IoMode.NONE) {
            return super.getOverlayIconForMode(tile, face, mode);
        }
        return mode == IoMode.PULL ? (face.offsetY == 0 ? this.overlayPullSides : this.overlayPullTopBottom) : this.overlayDisabledNoCenter;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        return this.getBackIconKey(active);
    }

    @Override
    protected String getModelIconKey(boolean active) {
        return "enderio:combustionGenModel";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.isActive((IBlockAccess)world, x, y, z)) {
            TileEntity te = world.func_147438_o(x, y, z);
            int facing = 3;
            if (te instanceof AbstractMachineEntity) {
                AbstractMachineEntity me = (AbstractMachineEntity)te;
                facing = me.facing;
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
            float startX = (float)x + (dir.offsetX == 0 ? 0.5f : 0.0f);
            float startY = (float)y + 0.5f;
            float startZ = (float)z + (dir.offsetZ == 0 ? 0.5f : 0.0f);
            if (dir.offsetX == 1) {
                startX += 1.0f;
            } else if (dir.offsetZ == 1) {
                startZ += 1.0f;
            }
            for (int i = 0; i < 2; ++i) {
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                float zOffset = 0.0f;
                world.func_72869_a("smoke", (double)(startX + xOffset), (double)(startY + yOffset), (double)(startZ + zOffset), 0.0, 0.0, 0.0);
            }
        }
    }
}

