/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.N2ConfigApi.api.core;

import com.n247s.N2ConfigApi.api.N2ConfigApi;
import com.n247s.N2ConfigApi.api.core.InitConfigObjectManager;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.logging.log4j.Logger;
import scala.actors.threadpool.Arrays;

public class ConfigSection
implements Serializable {
    private static final long serialVersionUID = -864529735488611585L;
    private static final Logger log = N2ConfigApi.log;
    private String sectionName;
    private String[] description = new String[0];
    private Object defaultValue;
    private SectionType sectionType;
    private boolean seperateLines;
    private boolean hideOutLines;
    private boolean changedDefaultValue;
    private String sectionStarter = "-----------------------------------------------------------------------------------------------------";
    private String SectionHeadEnder = "";
    private String SectionEnder = "-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-";

    public ConfigSection(String sectionName, String[] description, Object defaultValue, SectionType sectionType, boolean separateLines, boolean hideOutLines) {
        this.sectionName = sectionName;
        this.description = description;
        this.sectionType = sectionType;
        this.defaultValue = defaultValue;
        this.seperateLines = separateLines;
        this.hideOutLines = hideOutLines;
        this.changedDefaultValue = true;
    }

    public ConfigSection(String sectionName, String[] description, Object defaultValue, SectionType sectionType, boolean hideOutLines) {
        this(sectionName, description, defaultValue, sectionType, false, hideOutLines);
    }

    public ConfigSection(String sectionName, String[] description, Object defaultValue, SectionType sectionType) {
        this(sectionName, description, defaultValue, sectionType, false, false);
    }

    public ConfigSection(String sectionName, String[] description, SectionType sectionType) {
        this(sectionName, description, null, sectionType, false, false);
    }

    public final String getSectionName() {
        return this.sectionName;
    }

    public final String[] getDescription() {
        return this.description;
    }

    public final Object getDefaultValue() {
        return this.defaultValue;
    }

    public final SectionType getSectionType() {
        return this.sectionType;
    }

    public final boolean getSeparteLines() {
        return this.seperateLines;
    }

    public final boolean getHideOutLines() {
        return this.hideOutLines;
    }

    public final boolean getChangedDefaultValue() {
        return this.changedDefaultValue;
    }

    public final String getStarter() {
        return this.sectionStarter;
    }

    public final String getHeadEnder() {
        if (this.SectionHeadEnder != null && this.SectionHeadEnder.length() == 0) {
            return this.sectionStarter;
        }
        return this.SectionHeadEnder;
    }

    public final String getEnder() {
        return this.SectionEnder;
    }

    public final ConfigSection setCustomSectionStarter(String sectionStarter) {
        this.sectionStarter = sectionStarter;
        return this;
    }

    public final ConfigSection setCustomSectionHeadEnder(String sectionHeadEnder) {
        this.SectionHeadEnder = sectionHeadEnder;
        this.hideOutLines = false;
        return this;
    }

    public final ConfigSection setCustomSectionEnder(String sectionEnder) {
        this.SectionEnder = sectionEnder;
        return this;
    }

    public final ConfigSection setDescription(String[] description) {
        this.description = description;
        return this;
    }

    public final ConfigSection setDefaultValue(Object defaultvalue) {
        this.defaultValue = defaultvalue;
        this.changedDefaultValue = true;
        return this;
    }

    public final ConfigSection setChangedDefaultValue(boolean changedDefaultValue) {
        this.changedDefaultValue = changedDefaultValue;
        return this;
    }

    protected final void writeFullSectionToByteBuf(ByteBufOutputStream stream, Object value) throws IOException {
        stream.writeUTF(this.sectionName);
        stream.writeInt(this.sectionType.index);
        stream.writeInt(this.description.length);
        for (String currentLine : this.description) {
            stream.writeUTF(currentLine);
        }
        stream.writeUTF(this.sectionStarter);
        stream.writeUTF(this.SectionHeadEnder);
        stream.writeUTF(this.SectionEnder);
        this.writeValueToByteBuf(stream, value);
        if (this.sectionType.isArray) {
            if (this.sectionType == SectionType.SectionHead) {
                stream.writeInt(((Integer)value).intValue());
            } else {
                List valueList = Arrays.asList((Object[])((Object[])value));
                stream.writeInt(valueList.size());
                for (Object currentValue : valueList) {
                    this.writeValueToByteBuf(stream, currentValue);
                }
            }
        } else {
            this.writeValueToByteBuf(stream, value);
        }
        stream.writeBoolean(this.seperateLines);
        stream.writeBoolean(this.hideOutLines);
        stream.writeBoolean(this.changedDefaultValue);
    }

    protected final void WriteSectionValuesToByteBuf(ByteBufOutputStream stream, Object value) throws IOException {
        if (this.sectionType.equals((Object)SectionType.Text) || this.sectionType.equals((Object)SectionType.SectionHead)) {
            return;
        }
        stream.writeUTF(this.sectionName);
        stream.writeInt(this.sectionType.index);
        if (this.sectionType.isArray) {
            List valueList = Arrays.asList((Object[])((Object[])value));
            stream.writeInt(valueList.size());
            for (Object currentValue : valueList) {
                this.writeValueToByteBuf(stream, currentValue);
            }
        } else {
            this.writeValueToByteBuf(stream, value);
        }
        stream.flush();
    }

    protected final void createFullSectionFromBuf(ByteBufInputStream stream, InitConfigObjectManager.Config config) throws IOException {
        int descriptionLength = stream.readInt();
        String[] description = new String[descriptionLength];
        for (int i = 0; i < descriptionLength; ++i) {
            description[i] = stream.readUTF();
        }
        this.description = description;
        this.sectionStarter = stream.readUTF();
        this.SectionHeadEnder = stream.readUTF();
        this.SectionEnder = stream.readUTF();
        if (this.sectionType.isArray) {
            int arrayLength = stream.readInt();
            Object[] array = new Object[arrayLength];
            if (this.sectionType != SectionType.SectionHead) {
                for (int i = 0; i < arrayLength; ++i) {
                    if (this.sectionType == SectionType.Text) continue;
                    array[i] = this.readValueFromByteBuf(stream);
                }
                this.defaultValue = Arrays.copyOf((Object[])array, (int)arrayLength, (Class)this.sectionType.getValueClass());
            } else {
                this.defaultValue = arrayLength;
            }
        } else {
            this.defaultValue = this.readValueFromByteBuf(stream);
        }
        this.seperateLines = stream.readBoolean();
        this.hideOutLines = stream.readBoolean();
        this.changedDefaultValue = stream.readBoolean();
        if (config != null) {
            InitConfigObjectManager.addField(config, this.sectionName, this.defaultValue);
        }
    }

    protected final void createSectionValuesFromBuf(ByteBufInputStream stream, InitConfigObjectManager.Config config) throws IOException {
        if (this.sectionType != SectionType.values()[stream.readInt()]) {
            log.catching((Throwable)new Exception("ConfigSection " + this.sectionName + " has a discrepancy from the recieved information!"));
            return;
        }
        if (this.sectionType.isArray) {
            int arrayLength = stream.readInt();
            Object[] array = new Object[arrayLength];
            if (this.sectionType != SectionType.SectionHead) {
                for (int i = 0; i < arrayLength; ++i) {
                    if (this.sectionType == SectionType.Text) continue;
                    array[i] = this.readValueFromByteBuf(stream);
                }
                this.defaultValue = Arrays.copyOf((Object[])array, (int)arrayLength, (Class)this.sectionType.getValueClass());
            } else {
                this.defaultValue = arrayLength;
            }
        } else {
            this.defaultValue = this.readValueFromByteBuf(stream);
        }
    }

    private void writeValueToByteBuf(ByteBufOutputStream stream, Object value) {
        try {
            switch (this.sectionType) {
                case Short: 
                case ShortArray: {
                    stream.writeShort(((Integer)value).intValue());
                    break;
                }
                case Integer: 
                case IntegerArray: {
                    stream.writeInt(((Integer)value).intValue());
                    break;
                }
                case Long: 
                case LongArray: {
                    stream.writeLong(((Long)value).longValue());
                    break;
                }
                case Float: 
                case FloatArray: {
                    stream.writeFloat(((Float)value).floatValue());
                    break;
                }
                case Double: 
                case DoubleArray: {
                    stream.writeDouble(((Double)value).doubleValue());
                    break;
                }
                case Boolean: 
                case BooleanArray: {
                    stream.writeBoolean(((Boolean)value).booleanValue());
                    break;
                }
                case String: 
                case StringArray: {
                    stream.writeUTF((String)value);
                }
                case SectionHead: 
                case Text: {
                    return;
                }
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    public Object readValueFromByteBuf(ByteBufInputStream stream) {
        try {
            switch (this.sectionType) {
                case Short: 
                case ShortArray: {
                    return stream.readShort();
                }
                case Integer: 
                case IntegerArray: {
                    return stream.readInt();
                }
                case Long: 
                case LongArray: {
                    return stream.readLong();
                }
                case Float: 
                case FloatArray: {
                    return Float.valueOf(stream.readFloat());
                }
                case Double: 
                case DoubleArray: {
                    return stream.readDouble();
                }
                case Boolean: 
                case BooleanArray: {
                    return stream.readBoolean();
                }
                case String: 
                case StringArray: {
                    return stream.readUTF();
                }
                case SectionHead: 
                case Text: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
        return null;
    }

    public static enum SectionType {
        Short(false, 0, Short.class),
        ShortArray(true, 1, Short[].class),
        Integer(false, 2, Integer.class),
        IntegerArray(true, 3, Integer[].class),
        Long(false, 4, Long.class),
        LongArray(true, 5, Long[].class),
        Float(false, 6, Float.class),
        FloatArray(true, 7, Float[].class),
        Double(false, 8, Double.class),
        DoubleArray(true, 9, Double[].class),
        Boolean(false, 10, Boolean.class),
        BooleanArray(true, 11, Boolean[].class),
        String(false, 12, String.class),
        StringArray(true, 13, String[].class),
        Text(false, 14, null),
        SectionHead(true, 15, null);

        private final boolean isArray;
        private final int index;
        private final Class valueClassType;

        private SectionType(boolean isArray, int index, Class valueClassType) {
            this.isArray = isArray;
            this.index = index;
            this.valueClassType = valueClassType;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public int getIndex() {
            return this.index;
        }

        public Class getValueClass() {
            return this.valueClassType;
        }
    }
}

