/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.N2ConfigApi.api;

import com.n247s.N2ConfigApi.api.core.events.ConfigApiEvents;
import com.n247s.N2ConfigApi.api.networking.N2ConfigApiMessageHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class N2ConfigApi {
    private static final HashMap<String, File> DirectoryList = new HashMap();
    private static final HashMap<File, File> TempDirectoryList = new HashMap();
    public static final Logger log = LogManager.getLogger((String)"N2ConfigAPI");
    public static N2ConfigApi instance;

    public static void preInit(FMLPreInitializationEvent event) {
        N2ConfigApiMessageHandler.preInitialize();
        ConfigApiEvents.preInitialize();
        N2ConfigApi.createDefaultDir(event.getModConfigurationDirectory());
    }

    public static File registerCustomConfigDirectory(String directoryPath, String directoryID) {
        File newDir = new File(N2ConfigApi.getConfigDir(), directoryPath);
        File newTempDir = new File(N2ConfigApi.getConfigDir(), directoryPath + "/temp");
        Iterator<String> directory = DirectoryList.keySet().iterator();
        while (directory.hasNext()) {
            File currentDirectory = DirectoryList.get(directory.next());
            if (!currentDirectory.getPath().equals(directoryPath)) continue;
            log.catching((Throwable)new IllegalArgumentException("DirectoryPath " + directoryPath + " already exist!"));
        }
        if (directoryID != null) {
            if (DirectoryList.containsKey(directoryID)) {
                log.error("ConfigFile " + directoryID + " is Already Registered!");
            } else {
                DirectoryList.put(directoryID, newDir);
            }
        } else {
            log.catching((Throwable)new NullPointerException());
        }
        TempDirectoryList.put(newDir, newTempDir);
        newTempDir.mkdirs();
        return newDir;
    }

    public static File registerCustomDirectory(File ParentDirectory, String directoryPath, String directoryID) {
        File newDir = new File(ParentDirectory, directoryPath);
        File newTempDir = new File(ParentDirectory, directoryPath + "/temp");
        Iterator<String> directory = DirectoryList.keySet().iterator();
        while (directory.hasNext()) {
            File currentDirectory = DirectoryList.get(directory.next());
            if (!currentDirectory.getPath().equals(directoryPath)) continue;
            log.catching((Throwable)new IllegalArgumentException("DirectoryPath " + directoryPath + " already exist!"));
        }
        if (directoryID != null) {
            if (DirectoryList.containsKey(directoryID)) {
                log.error("ConfigFile " + directoryID + " is Already Registered!");
            } else {
                DirectoryList.put(directoryID, newDir);
            }
        } else {
            log.catching((Throwable)new NullPointerException());
        }
        TempDirectoryList.put(newDir, newTempDir);
        return newDir;
    }

    public static File getMCMainDir() {
        return (File)FMLInjectionData.data()[6];
    }

    public static File getConfigDir() {
        return N2ConfigApi.getFileDirFromID("Default");
    }

    public static File getWorldDir() {
        return DimensionManager.getCurrentSaveRootDirectory();
    }

    public static String[] getDirContentConfigNames(File directory) {
        String[] totalList = N2ConfigApi.getDirContentNames(directory);
        ArrayList<String> finalList = new ArrayList<String>();
        for (int i = 0; i < totalList.length; ++i) {
            String currentName = totalList[i];
            if (!currentName.endsWith(".cfg")) continue;
            finalList.add(currentName.substring(0, currentName.length() - 4));
        }
        return finalList.toArray(new String[finalList.size()]);
    }

    public static String[] getDirContentConfigNames(String directoryID) {
        return N2ConfigApi.getDirContentConfigNames(N2ConfigApi.getFileDirFromID(directoryID));
    }

    public static String[] getDirContentNames(File directory) {
        return directory.list();
    }

    public static String[] getDirContentNames(String directoryID) {
        return N2ConfigApi.getFileDirFromID(directoryID).list();
    }

    public static File getFileDirFromID(String directoryID) {
        return DirectoryList.get(directoryID);
    }

    public static String getFileIDFromFileDir(File FileDirectory) {
        for (String currentString : DirectoryList.keySet()) {
            if (!DirectoryList.get(currentString).equals(FileDirectory)) continue;
            return currentString;
        }
        return null;
    }

    public static File getTempDir(File directory) {
        return TempDirectoryList.get(directory);
    }

    private static void createDefaultDir(File configDirectory) {
        DirectoryList.put("Default", configDirectory);
        TempDirectoryList.put(configDirectory, new File(configDirectory, "temp"));
    }
}

