/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class RitualEffectFeatheredKnife
extends RitualEffect {
    public final int amount = AlchemicalWizardry.lpPerSelfSacrificeFeatheredKnife;
    public static final int sanctusDrain = 5;
    public static final int reductusDrain = 3;
    public static final int magicalesDrain = 2;
    public static final int potentiaDrain = 5;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        int timeDelay;
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 5, false);
        int n = timeDelay = hasPotentia ? 10 : 20;
        if (world.func_72820_D() % (long)timeDelay != 0L) {
            return;
        }
        IBloodAltar tileAltar = null;
        boolean testFlag = false;
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                for (int k = -10; k <= 10; ++k) {
                    if (!(world.func_147438_o(x + i, y + k, z + j) instanceof IBloodAltar)) continue;
                    tileAltar = (IBloodAltar)world.func_147438_o(x + i, y + k, z + j);
                    testFlag = true;
                }
            }
        }
        if (!testFlag) {
            return;
        }
        boolean hasReductus = this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 3, false);
        double range = hasReductus ? 8.0 : 15.0;
        double vertRange = hasReductus ? 8.0 : 20.0;
        List<EntityPlayer> list = SpellHelper.getPlayersInRange(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, range, vertRange);
        int entityCount = 0;
        boolean flag = false;
        if (currentEssence < this.getCostPerRefresh() * list.size()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            boolean hasMagicales = this.canDrainReagent(ritualStone, ReagentRegistry.magicalesReagent, 2, false);
            boolean hasSanctus = this.canDrainReagent(ritualStone, ReagentRegistry.sanctusReagent, 5, false);
            EntityPlayer ownerPlayer = SpellHelper.getPlayerForUsername(owner);
            for (EntityPlayer player : list) {
                double threshold;
                hasSanctus = hasSanctus && this.canDrainReagent(ritualStone, ReagentRegistry.sanctusReagent, 5, false);
                double d = threshold = hasSanctus ? 0.7 : 0.3;
                if ((!hasMagicales || player != ownerPlayer) && hasMagicales || SpellHelper.isFakePlayer(world, player) || !((double)(player.func_110143_aJ() / player.func_110138_aP()) > threshold)) continue;
                player.func_70606_j(player.func_110143_aJ() - 1.0f);
                ++entityCount;
                tileAltar.sacrificialDaggerCall(this.amount, false);
                if (hasSanctus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.sanctusReagent, 5, true);
                }
                if (!hasMagicales) continue;
                this.canDrainReagent(ritualStone, ReagentRegistry.magicalesReagent, 2, true);
                break;
            }
            if (entityCount > 0) {
                if (hasReductus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 3, true);
                }
                if (hasPotentia) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 5, true);
                }
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh() * entityCount);
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostFeatheredKnife[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> featheredKnifeRitual = new ArrayList<RitualComponent>();
        featheredKnifeRitual.add(new RitualComponent(1, 0, 0, 5));
        featheredKnifeRitual.add(new RitualComponent(-1, 0, 0, 5));
        featheredKnifeRitual.add(new RitualComponent(0, 0, 1, 5));
        featheredKnifeRitual.add(new RitualComponent(0, 0, -1, 5));
        featheredKnifeRitual.add(new RitualComponent(2, -1, 0, 1));
        featheredKnifeRitual.add(new RitualComponent(-2, -1, 0, 1));
        featheredKnifeRitual.add(new RitualComponent(0, -1, 2, 1));
        featheredKnifeRitual.add(new RitualComponent(0, -1, -2, 1));
        featheredKnifeRitual.add(new RitualComponent(1, -1, 1, 4));
        featheredKnifeRitual.add(new RitualComponent(1, -1, -1, 4));
        featheredKnifeRitual.add(new RitualComponent(-1, -1, 1, 4));
        featheredKnifeRitual.add(new RitualComponent(-1, -1, -1, 4));
        featheredKnifeRitual.add(new RitualComponent(4, -1, 2, 2));
        featheredKnifeRitual.add(new RitualComponent(2, -1, 4, 2));
        featheredKnifeRitual.add(new RitualComponent(-4, -1, 2, 2));
        featheredKnifeRitual.add(new RitualComponent(2, -1, -4, 2));
        featheredKnifeRitual.add(new RitualComponent(4, -1, -2, 2));
        featheredKnifeRitual.add(new RitualComponent(-2, -1, 4, 2));
        featheredKnifeRitual.add(new RitualComponent(-4, -1, -2, 2));
        featheredKnifeRitual.add(new RitualComponent(-2, -1, -4, 2));
        featheredKnifeRitual.add(new RitualComponent(4, 0, 2, 3));
        featheredKnifeRitual.add(new RitualComponent(2, 0, 4, 3));
        featheredKnifeRitual.add(new RitualComponent(-4, 0, 2, 3));
        featheredKnifeRitual.add(new RitualComponent(2, 0, -4, 3));
        featheredKnifeRitual.add(new RitualComponent(4, 0, -2, 3));
        featheredKnifeRitual.add(new RitualComponent(-2, 0, 4, 3));
        featheredKnifeRitual.add(new RitualComponent(-4, 0, -2, 3));
        featheredKnifeRitual.add(new RitualComponent(-2, 0, -4, 3));
        featheredKnifeRitual.add(new RitualComponent(4, 0, 3, 3));
        featheredKnifeRitual.add(new RitualComponent(3, 0, 4, 3));
        featheredKnifeRitual.add(new RitualComponent(-4, 0, 3, 3));
        featheredKnifeRitual.add(new RitualComponent(3, 0, -4, 3));
        featheredKnifeRitual.add(new RitualComponent(4, 0, -3, 3));
        featheredKnifeRitual.add(new RitualComponent(-3, 0, 4, 3));
        featheredKnifeRitual.add(new RitualComponent(-4, 0, -3, 3));
        featheredKnifeRitual.add(new RitualComponent(-3, 0, -4, 3));
        featheredKnifeRitual.add(new RitualComponent(3, 0, 3, 4));
        featheredKnifeRitual.add(new RitualComponent(3, 0, -3, 4));
        featheredKnifeRitual.add(new RitualComponent(-3, 0, 3, 4));
        featheredKnifeRitual.add(new RitualComponent(-3, 0, -3, 4));
        return featheredKnifeRitual;
    }
}

