/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.relocation.handler;

import codechicken.lib.vec.BlockCoord;
import java.util.Set;
import mrtjp.relocation.MovementManager2$;
import mrtjp.relocation.api.BlockPos;
import mrtjp.relocation.api.IMovementCallback;
import mrtjp.relocation.api.Relocator;
import mrtjp.relocation.handler.RelocationRun;
import net.minecraft.world.World;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.Stack;

public final class Relocator_Impl$
extends Relocator {
    public static final Relocator_Impl$ MODULE$;
    private Stack<RelocationRun> mainStack;
    private Stack<RelocationRun> tempStack;

    static {
        new Relocator_Impl$();
    }

    public Stack<RelocationRun> mainStack() {
        return this.mainStack;
    }

    public void mainStack_$eq(Stack<RelocationRun> x$1) {
        this.mainStack = x$1;
    }

    public Stack<RelocationRun> tempStack() {
        return this.tempStack;
    }

    public void tempStack_$eq(Stack<RelocationRun> x$1) {
        this.tempStack = x$1;
    }

    private void assertState() {
        if (this.mainStack().isEmpty()) {
            throw new IllegalStateException("Relocator stack is empty.");
        }
    }

    @Override
    public void push() {
        RelocationRun r = this.tempStack().isEmpty() ? new RelocationRun() : (RelocationRun)this.tempStack().pop();
        this.mainStack().push((Object)r);
    }

    @Override
    public void pop() {
        this.assertState();
        RelocationRun r = (RelocationRun)this.mainStack().pop();
        r.clear();
        this.tempStack().push((Object)r);
    }

    @Override
    public void setWorld(World world) {
        this.assertState();
        RelocationRun top = (RelocationRun)this.mainStack().top();
        if (top.world() == null) {
            top.world_$eq(world);
            return;
        }
        throw new IllegalStateException("World already set.");
    }

    @Override
    public void setDirection(int dir) {
        this.assertState();
        RelocationRun top = (RelocationRun)this.mainStack().top();
        if (top.dir() != -1) {
            throw new IllegalStateException("Direction already set.");
        }
        top.dir_$eq(dir);
    }

    @Override
    public void setSpeed(double speed) {
        this.assertState();
        RelocationRun top = (RelocationRun)this.mainStack().top();
        if (top.speed() > 0.0) {
            throw new IllegalStateException("Speed already set.");
        }
        top.speed_$eq(speed);
    }

    @Override
    public void setCallback(IMovementCallback callback) {
        this.assertState();
        RelocationRun top = (RelocationRun)this.mainStack().top();
        if (top.callback() == null) {
            top.callback_$eq(callback);
            return;
        }
        throw new IllegalStateException("Callback already set.");
    }

    @Override
    public void addBlock(int x, int y, int z) {
        this.assertState();
        ((RelocationRun)this.mainStack().top()).blocks().$plus$eq((Object)new BlockCoord(x, y, z));
    }

    @Override
    public void addBlock(BlockPos bc) {
        this.addBlock(bc.x, bc.y, bc.z);
    }

    @Override
    public void addBlocks(Set<BlockPos> blocks) {
        JavaConversions$.MODULE$.asScalaSet(blocks).foreach((Function1)new Serializable(){

            public final void apply(BlockPos b) {
                Relocator_Impl$.MODULE$.addBlock(b);
            }
        });
    }

    @Override
    public boolean execute() {
        this.assertState();
        RelocationRun top = (RelocationRun)this.mainStack().top();
        if (top.world() == null) {
            throw new IllegalStateException("World must be set before move.");
        }
        if (top.world().field_72995_K) {
            throw new IllegalStateException("Movements cannot be executed client-side.");
        }
        if (top.dir() == -1) {
            throw new IllegalStateException("Direction must be set before move.");
        }
        if (top.speed() <= 0.0) {
            throw new IllegalStateException("Speed must be greater than 0.");
        }
        if (top.speed() >= 1.0) {
            throw new IllegalStateException("Speed must be less than 1.");
        }
        if (top.blocks().isEmpty()) {
            throw new IllegalStateException("No blocks queued for move.");
        }
        return MovementManager2$.MODULE$.tryStartMove(top.world(), (scala.collection.immutable.Set<BlockCoord>)top.blocks().toSet(), top.dir(), top.speed(), top.callback());
    }

    private Relocator_Impl$() {
        MODULE$ = this;
        this.mainStack = new Stack();
        this.tempStack = new Stack();
    }
}

