/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;

@SideOnly(value=Side.CLIENT)
public final class ThEGuiHelper {
    public static final ThEGuiHelper INSTANCE = new ThEGuiHelper();
    public static final int MOUSE_BUTTON_LEFT = 0;
    public static final int MOUSE_BUTTON_RIGHT = 1;
    public static final int MOUSE_BUTTON_WHEEL = 2;
    public static final int MOUSE_WHEEL_MOTION = -2;
    private static final int COLOR_ARRAY_SIZE = 4;
    private final int[] COLOR_SHIFT_AMOUNT = new int[]{0, 8, 16, 24};
    private HashMap<Aspect, String> aspectChatColors = new HashMap();

    private ThEGuiHelper() {
        this.aspectChatColors.put(Aspect.AIR, EnumChatFormatting.YELLOW.toString());
        this.aspectChatColors.put(Aspect.WATER, EnumChatFormatting.AQUA.toString());
        this.aspectChatColors.put(Aspect.FIRE, EnumChatFormatting.RED.toString());
        this.aspectChatColors.put(Aspect.ORDER, EnumChatFormatting.GRAY.toString());
        this.aspectChatColors.put(Aspect.ENTROPY, EnumChatFormatting.DARK_GRAY.toString());
        this.aspectChatColors.put(Aspect.EARTH, EnumChatFormatting.GREEN.toString());
    }

    public static final void drawScaledText(FontRenderer fontRenderer, String text, float scale, float posX, float posY) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        float inverseScale = 1.0f / scale;
        int X = (int)((posX - (float)fontRenderer.func_78256_a(text) * scale) * inverseScale);
        int Y = (int)((posY - 7.0f * scale) * inverseScale);
        fontRenderer.func_78261_a(text, X, Y, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public final byte[] convertPackedColorToARGBb(int color) {
        byte[] colorBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            colorBytes[3 - i] = (byte)(color >> this.COLOR_SHIFT_AMOUNT[i] & 0xFF);
        }
        return colorBytes;
    }

    public final float[] convertPackedColorToARGBf(int color) {
        float[] colorFloats = new float[4];
        for (int i = 0; i < 4; ++i) {
            colorFloats[3 - i] = (float)(color >> this.COLOR_SHIFT_AMOUNT[i] & 0xFF) / 255.0f;
        }
        return colorFloats;
    }

    public final int[] createColorGradient(int fromColor, int toColor, int iterations) {
        if (iterations < 3) {
            return new int[]{fromColor, toColor};
        }
        int[] fromColorBytes = new int[4];
        int[] toColorBytes = new int[4];
        float[] stepAmount = new float[4];
        float[] currentColor = new float[4];
        int[] gradient = new int[iterations];
        for (int i = 0; i < 4; ++i) {
            fromColorBytes[i] = fromColor >> this.COLOR_SHIFT_AMOUNT[i] & 0xFF;
            toColorBytes[i] = toColor >> this.COLOR_SHIFT_AMOUNT[i] & 0xFF;
            stepAmount[i] = (float)(toColorBytes[i] - fromColorBytes[i]) / (float)iterations;
            currentColor[i] = fromColorBytes[i];
        }
        gradient[0] = fromColor;
        for (int iteration = 1; iteration < iterations; ++iteration) {
            int result = 0;
            for (int i = 0; i < 4; ++i) {
                int n = i;
                currentColor[n] = currentColor[n] + stepAmount[i];
                result += (Math.round(currentColor[i]) & 0xFF) << this.COLOR_SHIFT_AMOUNT[i];
            }
            gradient[iteration] = result;
        }
        gradient[iterations - 1] = toColor;
        return gradient;
    }

    public final String getAspectChatColor(Aspect aspect) {
        if (this.aspectChatColors.containsKey(aspect)) {
            return this.aspectChatColors.get(aspect);
        }
        return EnumChatFormatting.WHITE.toString();
    }

    public final boolean isPointInGuiRegion(int top, int left, int height, int width, int pointX, int pointY, int guiLeft, int guiTop) {
        return this.isPointInRegion(top, left, height, width, pointX - guiLeft, pointY - guiTop);
    }

    public final boolean isPointInRegion(int top, int left, int height, int width, int pointX, int pointY) {
        return pointX >= left && pointX <= left + width && pointY >= top && pointY <= top + height;
    }
}

