/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.syncer.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.syncer.FieldData;
import net.malisis.core.util.syncer.ISyncHandler;
import net.malisis.core.util.syncer.ISyncableData;
import net.malisis.core.util.syncer.Syncer;

@MalisisMessage
public class SyncerMessage
implements IMessageHandler<Packet, IMessage> {
    public SyncerMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            Object caller = message.handler.getReceiver(ctx, message.data);
            Syncer.get().updateValues(caller, message.handler, message.values);
        }
        return null;
    }

    public static class Packet<T>
    implements IMessage {
        private ISyncHandler<? super T, ? extends ISyncableData> handler;
        private ISyncableData data;
        private int indexes;
        private Map<String, Object> values;

        public Packet() {
        }

        public Packet(ISyncHandler<? super T, ? extends ISyncableData> handler, ISyncableData data, int fieldIndexes, Map<String, Object> fieldValues) {
            this.handler = handler;
            this.data = data;
            this.indexes = fieldIndexes;
            this.values = fieldValues;
        }

        public void fromBytes(ByteBuf buf) {
            this.handler = Syncer.get().getHandlerFromId(buf.readInt());
            if (this.handler == null) {
                return;
            }
            this.data = this.handler.getSyncData(null);
            this.data.fromBytes(buf);
            this.indexes = buf.readInt();
            this.values = new HashMap<String, Object>();
            int index = 0;
            while (this.indexes > 0) {
                if ((this.indexes & 1) != 0) {
                    Object data = null;
                    FieldData fd = this.handler.getFieldData(index);
                    Class<?> clazz = fd.getField().getType();
                    if (ISyncableData.class.isAssignableFrom(clazz)) {
                        if (buf.readBoolean()) {
                            try {
                                data = clazz.newInstance();
                                ((ISyncableData)data).fromBytes(buf);
                            }
                            catch (IllegalAccessException | InstantiationException e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (clazz == String.class) {
                        if (buf.readBoolean()) {
                            data = ByteBufUtils.readUTF8String((ByteBuf)buf);
                        }
                    } else if (clazz == Boolean.TYPE) {
                        data = buf.readBoolean();
                    } else if (clazz == Byte.TYPE) {
                        data = buf.readByte();
                    } else if (clazz == Integer.TYPE) {
                        data = buf.readInt();
                    } else if (clazz == Long.TYPE) {
                        data = buf.readLong();
                    } else if (clazz == Character.TYPE) {
                        data = Character.valueOf(buf.readChar());
                    } else if (clazz == Short.TYPE) {
                        data = buf.readShort();
                    } else if (clazz == Float.TYPE) {
                        data = Float.valueOf(buf.readFloat());
                    } else if (clazz == Double.TYPE) {
                        data = buf.readDouble();
                    }
                    this.values.put(fd.getName(), data);
                }
                this.indexes >>= 1;
                ++index;
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(Syncer.get().getHandlerId(this.handler));
            this.data.toBytes(buf);
            buf.writeInt(this.indexes);
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                Object obj = entry.getValue();
                if (obj == null) {
                    obj = false;
                    continue;
                }
                if (obj instanceof ISyncableData) {
                    buf.writeBoolean(true);
                    ((ISyncableData)obj).toBytes(buf);
                    continue;
                }
                if (obj instanceof String) {
                    buf.writeBoolean(true);
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)obj));
                    continue;
                }
                if (obj instanceof Boolean) {
                    buf.writeBoolean(((Boolean)obj).booleanValue());
                    continue;
                }
                if (obj instanceof Byte) {
                    buf.writeByte((int)((Byte)obj).byteValue());
                    continue;
                }
                if (obj instanceof Integer) {
                    buf.writeInt(((Integer)obj).intValue());
                    continue;
                }
                if (obj instanceof Long) {
                    buf.writeLong(((Long)obj).longValue());
                    continue;
                }
                if (obj instanceof Character) {
                    buf.writeChar((int)((Character)obj).charValue());
                    continue;
                }
                if (obj instanceof Short) {
                    buf.writeShort((int)((Short)obj).shortValue());
                    continue;
                }
                if (obj instanceof Float) {
                    buf.writeFloat(((Float)obj).floatValue());
                    continue;
                }
                if (!(obj instanceof Double)) continue;
                buf.writeDouble(((Double)obj).doubleValue());
            }
        }
    }
}

