/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import java.util.ArrayList;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;

public class ChainedTransformation
extends Transformation<ChainedTransformation, ITransformable> {
    protected ArrayList<Transformation> listTransformations = new ArrayList();

    public ChainedTransformation(Transformation ... transformations) {
        this.addTransformations(transformations);
    }

    public ChainedTransformation addTransformations(Transformation ... transformations) {
        this.duration = 0L;
        for (Transformation transformation : transformations) {
            this.duration += transformation.totalDuration();
            this.listTransformations.add(transformation);
        }
        return this;
    }

    @Override
    protected void doTransform(ITransformable transformable, float comp) {
        if (this.listTransformations.size() == 0) {
            return;
        }
        if (this.reversed) {
            this.elapsedTimeCurrentLoop = Math.max(0L, this.duration - this.elapsedTimeCurrentLoop);
        }
        for (Transformation transformation : this.listTransformations) {
            transformation.transform(transformable, this.elapsedTimeCurrentLoop);
            this.elapsedTimeCurrentLoop -= transformation.totalDuration();
        }
    }
}

